/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephClientLister helps list CephClients.
// All objects returned here must be treated as read-only.
type CephClientLister interface {
	// List lists all CephClients in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephClient, err error)
	// CephClients returns an object that can list and get CephClients.
	CephClients(namespace string) CephClientNamespaceLister
	CephClientListerExpansion
}

// cephClientLister implements the CephClientLister interface.
type cephClientLister struct {
	listers.ResourceIndexer[*v1.CephClient]
}

// NewCephClientLister returns a new CephClientLister.
func NewCephClientLister(indexer cache.Indexer) CephClientLister {
	return &cephClientLister{listers.New[*v1.CephClient](indexer, v1.Resource("cephclient"))}
}

// CephClients returns an object that can list and get CephClients.
func (s *cephClientLister) CephClients(namespace string) CephClientNamespaceLister {
	return cephClientNamespaceLister{listers.NewNamespaced[*v1.CephClient](s.ResourceIndexer, namespace)}
}

// CephClientNamespaceLister helps list and get CephClients.
// All objects returned here must be treated as read-only.
type CephClientNamespaceLister interface {
	// List lists all CephClients in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephClient, err error)
	// Get retrieves the CephClient from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephClient, error)
	CephClientNamespaceListerExpansion
}

// cephClientNamespaceLister implements the CephClientNamespaceLister
// interface.
type cephClientNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephClient]
}
