/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephFilesystemLister helps list CephFilesystems.
// All objects returned here must be treated as read-only.
type CephFilesystemLister interface {
	// List lists all CephFilesystems in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephFilesystem, err error)
	// CephFilesystems returns an object that can list and get CephFilesystems.
	CephFilesystems(namespace string) CephFilesystemNamespaceLister
	CephFilesystemListerExpansion
}

// cephFilesystemLister implements the CephFilesystemLister interface.
type cephFilesystemLister struct {
	listers.ResourceIndexer[*v1.CephFilesystem]
}

// NewCephFilesystemLister returns a new CephFilesystemLister.
func NewCephFilesystemLister(indexer cache.Indexer) CephFilesystemLister {
	return &cephFilesystemLister{listers.New[*v1.CephFilesystem](indexer, v1.Resource("cephfilesystem"))}
}

// CephFilesystems returns an object that can list and get CephFilesystems.
func (s *cephFilesystemLister) CephFilesystems(namespace string) CephFilesystemNamespaceLister {
	return cephFilesystemNamespaceLister{listers.NewNamespaced[*v1.CephFilesystem](s.ResourceIndexer, namespace)}
}

// CephFilesystemNamespaceLister helps list and get CephFilesystems.
// All objects returned here must be treated as read-only.
type CephFilesystemNamespaceLister interface {
	// List lists all CephFilesystems in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephFilesystem, err error)
	// Get retrieves the CephFilesystem from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephFilesystem, error)
	CephFilesystemNamespaceListerExpansion
}

// cephFilesystemNamespaceLister implements the CephFilesystemNamespaceLister
// interface.
type cephFilesystemNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephFilesystem]
}
