/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephObjectStoreLister helps list CephObjectStores.
// All objects returned here must be treated as read-only.
type CephObjectStoreLister interface {
	// List lists all CephObjectStores in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectStore, err error)
	// CephObjectStores returns an object that can list and get CephObjectStores.
	CephObjectStores(namespace string) CephObjectStoreNamespaceLister
	CephObjectStoreListerExpansion
}

// cephObjectStoreLister implements the CephObjectStoreLister interface.
type cephObjectStoreLister struct {
	listers.ResourceIndexer[*v1.CephObjectStore]
}

// NewCephObjectStoreLister returns a new CephObjectStoreLister.
func NewCephObjectStoreLister(indexer cache.Indexer) CephObjectStoreLister {
	return &cephObjectStoreLister{listers.New[*v1.CephObjectStore](indexer, v1.Resource("cephobjectstore"))}
}

// CephObjectStores returns an object that can list and get CephObjectStores.
func (s *cephObjectStoreLister) CephObjectStores(namespace string) CephObjectStoreNamespaceLister {
	return cephObjectStoreNamespaceLister{listers.NewNamespaced[*v1.CephObjectStore](s.ResourceIndexer, namespace)}
}

// CephObjectStoreNamespaceLister helps list and get CephObjectStores.
// All objects returned here must be treated as read-only.
type CephObjectStoreNamespaceLister interface {
	// List lists all CephObjectStores in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectStore, err error)
	// Get retrieves the CephObjectStore from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephObjectStore, error)
	CephObjectStoreNamespaceListerExpansion
}

// cephObjectStoreNamespaceLister implements the CephObjectStoreNamespaceLister
// interface.
type cephObjectStoreNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephObjectStore]
}
