/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephObjectStoreUserLister helps list CephObjectStoreUsers.
// All objects returned here must be treated as read-only.
type CephObjectStoreUserLister interface {
	// List lists all CephObjectStoreUsers in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectStoreUser, err error)
	// CephObjectStoreUsers returns an object that can list and get CephObjectStoreUsers.
	CephObjectStoreUsers(namespace string) CephObjectStoreUserNamespaceLister
	CephObjectStoreUserListerExpansion
}

// cephObjectStoreUserLister implements the CephObjectStoreUserLister interface.
type cephObjectStoreUserLister struct {
	listers.ResourceIndexer[*v1.CephObjectStoreUser]
}

// NewCephObjectStoreUserLister returns a new CephObjectStoreUserLister.
func NewCephObjectStoreUserLister(indexer cache.Indexer) CephObjectStoreUserLister {
	return &cephObjectStoreUserLister{listers.New[*v1.CephObjectStoreUser](indexer, v1.Resource("cephobjectstoreuser"))}
}

// CephObjectStoreUsers returns an object that can list and get CephObjectStoreUsers.
func (s *cephObjectStoreUserLister) CephObjectStoreUsers(namespace string) CephObjectStoreUserNamespaceLister {
	return cephObjectStoreUserNamespaceLister{listers.NewNamespaced[*v1.CephObjectStoreUser](s.ResourceIndexer, namespace)}
}

// CephObjectStoreUserNamespaceLister helps list and get CephObjectStoreUsers.
// All objects returned here must be treated as read-only.
type CephObjectStoreUserNamespaceLister interface {
	// List lists all CephObjectStoreUsers in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectStoreUser, err error)
	// Get retrieves the CephObjectStoreUser from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephObjectStoreUser, error)
	CephObjectStoreUserNamespaceListerExpansion
}

// cephObjectStoreUserNamespaceLister implements the CephObjectStoreUserNamespaceLister
// interface.
type cephObjectStoreUserNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephObjectStoreUser]
}
