/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephObjectZoneLister helps list CephObjectZones.
// All objects returned here must be treated as read-only.
type CephObjectZoneLister interface {
	// List lists all CephObjectZones in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectZone, err error)
	// CephObjectZones returns an object that can list and get CephObjectZones.
	CephObjectZones(namespace string) CephObjectZoneNamespaceLister
	CephObjectZoneListerExpansion
}

// cephObjectZoneLister implements the CephObjectZoneLister interface.
type cephObjectZoneLister struct {
	listers.ResourceIndexer[*v1.CephObjectZone]
}

// NewCephObjectZoneLister returns a new CephObjectZoneLister.
func NewCephObjectZoneLister(indexer cache.Indexer) CephObjectZoneLister {
	return &cephObjectZoneLister{listers.New[*v1.CephObjectZone](indexer, v1.Resource("cephobjectzone"))}
}

// CephObjectZones returns an object that can list and get CephObjectZones.
func (s *cephObjectZoneLister) CephObjectZones(namespace string) CephObjectZoneNamespaceLister {
	return cephObjectZoneNamespaceLister{listers.NewNamespaced[*v1.CephObjectZone](s.ResourceIndexer, namespace)}
}

// CephObjectZoneNamespaceLister helps list and get CephObjectZones.
// All objects returned here must be treated as read-only.
type CephObjectZoneNamespaceLister interface {
	// List lists all CephObjectZones in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephObjectZone, err error)
	// Get retrieves the CephObjectZone from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephObjectZone, error)
	CephObjectZoneNamespaceListerExpansion
}

// cephObjectZoneNamespaceLister implements the CephObjectZoneNamespaceLister
// interface.
type cephObjectZoneNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephObjectZone]
}
