/*
Copyright 2018 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

// Code generated by lister-gen. DO NOT EDIT.

package v1

import (
	v1 "github.com/rook/rook/pkg/apis/ceph.rook.io/v1"
	"k8s.io/apimachinery/pkg/labels"
	"k8s.io/client-go/listers"
	"k8s.io/client-go/tools/cache"
)

// CephRBDMirrorLister helps list CephRBDMirrors.
// All objects returned here must be treated as read-only.
type CephRBDMirrorLister interface {
	// List lists all CephRBDMirrors in the indexer.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephRBDMirror, err error)
	// CephRBDMirrors returns an object that can list and get CephRBDMirrors.
	CephRBDMirrors(namespace string) CephRBDMirrorNamespaceLister
	CephRBDMirrorListerExpansion
}

// cephRBDMirrorLister implements the CephRBDMirrorLister interface.
type cephRBDMirrorLister struct {
	listers.ResourceIndexer[*v1.CephRBDMirror]
}

// NewCephRBDMirrorLister returns a new CephRBDMirrorLister.
func NewCephRBDMirrorLister(indexer cache.Indexer) CephRBDMirrorLister {
	return &cephRBDMirrorLister{listers.New[*v1.CephRBDMirror](indexer, v1.Resource("cephrbdmirror"))}
}

// CephRBDMirrors returns an object that can list and get CephRBDMirrors.
func (s *cephRBDMirrorLister) CephRBDMirrors(namespace string) CephRBDMirrorNamespaceLister {
	return cephRBDMirrorNamespaceLister{listers.NewNamespaced[*v1.CephRBDMirror](s.ResourceIndexer, namespace)}
}

// CephRBDMirrorNamespaceLister helps list and get CephRBDMirrors.
// All objects returned here must be treated as read-only.
type CephRBDMirrorNamespaceLister interface {
	// List lists all CephRBDMirrors in the indexer for a given namespace.
	// Objects returned here must be treated as read-only.
	List(selector labels.Selector) (ret []*v1.CephRBDMirror, err error)
	// Get retrieves the CephRBDMirror from the indexer for a given namespace and name.
	// Objects returned here must be treated as read-only.
	Get(name string) (*v1.CephRBDMirror, error)
	CephRBDMirrorNamespaceListerExpansion
}

// cephRBDMirrorNamespaceLister implements the CephRBDMirrorNamespaceLister
// interface.
type cephRBDMirrorNamespaceLister struct {
	listers.ResourceIndexer[*v1.CephRBDMirror]
}
