---
title: Users
...

# List of projects using Meson

If you have a project that uses Meson that you want to add to this list, please [file a pull-request](https://github.com/mesonbuild/meson/edit/master/docs/markdown/Users.md) for it. All the software on this list is tested for regressions before release, so it's highly recommended that projects add themselves here. Some additional projects are
listed in the [`meson` GitHub topic](https://github.com/topics/meson).

 - [2048.cpp](https://github.com/plibither8/2048.cpp), a fully featured terminal version of the game "2048" written in C++
 - [Aravis](https://github.com/AravisProject/aravis), a glib/gobject based library for video acquisition using Genicam cameras
 - [Akira](https://github.com/akiraux/Akira), a native Linux app for UI and UX design built in Vala and Gtk
 - [AQEMU](https://github.com/tobimensch/aqemu), a Qt GUI for QEMU virtual machines, since version 0.9.3
 - [Arduino sample project](https://github.com/jpakkane/mesonarduino)
 - [bolt](https://gitlab.freedesktop.org/bolt/bolt), userspace daemon to enable security levels for Thunderbolt™ 3 on Linux
 - [Budgie Desktop](https://github.com/budgie-desktop/budgie-desktop), a desktop environment built on GNOME technologies
 - [Bzip2](https://gitlab.com/federicomenaquintero/bzip2), the bzip2 compressor/decompressor
 - [Cage](https://github.com/Hjdskes/cage), a Wayland kiosk
 - [casync](https://github.com/systemd/casync), Content-Addressable Data Synchronization Tool
 - [cinnamon-desktop](https://github.com/linuxmint/cinnamon-desktop), the cinnamon desktop library
 - [dav1d](https://code.videolan.org/videolan/dav1d), an AV1 decoder
 - [dbus-broker](https://github.com/bus1/dbus-broker), Linux D-Bus Message Broker
 - [DPDK](http://dpdk.org/browse/dpdk), Data Plane Development Kit, a set of libraries and drivers for fast packet processing
 - [DXVK](https://github.com/doitsujin/dxvk), a Vulkan-based Direct3D 11 implementation for Linux using Wine
 - [elementary OS](https://github.com/elementary/), Linux desktop oriented distribution 
 - [Emeus](https://github.com/ebassi/emeus), constraint based layout manager for GTK+
 - [ESP8266 Arduino sample project](https://github.com/trilader/arduino-esp8266-meson), sample project for using the ESP8266 Arduino port with Meson
 - [FeedReader](https://github.com/jangernert/FeedReader), a modern desktop application designed to complement existing web-based RSS accounts
 - [Fractal](https://wiki.gnome.org/Apps/Fractal/), a Matrix messaging client for GNOME
 - [Frida](https://github.com/frida/frida-core), a dynamic binary instrumentation toolkit
 - [fwupd](https://github.com/hughsie/fwupd), a simple daemon to allow session software to update firmware
 - [GameMode](https://github.com/FeralInteractive/gamemode), a daemon/lib combo for Linux that allows games to request a set of optimisations be temporarily applied to the host OS
 - [Geary](https://wiki.gnome.org/Apps/Geary), an email application built around conversations, for the GNOME 3 desktop.
 - [GLib](https://gitlab.gnome.org/GNOME/glib), cross-platform C library used by GTK+ and GStreamer (not the default yet)
 - [GNOME Boxes](https://gitlab.gnome.org/GNOME/gnome-boxes), a GNOME hypervisor
 - [GNOME Builder](https://gitlab.gnome.org/GNOME/gnome-builder), an IDE for the GNOME platform
 - [GNOME MPV](https://github.com/gnome-mpv/gnome-mpv), GNOME frontend to the mpv video player
 - [GNOME Recipes](https://gitlab.gnome.org/GNOME/recipes), application for cooking recipes
 - [GNOME Software](https://gitlab.gnome.org/GNOME/gnome-software), an app store for GNOME
 - [GNOME Twitch](https://github.com/vinszent/gnome-twitch), an app for viewing Twitch streams on GNOME desktop
 - [GNOME Usage](https://gitlab.gnome.org/GNOME/gnome-usage), a GNOME application for visualizing system resources
 - [GNU FriBidi](https://github.com/fribidi/fribidi), the open source implementation of the Unicode Bidirectional Algorithm
 - [Graphene](https://ebassi.github.io/graphene/), a thin type library for graphics
 - [Grilo](https://git.gnome.org/browse/grilo) and [Grilo plugins](https://git.gnome.org/browse/grilo-plugins), the Grilo multimedia framework
 - [GStreamer](https://cgit.freedesktop.org/gstreamer/gstreamer/), multimedia framework (not the default yet)
 - [GTK+](https://gitlab.gnome.org/GNOME/gtk), the multi-platform toolkit used by GNOME
 - [GtkDApp](https://gitlab.com/csoriano/GtkDApp), an application template for developing Flatpak apps with Gtk+ and D
 - [GVfs](https://git.gnome.org/browse/gvfs/), a userspace virtual filesystem designed to work with the I/O abstraction of GIO
 - [Hardcode-Tray](https://github.com/bil-elmoussaoui/Hardcode-Tray), fixes hardcoded tray icons in Linux
 - [HelenOS](http://helenos.org), a portable microkernel-based multiserver operating system
 - [HexChat](https://github.com/hexchat/hexchat), a cross-platform IRC client in C
 - [IGT](https://cgit.freedesktop.org/xorg/app/intel-gpu-tools/), Linux kernel graphics driver test suite
 - [Irssi](https://github.com/irssi/irssi), a terminal chat client in C
 - [iSH](https://github.com/tbodt/ish), Linux shell for iOS
 - [Janet](https://github.com/janet-lang/janet), a functional and imperative programming language and bytecode interpreter
 - [json](https://github.com/nlohmann/json), JSON for Modern C++
 - [JsonCpp](https://github.com/open-source-parsers/jsoncpp), a C++ library for interacting with JSON
 - [Json-glib](https://gitlab.gnome.org/GNOME/json-glib), GLib-based JSON manipulation library
 - [Kiwix libraries](https://github.com/kiwix/kiwix-lib)
 - [Knot Resolver](https://gitlab.labs.nic.cz/knot/knot-resolver), Full caching DNS resolver implementation
 - [Ksh](https://github.com/att/ast), a Korn Shell
 - [Lc0](https://github.com/LeelaChessZero/lc0), LeelaChessZero is a UCI-compliant chess engine designed to play chess via neural network
 - [libcamera](https://git.linuxtv.org/libcamera.git/), a library to handle complex cameras on Linux, ChromeOS and Android
 - [Libdrm](https://cgit.freedesktop.org/drm/libdrm/), a library for abstracting DRM kernel interfaces
 - [Libepoxy](https://github.com/anholt/libepoxy/), a library for handling OpenGL function pointer management
 - [libfuse](https://github.com/libfuse/libfuse), the reference implementation of the Linux FUSE (Filesystem in Userspace) interface
 - [Libgit2-glib](https://git.gnome.org/browse/libgit2-glib), a GLib wrapper for libgit2
 - [Libhttpseverywhere](https://git.gnome.org/browse/libhttpseverywhere), a library to enable httpseverywhere on any desktop app
 - [libmodulemd](https://github.com/fedora-modularity/libmodulemd), a GObject Introspected library for managing [Fedora Project](https://getfedora.org/) module metadata.
 - [Libosmscout](https://github.com/Framstag/libosmscout), a C++ library for offline map rendering, routing and location  
lookup based on OpenStreetMap data
 - [libspng](https://gitlab.com/randy408/libspng), a C library for reading and writing Portable Network Graphics (PNG) 
format files
 - [libui](https://github.com/andlabs/libui), a simple and portable (but not inflexible) GUI library in C that uses the native GUI technologies of each platform it supports
 - [Libva](https://github.com/intel/libva), an implementation for the VA (VIdeo Acceleration) API
 - [Libzim](https://github.com/openzim/libzim), the reference implementation for the ZIM file format
 - [Marker](https://github.com/fabiocolacio/Marker), a GTK-3 markdown editor
 - [Mesa](https://gitlab.freedesktop.org/mesa/mesa/), an open source graphics driver project
 - [MiracleCast](https://github.com/albfan/miraclecast), connect external monitors to your system via Wifi-Display specification aka Miracast
 - [Nautilus](https://gitlab.gnome.org/GNOME/nautilus), the GNOME file manager
 - [Nemo](https://github.com/linuxmint/nemo), the file manager for the Cinnamon desktop environment
 - [oomd](https://github.com/facebookincubator/oomd), a userspace Out-Of-Memory (OOM) killer for Linux systems 
 - [OpenH264](https://github.com/cisco/openh264), open source H.264 codec
 - [OpenHMD](https://github.com/OpenHMD/OpenHMD), a free and open source API and drivers for immersive technology, such as head mounted displays with built in head tracking
 - [Orc](http://cgit.freedesktop.org/gstreamer/orc/), the Optimized Inner Loop Runtime Compiler (not the default yet)
 - [OTS](https://github.com/khaledhosny/ots), the OpenType Sanitizer, parses and serializes OpenType files (OTF, TTF) and WOFF and WOFF2 font files, validating and sanitizing them as it goes. Used by Chromium and Firefox
 - [Outlier](https://github.com/kerolasa/outlier), a small Hello World style meson example project
 - [Pango](https://git.gnome.org/browse/pango/), an Internationalized text layout and rendering library (not the default yet)
 - [Parzip](https://github.com/jpakkane/parzip), a multithreaded reimplementation of Zip
 - [Peek](https://github.com/phw/peek), simple animated GIF screen recorder with an easy to use interface
 - [PipeWire](https://github.com/PipeWire/pipewire), a framework for video and audio for containerized applications
 - [Pithos](https://github.com/pithos/pithos), a Pandora Radio client
 - [Pitivi](https://github.com/pitivi/pitivi/), a nonlinear video editor
 - [Playerctl](https://github.com/acrisci/playerctl), mpris command-line controller and library for spotify, vlc, audacious, bmp, cmus, and others
 - [Polari](https://gitlab.gnome.org/GNOME/polari), an IRC client
 - [radare2](https://github.com/radare/radare2), unix-like reverse engineering framework and commandline tools (not the default)
 - [RxDock](https://gitlab.com/rxdock/rxdock), a protein-ligand docking software designed for high throughput virtual screening (fork of rDock)
 - [SSHFS](https://github.com/libfuse/sshfs), allows you to mount a remote filesystem using SFTP
 - [sway](https://github.com/swaywm/sway), i3-compatible Wayland compositor
 - [Sysprof](https://git.gnome.org/browse/sysprof), a profiling tool
 - [systemd](https://github.com/systemd/systemd), the init system
 - [szl](https://github.com/dimkr/szl), a lightweight, embeddable scripting language
 - [Taisei Project](https://taisei-project.org/), an open-source Touhou Project clone and fangame
 - [Terminology](https://github.com/billiob/terminology), a terminal emulator based on the Enlightenment Foundation Libraries
 - [Tilix](https://github.com/gnunn1/tilix), a tiling terminal emulator for Linux using GTK+ 3
 - [Valum](https://github.com/valum-framework/valum), a micro web framework written in Vala
 - [Wayland and Weston](https://lists.freedesktop.org/archives/wayland-devel/2016-November/031984.html), a next generation display server (not merged yet)
 - [wlroots](https://github.com/swaywm/wlroots), a modular Wayland compositor library
 - [wxFormBuilder](https://github.com/wxFormBuilder/wxFormBuilder), RAD tool for wxWidgets GUI design
 - [xi-gtk](https://github.com/eyelash/xi-gtk), a GTK+ front-end for the Xi editor
 - [Xorg](https://cgit.freedesktop.org/xorg/xserver/), the X.org display server (not the default yet)
 - [zathura](https://github.com/pwmt/zathura), a highly customizable and functional document viewer based on the
girara user interface library and several document libraries
 - [ZStandard](https://github.com/facebook/zstd/commit/4dca56ed832c6a88108a2484a8f8ff63d8d76d91), a compression algorithm developed at Facebook (not used by default)

Note that a more up-to-date list of GNOME projects that use Meson can be found [here](https://wiki.gnome.org/Initiatives/GnomeGoals/MesonPorting).
