# GRR Google Summer of Code 2021 Project Ideas

GRR has been accepted as a hosting organization for Google Summer of Code 2021.

This page contains a list of possible project ideas.

## Next-generation Windows Registry support

Possible mentor: [panhania](https://github.com/panhania)

The existing support for reading/searching Windows Registry in GRR
is quite lacking: it builds on poorly chosen abstractions and the
implementation is buggy. Given how important Windows Registry is in the Windows
ecosystem, this significantly limits GRR's forensic capabilities. The goal of
the project would be to build a set of completely new functionalities without
looking back at the existing implementation or trying to be backward
compatible.

The project involves:

* Implementing a set of new “client actions” for the GRR
security agent to read/search Windows registry (“actions” are the fundamental
primitives that the GRR agent exposes and makes it possible to extract
information from a particular machine).
* Implement a set of new [“flows”](https://grr-doc.readthedocs.io/en/latest/investigating-with-grr/flows/index.html) to work
with implemented client actions (“flows” are effectively state-machines on the
GRR backend used to orchestrate multiple client actions).
* (Stretch goal) Add
support for “raw” mode into the implemented client actions. In “raw mode” GRR
agent won’t rely on Windows registry calls, but would rather parse the registry
directly.

## Modern user interface for YARA memory scans

Possible mentors: [mbushkov](https://github.com/mbushkov),
[max-vogler](https://github.com/max-vogler)

One core GRR digital forensics workflow is scanning the memory of a process for
indicators of malware using [YARA](https://virustotal.github.io/yara/). With
GRR's existing user interface, security analysts need to navigate a complex and
dated application to configure YARA scans. In this project, you will write an
effective, modern user interface to configure the workflow and show its live
progress and results using Angular, TypeScript, and Material Design.

## FUSE filesystem based on GRR’s API

Possible mentor: [mol123](https://github.com/mol123)

Users (security engineers) use GRR to collect artifacts, such as files,
registry entries, etc. from machines of interest. The primary way of accessing
the collected artifacts is via a web-based UI. Alternatively, we provide a
web-based API
([docs](https://storage.googleapis.com/autobuilds-grr-openapi/documentation/openapi_documentation.html]))
for programmatic access. The goal of this project is to expose the web-based
API as a
[FUSE](https://en.wikipedia.org/wiki/Filesystem_in_Userspace)
filesystem. This would enable users to mount GRR as a filesystem, access the
machines under investigation as directories, and access the artifacts collected
from machines using native tools installed on their operating system.

## Flexible repacking of MacOS GRR templates

Possible mentors: [mbushkov](https://github.com/mbushkov),
[mol123](https://github.com/mol123)

GRR consists of an agent that is installed on target systems, and the server
infrastructure that can manage and talk to clients. To make deployment of
agents easier, GRR offers a repacking mechanism for agent installers. The
“repacking” is generating agent installers from prebuilt installer templates
shipped with the GRR server. During the repacking, a deployment-specific
configuration file is added to the agent installer and, optionally, a GRR
binary is renamed. Renaming a binary is important for large organizations that
might ship differently named binaries to different sub-orgs, and also for
security reasons, to make it impossible for malware to target GRR process based
on the binary name.

While GRR installer templates are built on target platforms (Windows, MacOS,
Ubuntu, RedHat), repacking always happens on the GRR backend (Ubuntu).
Currently we support only a limited repacking process for MacOS, and the GRR
binary can’t be renamed during the repacking. The goal of the project will be
to develop a pure-Python solution that will be able to unpack the MacOS
installer template, make necessary changes and repack it into a ready-to-use
installer. The repacking process will need to be flexible enough to support
renaming and, possibly, inclusion of arbitrary additional files into the
installer.

