# !/bin/bash
#
# Copyright IBM Corp. All Rights Reserved.
#
# SPDX-License-Identifier: Apache-2.0
#
RC=0
CADOMAIN="FVT"
: ${TESTCASE:="crl_limit"}
FABRIC_CA="$GOPATH/src/github.com/hyperledger/fabric-ca"
SCRIPTDIR="$FABRIC_CA/scripts/fvt"
. $SCRIPTDIR/fabric-ca_utils
rm -rf /tmp/$TESTCASE/ /tmp/CAs/$CADOMAIN /$CADOMAIN/crl/crl.pem
export CA_CFG_PATH=/tmp/$TESTCASE
export FABRIC_CA_CLIENT_HOME=$CA_CFG_PATH/admin
mkdir -p /$CADOMAIN/crl/
localip=127.0.0.1
fabricport=$CA_DEFAULT_PORT
httpPort=3755
ca_keyfile="/root/$CADOMAIN-key.pem"
ca_certfile="/root/$CADOMAIN-cert.pem"
hacker_admin_keyfile="/root/adminkey.pem"
hacker_admin_certfile="/root/admincert.pem"
CRLSIZELIMIT=10
TIMEOUT=10
LOGFILE="/tmp/$TESTCASE/serverlog.txt"
AUTHFAIL="20"
REVOKEFAIL="29"
REVOKEREASON="failed to fetch CRL: Error reading CRL with max buffer size of $CRLSIZELIMIT: Size of requested data is too large"

checkMsg() {
awk -v rc=-1 -v m="$1" '
   $0~m { rc=0 }
        { print }
   END  { exit rc }'
}

function certGen {
# Create a Root CA certificate with a cdp extension
$SCRIPTDIR/utils/pki -f newca -p cacert -t ec -l 256 -a $CADOMAIN \
   -n '/C=US/ST=North Carolina/O=Hyperledger/OU=Fabric/CN=fabric-ca-server/' \
   -S "IP:127.0.0.2,DNS:server.fabric.raleigh.ibm.com,email:fabric-ca-server@fab-client.raleigh.ibm.com"
# Create a user cert using the Root CA
$SCRIPTDIR/utils/pki -f newcert -p admin -t ec -l 256 -a $CADOMAIN \
   -n '/C=US/ST=North Carolina/O=Hyperledger/OU=Fabric/CN=admin/' \
   -S "IP:127.0.0.2,DNS:admin.fabric.raleigh.ibm.com,email:admin@fab-client.raleigh.ibm.com" <<EOF
Y
Y
EOF
  rm $FABRIC_CA/testdata/openssl.cnf.base.req
}

function testDefault {
   # Test default limit of 512000 bytes
   export FABRIC_CA_SERVER_CRLSIZELIMIT=""
   # Start the default server and check to see if CRL retrieval works
   # if size limit is appropriate. However, register will fail because
   #  we used a 'hacked' enrollment certificate
   $SCRIPTDIR/fabric-ca_setup.sh -I -X -S -D -c $ca_certfile -k $ca_keyfile
   enroll
   admin_keyfile="$(find /tmp/$TESTCASE/admin/msp/keystore -type f)"
   admin_certfile="/tmp/$TESTCASE/admin/msp/signcerts/cert.pem"
   cp $hacker_admin_keyfile $admin_keyfile
   cp $hacker_admin_certfile $admin_certfile
   register admin user1 2>&1 | checkMsg "$AUTHFAIL"
}

function testLimit {
  # Lower the CRL size limit on server and check to see that the
  # server does not continue to proceed with retrieving CRL list
  export FABRIC_CA_SERVER_CRLSIZELIMIT=$1
  cd $GOPATH/src/github.com/hyperledger/fabric-ca
  $SCRIPTDIR/fabric-ca_setup.sh -K
  $SCRIPTDIR/fabric-ca_setup.sh -S -D -X -c $ca_certfile -k $ca_keyfile 2>&1 | tee $LOGFILE &
  pollLogForMsg "Listening on https*://0.0.0.0:$CA_DEFAULT_PORT" $LOGFILE || ErrorExit "Failed to log CA"
  enroll admin2 adminpw2
  admin_keyfile="$(find /tmp/$TESTCASE/admin/msp/keystore -type f)"
  admin_certfile="/tmp/$TESTCASE/admin/msp/signcerts/cert.pem"
  cp $hacker_admin_keyfile $admin_keyfile
  cp $hacker_admin_certfile $admin_certfile
  register admin user2 client bank_a "" /tmp/$TESTCASE/admin2 2>&1 | checkMsg "$REVOKEFAIL"
  test $? -ne 0 && ErrorMsg "Failed to return correct error"
  grep -q "$REVOKEREASON" $LOGFILE
}

c_dir=$(pwd)
cp $GOPATH/src/github.com/hyperledger/fabric-ca/testdata/crl.pem /$CADOMAIN/crl/crl.pem
cd /
python -m SimpleHTTPServer $httpPort &
HTTP_PID=$!
pollSimpleHttp
cd $c_dir

trap "kill $HTTP_PID; rm -rf /tmp/$TESTCASE/ /tmp/CAs/$CADOMAIN /$CADOMAIN/crl/crl.pem; CleanUp 1; exit 1" INT

# Start of main test
   certGen   || ErrorExit "Failed to generate certitificates and keys"
   testDefault  || ErrorMsg "Failed to return correct error"
   testLimit $CRLSIZELIMIT || ErrorMsg "Client authentication failed for other reason than CRL size"
kill $HTTP_PID
CleanUp $RC
exit $RC
