# What is block-listener
block-listener.go will connect to a peer and receive blocks events, transaction rejection events and chaincode events (if a chaincode emits events).

# To Run
```sh
1. go build

2. ./block-listener -events-address=< event address > -listen-to-rejections=< true | false > -events-from-chaincode=< chaincode ID >
```

# Example with PBFT

## Run 4 docker peers with PBFT
```sh
docker run --rm -it -e CORE_VM_ENDPOINT=http://172.17.0.1:2375 -e CORE_PEER_ID=vp0 -e CORE_PEER_ADDRESSAUTODETECT=true -e CORE_PEER_VALIDATOR_CONSENSUS_PLUGIN=pbft hyperledger/fabric-peer peer node start

docker run --rm -it -e CORE_VM_ENDPOINT=http://172.17.0.1:2375 -e CORE_PEER_ID=vp1 -e CORE_PEER_ADDRESSAUTODETECT=true -e CORE_PEER_DISCOVERY_ROOTNODE=172.17.0.2:7051 -e CORE_PEER_VALIDATOR_CONSENSUS_PLUGIN=pbft hyperledger/fabric-peer peer node start

docker run --rm -it -e CORE_VM_ENDPOINT=http://172.17.0.1:2375 -e CORE_PEER_ID=vp2 -e CORE_PEER_ADDRESSAUTODETECT=true -e CORE_PEER_DISCOVERY_ROOTNODE=172.17.0.2:7051 -e CORE_PEER_VALIDATOR_CONSENSUS_PLUGIN=pbft hyperledger/fabric-peer peer node start

docker run --rm -it -e CORE_VM_ENDPOINT=http://172.17.0.1:2375 -e CORE_PEER_ID=vp3 -e CORE_PEER_ADDRESSAUTODETECT=true -e CORE_PEER_DISCOVERY_ROOTNODE=172.17.0.2:7051 -e CORE_PEER_VALIDATOR_CONSENSUS_PLUGIN=pbft hyperledger/fabric-peer peer node start

## Attach event client to a Peer
```sh
./block-listener -events-address=172.17.0.2:7053 -listen-to-rejections=true
```

Event client should output "Event Address: 172.17.0.2:7053" and wait for events.

## Create a deploy transaction
Submit a transaction to deploy chaincode_example02.

```sh
CORE_PEER_ADDRESS=172.17.0.2:7051 peer chaincode deploy -p github.com/hyperledger/fabric/examples/chaincode/go/chaincode_example02 -c '{"Function":"init", "Args": ["a","100", "b", "200"]}'
```

Notice success transaction in the events client.

## Create an invoke transaction - good
Send a valid invoke transaction to chaincode_example02.

```sh
CORE_PEER_ADDRESS=172.17.0.2:7051 peer chaincode invoke -n 1edd7021ab71b766f4928a9ef91182c018dffb86fef7a4b5a5516ac590a87957e21a62d939df817f5105f524abddcddfc7b1a60d780f02d8235bd7af9db81b66 -c '{"Function":"invoke", "Args": ["a","b","10"]}'
```
Notice success transaction in events client.

## Create an invoke transaction - bad
Send an invoke transaction with invalid parameters to chaincode_example02.

```sh
CORE_PEER_ADDRESS=172.17.0.2:7051 peer chaincode invoke -n 1edd7021ab71b766f4928a9ef91182c018dffb86fef7a4b5a5516ac590a87957e21a62d939df817f5105f524abddcddfc7b1a60d780f02d8235bd7af9db81b66 -c '{"Function":"invoke", "Args": ["a","b"]}'
```

Notice error transaction in events client.

# Tesing chaincode events
Chaincode github.com/hyperledger/fabric/examples/chaincode/go/eventsender can be used to test event sender.
## Deploy eventsender chaincode
Stop the event listener and restart it as follows  

```
CORE_PEER_ADDRESS=172.17.0.2:7051 ./peer chaincode deploy -p github.com/hyperledger/fabric/examples/chaincode/go/eventsender -c '{"Function":"init", "Args":[]}'
```

```
Note the chaincode ID of the eventsender chaincode. This will be used in the commands below.
```
## Restart event listener
Stop the event listener if running and restart it with `-events-from-chaincode` option

```sh
./block-listener -events-address=172.17.0.2:7053 -listen-to-rejections=true -events-from-chaincode=< event sender chaincode ID>
```


##Send an invoke request to event sender

```sh
CORE_PEER_ADDRESS=172.17.0.2:7051 ./peer chaincode invoke -n < eventsender chaincode ID > -c '{"Function":"greet", "Args":["hello","world"]}'
```

Note the output from the event listener terminal showing a chaincode event from the event sender chaincode in addition to the block event generated by the transaction.
