// Code generated by protoc-gen-go.
// source: common/common.proto
// DO NOT EDIT!

/*
Package common is a generated protocol buffer package.

It is generated from these files:
	common/common.proto
	common/configtx.proto
	common/configuration.proto
	common/ledger.proto
	common/msp_principal.proto
	common/policies.proto

It has these top-level messages:
	LastConfig
	Metadata
	MetadataSignature
	Header
	ChannelHeader
	SignatureHeader
	Payload
	Envelope
	Block
	BlockHeader
	BlockData
	BlockMetadata
	ConfigEnvelope
	ConfigGroupSchema
	ConfigValueSchema
	ConfigPolicySchema
	Config
	ConfigUpdateEnvelope
	ConfigUpdate
	ConfigGroup
	ConfigValue
	ConfigPolicy
	ConfigSignature
	HashingAlgorithm
	BlockDataHashingStructure
	OrdererAddresses
	BlockchainInfo
	MSPPrincipal
	OrganizationUnit
	MSPRole
	Policy
	SignaturePolicyEnvelope
	SignaturePolicy
	ImplicitMetaPolicy
*/
package common

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import google_protobuf "github.com/golang/protobuf/ptypes/timestamp"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// These status codes are intended to resemble selected HTTP status codes
type Status int32

const (
	Status_UNKNOWN                  Status = 0
	Status_SUCCESS                  Status = 200
	Status_BAD_REQUEST              Status = 400
	Status_FORBIDDEN                Status = 403
	Status_NOT_FOUND                Status = 404
	Status_REQUEST_ENTITY_TOO_LARGE Status = 413
	Status_INTERNAL_SERVER_ERROR    Status = 500
	Status_SERVICE_UNAVAILABLE      Status = 503
)

var Status_name = map[int32]string{
	0:   "UNKNOWN",
	200: "SUCCESS",
	400: "BAD_REQUEST",
	403: "FORBIDDEN",
	404: "NOT_FOUND",
	413: "REQUEST_ENTITY_TOO_LARGE",
	500: "INTERNAL_SERVER_ERROR",
	503: "SERVICE_UNAVAILABLE",
}
var Status_value = map[string]int32{
	"UNKNOWN":                  0,
	"SUCCESS":                  200,
	"BAD_REQUEST":              400,
	"FORBIDDEN":                403,
	"NOT_FOUND":                404,
	"REQUEST_ENTITY_TOO_LARGE": 413,
	"INTERNAL_SERVER_ERROR":    500,
	"SERVICE_UNAVAILABLE":      503,
}

func (x Status) String() string {
	return proto.EnumName(Status_name, int32(x))
}
func (Status) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

type HeaderType int32

const (
	HeaderType_MESSAGE              HeaderType = 0
	HeaderType_CONFIG               HeaderType = 1
	HeaderType_CONFIG_UPDATE        HeaderType = 2
	HeaderType_ENDORSER_TRANSACTION HeaderType = 3
	HeaderType_ORDERER_TRANSACTION  HeaderType = 4
	HeaderType_DELIVER_SEEK_INFO    HeaderType = 5
)

var HeaderType_name = map[int32]string{
	0: "MESSAGE",
	1: "CONFIG",
	2: "CONFIG_UPDATE",
	3: "ENDORSER_TRANSACTION",
	4: "ORDERER_TRANSACTION",
	5: "DELIVER_SEEK_INFO",
}
var HeaderType_value = map[string]int32{
	"MESSAGE":              0,
	"CONFIG":               1,
	"CONFIG_UPDATE":        2,
	"ENDORSER_TRANSACTION": 3,
	"ORDERER_TRANSACTION":  4,
	"DELIVER_SEEK_INFO":    5,
}

func (x HeaderType) String() string {
	return proto.EnumName(HeaderType_name, int32(x))
}
func (HeaderType) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

// This enum enlists indexes of the block metadata array
type BlockMetadataIndex int32

const (
	BlockMetadataIndex_SIGNATURES          BlockMetadataIndex = 0
	BlockMetadataIndex_LAST_CONFIG         BlockMetadataIndex = 1
	BlockMetadataIndex_TRANSACTIONS_FILTER BlockMetadataIndex = 2
	BlockMetadataIndex_ORDERER             BlockMetadataIndex = 3
)

var BlockMetadataIndex_name = map[int32]string{
	0: "SIGNATURES",
	1: "LAST_CONFIG",
	2: "TRANSACTIONS_FILTER",
	3: "ORDERER",
}
var BlockMetadataIndex_value = map[string]int32{
	"SIGNATURES":          0,
	"LAST_CONFIG":         1,
	"TRANSACTIONS_FILTER": 2,
	"ORDERER":             3,
}

func (x BlockMetadataIndex) String() string {
	return proto.EnumName(BlockMetadataIndex_name, int32(x))
}
func (BlockMetadataIndex) EnumDescriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

// LastConfig is the encoded value for the Metadata message which is encoded in the LAST_CONFIGURATION block metadata index
type LastConfig struct {
	Index uint64 `protobuf:"varint,1,opt,name=index" json:"index,omitempty"`
}

func (m *LastConfig) Reset()                    { *m = LastConfig{} }
func (m *LastConfig) String() string            { return proto.CompactTextString(m) }
func (*LastConfig) ProtoMessage()               {}
func (*LastConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// Metadata is a common structure to be used to encode block metadata
type Metadata struct {
	Value      []byte               `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
	Signatures []*MetadataSignature `protobuf:"bytes,2,rep,name=signatures" json:"signatures,omitempty"`
}

func (m *Metadata) Reset()                    { *m = Metadata{} }
func (m *Metadata) String() string            { return proto.CompactTextString(m) }
func (*Metadata) ProtoMessage()               {}
func (*Metadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *Metadata) GetSignatures() []*MetadataSignature {
	if m != nil {
		return m.Signatures
	}
	return nil
}

type MetadataSignature struct {
	SignatureHeader []byte `protobuf:"bytes,1,opt,name=signature_header,json=signatureHeader,proto3" json:"signature_header,omitempty"`
	Signature       []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (m *MetadataSignature) Reset()                    { *m = MetadataSignature{} }
func (m *MetadataSignature) String() string            { return proto.CompactTextString(m) }
func (*MetadataSignature) ProtoMessage()               {}
func (*MetadataSignature) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

type Header struct {
	ChannelHeader   []byte `protobuf:"bytes,1,opt,name=channel_header,json=channelHeader,proto3" json:"channel_header,omitempty"`
	SignatureHeader []byte `protobuf:"bytes,2,opt,name=signature_header,json=signatureHeader,proto3" json:"signature_header,omitempty"`
}

func (m *Header) Reset()                    { *m = Header{} }
func (m *Header) String() string            { return proto.CompactTextString(m) }
func (*Header) ProtoMessage()               {}
func (*Header) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// Header is a generic replay prevention and identity message to include in a signed payload
type ChannelHeader struct {
	Type int32 `protobuf:"varint,1,opt,name=type" json:"type,omitempty"`
	// Version indicates message protocol version
	Version int32 `protobuf:"varint,2,opt,name=version" json:"version,omitempty"`
	// Timestamp is the local time when the message was created
	// by the sender
	Timestamp *google_protobuf.Timestamp `protobuf:"bytes,3,opt,name=timestamp" json:"timestamp,omitempty"`
	// Identifier of the channel this message is bound for
	ChannelId string `protobuf:"bytes,4,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	// An unique identifier that is used end-to-end.
	//  -  set by higher layers such as end user or SDK
	//  -  passed to the endorser (which will check for uniqueness)
	//  -  as the header is passed along unchanged, it will be
	//     be retrieved by the committer (uniqueness check here as well)
	//  -  to be stored in the ledger
	TxId string `protobuf:"bytes,5,opt,name=tx_id,json=txId" json:"tx_id,omitempty"`
	// The epoch in which this header was generated, where epoch is defined based on block height
	// Epoch in which the response has been generated. This field identifies a
	// logical window of time. A proposal response is accepted by a peer only if
	// two conditions hold:
	// 1. the epoch specified in the message is the current epoch
	// 2. this message has been only seen once during this epoch (i.e. it hasn't
	//    been replayed)
	Epoch uint64 `protobuf:"varint,6,opt,name=epoch" json:"epoch,omitempty"`
	// Extension that may be attached based on the header type
	Extension []byte `protobuf:"bytes,7,opt,name=extension,proto3" json:"extension,omitempty"`
}

func (m *ChannelHeader) Reset()                    { *m = ChannelHeader{} }
func (m *ChannelHeader) String() string            { return proto.CompactTextString(m) }
func (*ChannelHeader) ProtoMessage()               {}
func (*ChannelHeader) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func (m *ChannelHeader) GetTimestamp() *google_protobuf.Timestamp {
	if m != nil {
		return m.Timestamp
	}
	return nil
}

type SignatureHeader struct {
	// Creator of the message, specified as a certificate chain
	Creator []byte `protobuf:"bytes,1,opt,name=creator,proto3" json:"creator,omitempty"`
	// Arbitrary number that may only be used once. Can be used to detect replay attacks.
	Nonce []byte `protobuf:"bytes,2,opt,name=nonce,proto3" json:"nonce,omitempty"`
}

func (m *SignatureHeader) Reset()                    { *m = SignatureHeader{} }
func (m *SignatureHeader) String() string            { return proto.CompactTextString(m) }
func (*SignatureHeader) ProtoMessage()               {}
func (*SignatureHeader) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{5} }

// Payload is the message contents (and header to allow for signing)
type Payload struct {
	// Header is included to provide identity and prevent replay
	Header *Header `protobuf:"bytes,1,opt,name=header" json:"header,omitempty"`
	// Data, the encoding of which is defined by the type in the header
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (m *Payload) Reset()                    { *m = Payload{} }
func (m *Payload) String() string            { return proto.CompactTextString(m) }
func (*Payload) ProtoMessage()               {}
func (*Payload) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{6} }

func (m *Payload) GetHeader() *Header {
	if m != nil {
		return m.Header
	}
	return nil
}

// Envelope wraps a Payload with a signature so that the message may be authenticated
type Envelope struct {
	// A marshaled Payload
	Payload []byte `protobuf:"bytes,1,opt,name=payload,proto3" json:"payload,omitempty"`
	// A signature by the creator specified in the Payload header
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (m *Envelope) Reset()                    { *m = Envelope{} }
func (m *Envelope) String() string            { return proto.CompactTextString(m) }
func (*Envelope) ProtoMessage()               {}
func (*Envelope) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{7} }

// This is finalized block structure to be shared among the orderer and peer
// Note that the BlockHeader chains to the previous BlockHeader, and the BlockData hash is embedded
// in the BlockHeader.  This makes it natural and obvious that the Data is included in the hash, but
// the Metadata is not.
type Block struct {
	Header   *BlockHeader   `protobuf:"bytes,1,opt,name=header" json:"header,omitempty"`
	Data     *BlockData     `protobuf:"bytes,2,opt,name=data" json:"data,omitempty"`
	Metadata *BlockMetadata `protobuf:"bytes,3,opt,name=metadata" json:"metadata,omitempty"`
}

func (m *Block) Reset()                    { *m = Block{} }
func (m *Block) String() string            { return proto.CompactTextString(m) }
func (*Block) ProtoMessage()               {}
func (*Block) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{8} }

func (m *Block) GetHeader() *BlockHeader {
	if m != nil {
		return m.Header
	}
	return nil
}

func (m *Block) GetData() *BlockData {
	if m != nil {
		return m.Data
	}
	return nil
}

func (m *Block) GetMetadata() *BlockMetadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

// BlockHeader is the element of the block which forms the block chain
// The block header is hashed using the configured chain hashing algorithm
// over the ASN.1 encoding of the BlockHeader
type BlockHeader struct {
	Number       uint64 `protobuf:"varint,1,opt,name=number" json:"number,omitempty"`
	PreviousHash []byte `protobuf:"bytes,2,opt,name=previous_hash,json=previousHash,proto3" json:"previous_hash,omitempty"`
	DataHash     []byte `protobuf:"bytes,3,opt,name=data_hash,json=dataHash,proto3" json:"data_hash,omitempty"`
}

func (m *BlockHeader) Reset()                    { *m = BlockHeader{} }
func (m *BlockHeader) String() string            { return proto.CompactTextString(m) }
func (*BlockHeader) ProtoMessage()               {}
func (*BlockHeader) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{9} }

type BlockData struct {
	Data [][]byte `protobuf:"bytes,1,rep,name=data,proto3" json:"data,omitempty"`
}

func (m *BlockData) Reset()                    { *m = BlockData{} }
func (m *BlockData) String() string            { return proto.CompactTextString(m) }
func (*BlockData) ProtoMessage()               {}
func (*BlockData) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{10} }

type BlockMetadata struct {
	Metadata [][]byte `protobuf:"bytes,1,rep,name=metadata,proto3" json:"metadata,omitempty"`
}

func (m *BlockMetadata) Reset()                    { *m = BlockMetadata{} }
func (m *BlockMetadata) String() string            { return proto.CompactTextString(m) }
func (*BlockMetadata) ProtoMessage()               {}
func (*BlockMetadata) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{11} }

func init() {
	proto.RegisterType((*LastConfig)(nil), "common.LastConfig")
	proto.RegisterType((*Metadata)(nil), "common.Metadata")
	proto.RegisterType((*MetadataSignature)(nil), "common.MetadataSignature")
	proto.RegisterType((*Header)(nil), "common.Header")
	proto.RegisterType((*ChannelHeader)(nil), "common.ChannelHeader")
	proto.RegisterType((*SignatureHeader)(nil), "common.SignatureHeader")
	proto.RegisterType((*Payload)(nil), "common.Payload")
	proto.RegisterType((*Envelope)(nil), "common.Envelope")
	proto.RegisterType((*Block)(nil), "common.Block")
	proto.RegisterType((*BlockHeader)(nil), "common.BlockHeader")
	proto.RegisterType((*BlockData)(nil), "common.BlockData")
	proto.RegisterType((*BlockMetadata)(nil), "common.BlockMetadata")
	proto.RegisterEnum("common.Status", Status_name, Status_value)
	proto.RegisterEnum("common.HeaderType", HeaderType_name, HeaderType_value)
	proto.RegisterEnum("common.BlockMetadataIndex", BlockMetadataIndex_name, BlockMetadataIndex_value)
}

func init() { proto.RegisterFile("common/common.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 870 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x84, 0x55, 0xdd, 0x6e, 0xe3, 0x44,
	0x14, 0xae, 0xe3, 0xfc, 0x34, 0xc7, 0x4d, 0x3b, 0x9d, 0x6c, 0x59, 0x53, 0x58, 0x6d, 0x64, 0xb4,
	0xa8, 0xb4, 0x22, 0x11, 0xe5, 0x06, 0x2e, 0x9d, 0x78, 0xd2, 0xb5, 0x36, 0x6b, 0x2f, 0x63, 0x67,
	0x11, 0xbb, 0x48, 0xd6, 0x24, 0x99, 0x26, 0x16, 0x89, 0x1d, 0xd9, 0x4e, 0xd5, 0xde, 0xf2, 0x00,
	0x08, 0x09, 0x6e, 0x79, 0x01, 0x9e, 0x84, 0xb7, 0xe0, 0x25, 0x90, 0xb8, 0x45, 0xf6, 0xd8, 0xde,
	0x24, 0xac, 0xb4, 0x57, 0x99, 0xef, 0x9c, 0xcf, 0xe7, 0x7c, 0xf3, 0x9d, 0x13, 0x1b, 0xda, 0xd3,
	0x70, 0xb5, 0x0a, 0x83, 0x9e, 0xf8, 0xe9, 0xae, 0xa3, 0x30, 0x09, 0x71, 0x5d, 0xa0, 0xf3, 0xa7,
	0xf3, 0x30, 0x9c, 0x2f, 0x79, 0x2f, 0x8b, 0x4e, 0x36, 0xb7, 0xbd, 0xc4, 0x5f, 0xf1, 0x38, 0x61,
	0xab, 0xb5, 0x20, 0x6a, 0x1a, 0xc0, 0x88, 0xc5, 0xc9, 0x20, 0x0c, 0x6e, 0xfd, 0x39, 0x7e, 0x04,
	0x35, 0x3f, 0x98, 0xf1, 0x7b, 0x55, 0xea, 0x48, 0x17, 0x55, 0x2a, 0x80, 0xf6, 0x16, 0x0e, 0x5f,
	0xf2, 0x84, 0xcd, 0x58, 0xc2, 0x52, 0xc6, 0x1d, 0x5b, 0x6e, 0x78, 0xc6, 0x38, 0xa2, 0x02, 0xe0,
	0x6f, 0x01, 0x62, 0x7f, 0x1e, 0xb0, 0x64, 0x13, 0xf1, 0x58, 0xad, 0x74, 0xe4, 0x0b, 0xe5, 0xfa,
	0xe3, 0x6e, 0xae, 0xa8, 0x78, 0xd6, 0x29, 0x18, 0x74, 0x8b, 0xac, 0xfd, 0x08, 0xa7, 0xff, 0x23,
	0xe0, 0x2f, 0x00, 0x95, 0x14, 0x6f, 0xc1, 0xd9, 0x8c, 0x47, 0x79, 0xc3, 0x93, 0x32, 0xfe, 0x3c,
	0x0b, 0xe3, 0x4f, 0xa1, 0x59, 0x86, 0xd4, 0x4a, 0xc6, 0x79, 0x17, 0xd0, 0xde, 0x40, 0x3d, 0xe7,
	0x3d, 0x83, 0xe3, 0xe9, 0x82, 0x05, 0x01, 0x5f, 0xee, 0x16, 0x6c, 0xe5, 0xd1, 0x9c, 0xf6, 0xbe,
	0xce, 0x95, 0xf7, 0x76, 0xd6, 0xfe, 0x96, 0xa0, 0x35, 0xd8, 0x79, 0x18, 0x43, 0x35, 0x79, 0x58,
	0x0b, 0x6f, 0x6a, 0x34, 0x3b, 0x63, 0x15, 0x1a, 0x77, 0x3c, 0x8a, 0xfd, 0x30, 0xc8, 0xea, 0xd4,
	0x68, 0x01, 0xf1, 0x37, 0xd0, 0x2c, 0xa7, 0xa1, 0xca, 0x1d, 0xe9, 0x42, 0xb9, 0x3e, 0xef, 0x8a,
	0x79, 0x75, 0x8b, 0x79, 0x75, 0xdd, 0x82, 0x41, 0xdf, 0x91, 0xf1, 0x13, 0x80, 0xe2, 0x2e, 0xfe,
	0x4c, 0xad, 0x76, 0xa4, 0x8b, 0x26, 0x6d, 0xe6, 0x11, 0x73, 0x86, 0xdb, 0x50, 0x4b, 0xee, 0xd3,
	0x4c, 0x2d, 0xcb, 0x54, 0x93, 0x7b, 0x73, 0x96, 0x0e, 0x8e, 0xaf, 0xc3, 0xe9, 0x42, 0xad, 0x8b,
	0xd1, 0x66, 0x20, 0x75, 0x8f, 0xdf, 0x27, 0x3c, 0xc8, 0xf4, 0x35, 0x84, 0x7b, 0x65, 0x40, 0xd3,
	0xe1, 0xc4, 0xd9, 0xb3, 0x5b, 0x85, 0xc6, 0x34, 0xe2, 0x2c, 0x09, 0x0b, 0xff, 0x0a, 0x98, 0x36,
	0x08, 0xc2, 0x60, 0x5a, 0x0c, 0x41, 0x00, 0x8d, 0x40, 0xe3, 0x15, 0x7b, 0x58, 0x86, 0x6c, 0x86,
	0x3f, 0x87, 0xfa, 0x96, 0xf3, 0xca, 0xf5, 0x71, 0xb1, 0x20, 0xa2, 0x34, 0xcd, 0xb3, 0xa9, 0x8b,
	0xe9, 0x36, 0xe4, 0x75, 0xb2, 0xb3, 0xd6, 0x87, 0x43, 0x12, 0xdc, 0xf1, 0x65, 0x28, 0x1c, 0x5d,
	0x8b, 0x92, 0x85, 0x84, 0x1c, 0x7e, 0x60, 0x17, 0x7e, 0x91, 0xa0, 0xd6, 0x5f, 0x86, 0xd3, 0x9f,
	0xf0, 0xd5, 0x9e, 0x92, 0x76, 0xa1, 0x24, 0x4b, 0xef, 0xc9, 0x79, 0xb6, 0x25, 0x47, 0xb9, 0x3e,
	0xdd, 0xa1, 0x1a, 0x2c, 0x61, 0x42, 0x21, 0xfe, 0x0a, 0x0e, 0x57, 0xf9, 0x1e, 0xe7, 0xc3, 0x3c,
	0xdb, 0xa1, 0x16, 0x4b, 0x4e, 0x4b, 0x9a, 0x36, 0x07, 0x65, 0xab, 0x21, 0xfe, 0x08, 0xea, 0xc1,
	0x66, 0x35, 0xc9, 0x55, 0x55, 0x69, 0x8e, 0xf0, 0x67, 0xd0, 0x5a, 0x47, 0xfc, 0xce, 0x0f, 0x37,
	0xb1, 0xb7, 0x60, 0xf1, 0x22, 0xbf, 0xd9, 0x51, 0x11, 0x7c, 0xce, 0xe2, 0x05, 0xfe, 0x04, 0x9a,
	0x69, 0x4d, 0x41, 0x90, 0x33, 0xc2, 0x61, 0x1a, 0x48, 0x93, 0xda, 0x53, 0x68, 0x96, 0x72, 0x4b,
	0x7b, 0xa5, 0x8e, 0x5c, 0xda, 0x7b, 0x05, 0xad, 0x1d, 0x91, 0xf8, 0x7c, 0xeb, 0x36, 0x82, 0x58,
	0xe2, 0xcb, 0x3f, 0x25, 0xa8, 0x3b, 0x09, 0x4b, 0x36, 0x31, 0x56, 0xa0, 0x31, 0xb6, 0x5e, 0x58,
	0xf6, 0xf7, 0x16, 0x3a, 0xc0, 0x47, 0xd0, 0x70, 0xc6, 0x83, 0x01, 0x71, 0x1c, 0xf4, 0x97, 0x84,
	0x11, 0x28, 0x7d, 0xdd, 0xf0, 0x28, 0xf9, 0x6e, 0x4c, 0x1c, 0x17, 0xfd, 0x2a, 0xe3, 0x63, 0x68,
	0x0e, 0x6d, 0xda, 0x37, 0x0d, 0x83, 0x58, 0xe8, 0xb7, 0x0c, 0x5b, 0xb6, 0xeb, 0x0d, 0xed, 0xb1,
	0x65, 0xa0, 0xdf, 0x65, 0xfc, 0x04, 0xd4, 0x9c, 0xed, 0x11, 0xcb, 0x35, 0xdd, 0x1f, 0x3c, 0xd7,
	0xb6, 0xbd, 0x91, 0x4e, 0x6f, 0x08, 0xfa, 0x43, 0xc6, 0xe7, 0x70, 0x66, 0x5a, 0x2e, 0xa1, 0x96,
	0x3e, 0xf2, 0x1c, 0x42, 0x5f, 0x13, 0xea, 0x11, 0x4a, 0x6d, 0x8a, 0xfe, 0x91, 0xb1, 0x0a, 0xed,
	0x34, 0x64, 0x0e, 0x88, 0x37, 0xb6, 0xf4, 0xd7, 0xba, 0x39, 0xd2, 0xfb, 0x23, 0x82, 0xfe, 0x95,
	0x2f, 0x7f, 0x96, 0x00, 0x84, 0xbf, 0x6e, 0xfa, 0x6f, 0x54, 0xa0, 0xf1, 0x92, 0x38, 0x8e, 0x7e,
	0x43, 0xd0, 0x01, 0x06, 0xa8, 0x0f, 0x6c, 0x6b, 0x68, 0xde, 0x20, 0x09, 0x9f, 0x42, 0x4b, 0x9c,
	0xbd, 0xf1, 0x2b, 0x43, 0x77, 0x09, 0xaa, 0x60, 0x15, 0x1e, 0x11, 0xcb, 0xb0, 0xa9, 0x43, 0xa8,
	0xe7, 0x52, 0xdd, 0x72, 0xf4, 0x81, 0x6b, 0xda, 0x16, 0x92, 0xf1, 0x63, 0x68, 0xdb, 0xd4, 0x20,
	0x74, 0x2f, 0x51, 0xc5, 0x67, 0x70, 0x6a, 0x90, 0x91, 0x99, 0x6a, 0x73, 0x08, 0x79, 0xe1, 0x99,
	0xd6, 0xd0, 0x46, 0xb5, 0xcb, 0xb7, 0x80, 0x77, 0xec, 0x35, 0xd3, 0xd7, 0x2a, 0x3e, 0x06, 0x70,
	0xcc, 0x1b, 0x4b, 0x77, 0xc7, 0x94, 0x38, 0xe8, 0x00, 0x9f, 0x80, 0x32, 0xd2, 0x1d, 0xd7, 0x2b,
	0x35, 0x3d, 0x86, 0xf6, 0x56, 0x79, 0xc7, 0x1b, 0x9a, 0x23, 0x97, 0x50, 0x54, 0x49, 0x6f, 0x91,
	0xf7, 0x47, 0x72, 0xff, 0xcb, 0x37, 0x57, 0x73, 0x3f, 0x59, 0x6c, 0x26, 0xe9, 0xba, 0xf5, 0x16,
	0x0f, 0x6b, 0x1e, 0x2d, 0xf9, 0x6c, 0xce, 0xa3, 0xde, 0x2d, 0x9b, 0x44, 0xfe, 0x54, 0xbc, 0xfb,
	0xe3, 0xfc, 0xfb, 0x30, 0xa9, 0x67, 0xf0, 0xeb, 0xff, 0x02, 0x00, 0x00, 0xff, 0xff, 0xa2, 0xa7,
	0x76, 0x1e, 0x37, 0x06, 0x00, 0x00,
}
