// Code generated by protoc-gen-go.
// source: common/configtx.proto
// DO NOT EDIT!

package common

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// ConfigEnvelope is designed to contain _all_ configuration for a chain with no dependency
// on previous configuration transactions.
//
// It is generated with the following scheme:
//   1. Retrieve the existing configuration
//   2. Note the config properties (ConfigValue, ConfigPolicy, ConfigGroup) to be modified
//   3. Add any intermediate ConfigGroups to the ConfigUpdate.read_set (sparsely)
//   4. Add any additional desired dependencies to ConfigUpdate.read_set (sparsely)
//   5. Modify the config properties, incrementing each version by 1, set them in the ConfigUpdate.write_set
//      Note: any element not modified but specified should already be in the read_set, so may be specified sparsely
//   6. Create ConfigUpdate message and marshal it into ConfigUpdateEnvelope.update and encode the required signatures
//     a) Each signature is of type ConfigSignature
//     b) The ConfigSignature signature is over the concatenation of signature_header and the ConfigUpdate bytes (which includes a ChainHeader)
//   5. Submit new Config for ordering in Envelope signed by submitter
//     a) The Envelope Payload has data set to the marshaled ConfigEnvelope
//     b) The Envelope Payload has a header of type Header.Type.CONFIG_UPDATE
//
// The configuration manager will verify:
//   1. All items in the read_set exist at the read versions
//   2. All items in the write_set at a different version than, or not in, the read_set have been appropriately signed according to their mod_policy
//   3. The new configuration satisfies the ConfigSchema
type ConfigEnvelope struct {
	Config     *Config   `protobuf:"bytes,1,opt,name=config" json:"config,omitempty"`
	LastUpdate *Envelope `protobuf:"bytes,2,opt,name=last_update,json=lastUpdate" json:"last_update,omitempty"`
}

func (m *ConfigEnvelope) Reset()                    { *m = ConfigEnvelope{} }
func (m *ConfigEnvelope) String() string            { return proto.CompactTextString(m) }
func (*ConfigEnvelope) ProtoMessage()               {}
func (*ConfigEnvelope) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{0} }

func (m *ConfigEnvelope) GetConfig() *Config {
	if m != nil {
		return m.Config
	}
	return nil
}

func (m *ConfigEnvelope) GetLastUpdate() *Envelope {
	if m != nil {
		return m.LastUpdate
	}
	return nil
}

type ConfigGroupSchema struct {
	Groups   map[string]*ConfigGroupSchema  `protobuf:"bytes,1,rep,name=groups" json:"groups,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Values   map[string]*ConfigValueSchema  `protobuf:"bytes,2,rep,name=values" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Policies map[string]*ConfigPolicySchema `protobuf:"bytes,3,rep,name=policies" json:"policies,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
}

func (m *ConfigGroupSchema) Reset()                    { *m = ConfigGroupSchema{} }
func (m *ConfigGroupSchema) String() string            { return proto.CompactTextString(m) }
func (*ConfigGroupSchema) ProtoMessage()               {}
func (*ConfigGroupSchema) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{1} }

func (m *ConfigGroupSchema) GetGroups() map[string]*ConfigGroupSchema {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *ConfigGroupSchema) GetValues() map[string]*ConfigValueSchema {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *ConfigGroupSchema) GetPolicies() map[string]*ConfigPolicySchema {
	if m != nil {
		return m.Policies
	}
	return nil
}

type ConfigValueSchema struct {
}

func (m *ConfigValueSchema) Reset()                    { *m = ConfigValueSchema{} }
func (m *ConfigValueSchema) String() string            { return proto.CompactTextString(m) }
func (*ConfigValueSchema) ProtoMessage()               {}
func (*ConfigValueSchema) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{2} }

type ConfigPolicySchema struct {
}

func (m *ConfigPolicySchema) Reset()                    { *m = ConfigPolicySchema{} }
func (m *ConfigPolicySchema) String() string            { return proto.CompactTextString(m) }
func (*ConfigPolicySchema) ProtoMessage()               {}
func (*ConfigPolicySchema) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{3} }

// Config represents the config for a particular channel
type Config struct {
	Sequence     uint64       `protobuf:"varint,1,opt,name=sequence" json:"sequence,omitempty"`
	ChannelGroup *ConfigGroup `protobuf:"bytes,2,opt,name=channel_group,json=channelGroup" json:"channel_group,omitempty"`
}

func (m *Config) Reset()                    { *m = Config{} }
func (m *Config) String() string            { return proto.CompactTextString(m) }
func (*Config) ProtoMessage()               {}
func (*Config) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{4} }

func (m *Config) GetChannelGroup() *ConfigGroup {
	if m != nil {
		return m.ChannelGroup
	}
	return nil
}

type ConfigUpdateEnvelope struct {
	ConfigUpdate []byte             `protobuf:"bytes,1,opt,name=config_update,json=configUpdate,proto3" json:"config_update,omitempty"`
	Signatures   []*ConfigSignature `protobuf:"bytes,2,rep,name=signatures" json:"signatures,omitempty"`
}

func (m *ConfigUpdateEnvelope) Reset()                    { *m = ConfigUpdateEnvelope{} }
func (m *ConfigUpdateEnvelope) String() string            { return proto.CompactTextString(m) }
func (*ConfigUpdateEnvelope) ProtoMessage()               {}
func (*ConfigUpdateEnvelope) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{5} }

func (m *ConfigUpdateEnvelope) GetSignatures() []*ConfigSignature {
	if m != nil {
		return m.Signatures
	}
	return nil
}

// ConfigUpdate is used to submit a subset of config and to have the orderer apply to Config
// it is always submitted inside a ConfigUpdateEnvelope which allows the addition of signatures
// resulting in a new total configuration.  The update is applied as follows:
// 1. The versions from all of the elements in the read_set is verified against the versions in the existing config.
//    If there is a mismatch in the read versions, then the config update fails and is rejected.
// 2. Any elements in the write_set with the same version as the read_set are ignored.
// 3. The corresponding mod_policy for every remaining element in the write_set is collected.
// 4. Each policy is checked against the signatures from the ConfigUpdateEnvelope, any failing to verify are rejected
// 5. The write_set is applied to the Config and the ConfigGroupSchema verifies that the updates were legal
type ConfigUpdate struct {
	ChannelId string       `protobuf:"bytes,1,opt,name=channel_id,json=channelId" json:"channel_id,omitempty"`
	ReadSet   *ConfigGroup `protobuf:"bytes,2,opt,name=read_set,json=readSet" json:"read_set,omitempty"`
	WriteSet  *ConfigGroup `protobuf:"bytes,3,opt,name=write_set,json=writeSet" json:"write_set,omitempty"`
}

func (m *ConfigUpdate) Reset()                    { *m = ConfigUpdate{} }
func (m *ConfigUpdate) String() string            { return proto.CompactTextString(m) }
func (*ConfigUpdate) ProtoMessage()               {}
func (*ConfigUpdate) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{6} }

func (m *ConfigUpdate) GetReadSet() *ConfigGroup {
	if m != nil {
		return m.ReadSet
	}
	return nil
}

func (m *ConfigUpdate) GetWriteSet() *ConfigGroup {
	if m != nil {
		return m.WriteSet
	}
	return nil
}

// ConfigGroup is the hierarchical data structure for holding config
type ConfigGroup struct {
	Version   uint64                   `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	Groups    map[string]*ConfigGroup  `protobuf:"bytes,2,rep,name=groups" json:"groups,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Values    map[string]*ConfigValue  `protobuf:"bytes,3,rep,name=values" json:"values,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	Policies  map[string]*ConfigPolicy `protobuf:"bytes,4,rep,name=policies" json:"policies,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value"`
	ModPolicy string                   `protobuf:"bytes,5,opt,name=mod_policy,json=modPolicy" json:"mod_policy,omitempty"`
}

func (m *ConfigGroup) Reset()                    { *m = ConfigGroup{} }
func (m *ConfigGroup) String() string            { return proto.CompactTextString(m) }
func (*ConfigGroup) ProtoMessage()               {}
func (*ConfigGroup) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{7} }

func (m *ConfigGroup) GetGroups() map[string]*ConfigGroup {
	if m != nil {
		return m.Groups
	}
	return nil
}

func (m *ConfigGroup) GetValues() map[string]*ConfigValue {
	if m != nil {
		return m.Values
	}
	return nil
}

func (m *ConfigGroup) GetPolicies() map[string]*ConfigPolicy {
	if m != nil {
		return m.Policies
	}
	return nil
}

// ConfigValue represents an individual piece of config data
type ConfigValue struct {
	Version   uint64 `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	Value     []byte `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	ModPolicy string `protobuf:"bytes,3,opt,name=mod_policy,json=modPolicy" json:"mod_policy,omitempty"`
}

func (m *ConfigValue) Reset()                    { *m = ConfigValue{} }
func (m *ConfigValue) String() string            { return proto.CompactTextString(m) }
func (*ConfigValue) ProtoMessage()               {}
func (*ConfigValue) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{8} }

type ConfigPolicy struct {
	Version   uint64  `protobuf:"varint,1,opt,name=version" json:"version,omitempty"`
	Policy    *Policy `protobuf:"bytes,2,opt,name=policy" json:"policy,omitempty"`
	ModPolicy string  `protobuf:"bytes,3,opt,name=mod_policy,json=modPolicy" json:"mod_policy,omitempty"`
}

func (m *ConfigPolicy) Reset()                    { *m = ConfigPolicy{} }
func (m *ConfigPolicy) String() string            { return proto.CompactTextString(m) }
func (*ConfigPolicy) ProtoMessage()               {}
func (*ConfigPolicy) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{9} }

func (m *ConfigPolicy) GetPolicy() *Policy {
	if m != nil {
		return m.Policy
	}
	return nil
}

type ConfigSignature struct {
	SignatureHeader []byte `protobuf:"bytes,1,opt,name=signature_header,json=signatureHeader,proto3" json:"signature_header,omitempty"`
	Signature       []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (m *ConfigSignature) Reset()                    { *m = ConfigSignature{} }
func (m *ConfigSignature) String() string            { return proto.CompactTextString(m) }
func (*ConfigSignature) ProtoMessage()               {}
func (*ConfigSignature) Descriptor() ([]byte, []int) { return fileDescriptor1, []int{10} }

func init() {
	proto.RegisterType((*ConfigEnvelope)(nil), "common.ConfigEnvelope")
	proto.RegisterType((*ConfigGroupSchema)(nil), "common.ConfigGroupSchema")
	proto.RegisterType((*ConfigValueSchema)(nil), "common.ConfigValueSchema")
	proto.RegisterType((*ConfigPolicySchema)(nil), "common.ConfigPolicySchema")
	proto.RegisterType((*Config)(nil), "common.Config")
	proto.RegisterType((*ConfigUpdateEnvelope)(nil), "common.ConfigUpdateEnvelope")
	proto.RegisterType((*ConfigUpdate)(nil), "common.ConfigUpdate")
	proto.RegisterType((*ConfigGroup)(nil), "common.ConfigGroup")
	proto.RegisterType((*ConfigValue)(nil), "common.ConfigValue")
	proto.RegisterType((*ConfigPolicy)(nil), "common.ConfigPolicy")
	proto.RegisterType((*ConfigSignature)(nil), "common.ConfigSignature")
}

func init() { proto.RegisterFile("common/configtx.proto", fileDescriptor1) }

var fileDescriptor1 = []byte{
	// 663 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x94, 0x55, 0xdb, 0x6e, 0xd3, 0x40,
	0x10, 0x55, 0xe2, 0xd6, 0x4d, 0x26, 0xe9, 0x85, 0x4d, 0x10, 0xc6, 0x02, 0x51, 0x8c, 0x28, 0x2d,
	0x88, 0xa4, 0x94, 0x87, 0x54, 0x48, 0x7d, 0xa1, 0xaa, 0x80, 0x97, 0x0a, 0x1c, 0x2e, 0x52, 0x85,
	0x88, 0x1c, 0x7b, 0x9b, 0x58, 0x75, 0xbc, 0xc6, 0x5e, 0x07, 0xf2, 0x15, 0x7c, 0x20, 0x7f, 0xc0,
	0x57, 0x20, 0xef, 0xc5, 0xac, 0x13, 0x27, 0x11, 0x4f, 0xc9, 0xcc, 0x9c, 0x73, 0x66, 0x77, 0x76,
	0x8e, 0x0c, 0xb7, 0x5d, 0x32, 0x99, 0x90, 0xb0, 0xeb, 0x92, 0xf0, 0xda, 0x1f, 0xd1, 0x9f, 0x9d,
	0x28, 0x26, 0x94, 0x20, 0x9d, 0xa7, 0xcd, 0x56, 0x5e, 0xce, 0x7e, 0x78, 0xd1, 0x94, 0x9c, 0x88,
	0x04, 0xbe, 0xeb, 0xe3, 0x84, 0xa7, 0xad, 0x1b, 0xd8, 0x39, 0x67, 0x2a, 0x17, 0xe1, 0x14, 0x07,
	0x24, 0xc2, 0xe8, 0x00, 0x74, 0xae, 0x6b, 0x54, 0xf6, 0x2b, 0x87, 0x8d, 0x93, 0x9d, 0x8e, 0xd0,
	0xe1, 0x38, 0x5b, 0x54, 0xd1, 0x0b, 0x68, 0x04, 0x4e, 0x42, 0x07, 0x69, 0xe4, 0x39, 0x14, 0x1b,
	0x55, 0x06, 0xde, 0x93, 0x60, 0x29, 0x67, 0x43, 0x06, 0xfa, 0xc4, 0x30, 0xd6, 0x6f, 0x0d, 0x6e,
	0x71, 0x95, 0x37, 0x31, 0x49, 0xa3, 0xbe, 0x3b, 0xc6, 0x13, 0x07, 0x9d, 0x81, 0x3e, 0xca, 0xc2,
	0xc4, 0xa8, 0xec, 0x6b, 0x87, 0x8d, 0x93, 0xc7, 0xc5, 0x86, 0x0a, 0xb4, 0xc3, 0xfe, 0x27, 0x17,
	0x21, 0x8d, 0x67, 0xb6, 0x20, 0x65, 0xf4, 0xa9, 0x13, 0xa4, 0x38, 0x31, 0xaa, 0xeb, 0xe8, 0x9f,
	0x19, 0x4e, 0xd0, 0x39, 0x09, 0x9d, 0x43, 0x4d, 0x8e, 0xc4, 0xd0, 0x98, 0xc0, 0x93, 0xe5, 0x02,
	0xef, 0x05, 0x92, 0x4b, 0xe4, 0x44, 0xf3, 0x23, 0x34, 0x94, 0xa3, 0xa1, 0x3d, 0xd0, 0x6e, 0xf0,
	0x8c, 0xcd, 0xaf, 0x6e, 0x67, 0x7f, 0x51, 0x17, 0x36, 0x59, 0x3f, 0x31, 0xa6, 0xbb, 0x4b, 0x5b,
	0xd8, 0x1c, 0xf7, 0xaa, 0x7a, 0x5a, 0xc9, 0x54, 0x95, 0x13, 0xff, 0xb7, 0x2a, 0xe3, 0x2e, 0xaa,
	0x7e, 0x81, 0xed, 0xc2, 0x35, 0x4a, 0x74, 0x8f, 0x8b, 0xba, 0x66, 0x51, 0x97, 0xb1, 0x67, 0x0b,
	0xc2, 0x56, 0x4b, 0x3e, 0xae, 0xd2, 0xd8, 0x6a, 0x03, 0x5a, 0x64, 0x59, 0xdf, 0x40, 0xe7, 0x59,
	0x64, 0x42, 0x2d, 0xc1, 0xdf, 0x53, 0x1c, 0xba, 0x98, 0x9d, 0x60, 0xc3, 0xce, 0x63, 0x74, 0x0a,
	0xdb, 0xee, 0xd8, 0x09, 0x43, 0x1c, 0x0c, 0xd8, 0x5b, 0x8b, 0xe3, 0xb4, 0x4a, 0x86, 0x67, 0x37,
	0x05, 0x92, 0x45, 0x16, 0x85, 0x36, 0x2f, 0xf2, 0xc5, 0xcb, 0x77, 0xfb, 0x11, 0x6c, 0xf3, 0xed,
	0x95, 0x5b, 0x9b, 0xb5, 0x6c, 0xda, 0x4d, 0x57, 0x01, 0xa3, 0x1e, 0x40, 0xe2, 0x8f, 0x42, 0x87,
	0xa6, 0x71, 0xbe, 0x54, 0x77, 0x8a, 0x3d, 0xfb, 0xb2, 0x6e, 0x2b, 0x50, 0xeb, 0x57, 0x05, 0x9a,
	0x6a, 0x5b, 0x74, 0x1f, 0x40, 0x5e, 0xc0, 0xf7, 0xc4, 0x80, 0xeb, 0x22, 0xf3, 0xce, 0x43, 0x1d,
	0xa8, 0xc5, 0xd8, 0xf1, 0x06, 0x09, 0xa6, 0xab, 0xae, 0xb6, 0x95, 0x81, 0xfa, 0x98, 0xa2, 0x63,
	0xa8, 0xff, 0x88, 0x7d, 0x8a, 0x19, 0x41, 0x5b, 0x4e, 0xa8, 0x31, 0x54, 0x1f, 0x53, 0xeb, 0x8f,
	0x06, 0x0d, 0xa5, 0x82, 0x0c, 0xd8, 0x9a, 0xe2, 0x38, 0xf1, 0x49, 0x28, 0x86, 0x2d, 0x43, 0xd4,
	0xcb, 0x4d, 0xc8, 0x2f, 0xfc, 0xa0, 0x44, 0xb8, 0xd4, 0x7e, 0xbd, 0xdc, 0x7e, 0xda, 0x72, 0x62,
	0x99, 0xf1, 0xce, 0x14, 0xe3, 0x6d, 0x30, 0xea, 0xc3, 0x32, 0xea, 0x12, 0xcb, 0x65, 0xb3, 0x9d,
	0x10, 0x6f, 0xc0, 0xe2, 0x99, 0xb1, 0xc9, 0x67, 0x3b, 0x21, 0x1e, 0xdf, 0x33, 0xf3, 0x72, 0x9d,
	0x23, 0x8f, 0x8a, 0x3b, 0x5e, 0x3a, 0x48, 0xc5, 0x35, 0x97, 0xeb, 0xbc, 0xb8, 0x5a, 0x8f, 0x71,
	0x55, 0xbd, 0x0f, 0xeb, 0x5d, 0xf8, 0xb4, 0xa8, 0xd8, 0x2e, 0x73, 0xa1, 0xea, 0xbf, 0xaf, 0xf2,
	0xad, 0x59, 0xb3, 0x15, 0x6f, 0xdd, 0x56, 0x85, 0x9b, 0x42, 0x62, 0x6e, 0xa0, 0xda, 0xdc, 0x40,
	0x2d, 0x22, 0x77, 0x9b, 0xc7, 0x2b, 0xe4, 0x0f, 0x40, 0x17, 0x22, 0xd5, 0xe2, 0x07, 0x44, 0x1c,
	0x59, 0x54, 0xd7, 0x35, 0xbc, 0x82, 0xdd, 0x39, 0xb3, 0xa1, 0x23, 0xd8, 0xcb, 0xed, 0x36, 0x18,
	0x63, 0xc7, 0xc3, 0xb1, 0x70, 0xf0, 0x6e, 0x9e, 0x7f, 0xcb, 0xd2, 0xe8, 0x1e, 0xd4, 0xf3, 0x94,
	0xb8, 0xe7, 0xbf, 0xc4, 0xeb, 0xe7, 0x57, 0xcf, 0x46, 0x3e, 0x1d, 0xa7, 0xc3, 0xec, 0x68, 0xdd,
	0xf1, 0x2c, 0xc2, 0x71, 0x80, 0xbd, 0x11, 0x8e, 0xbb, 0xd7, 0xce, 0x30, 0xf6, 0xdd, 0x2e, 0xfb,
	0x38, 0x26, 0xe2, 0x0b, 0x3a, 0xd4, 0x59, 0xf8, 0xf2, 0x6f, 0x00, 0x00, 0x00, 0xff, 0xff, 0x0e,
	0xff, 0x85, 0xc2, 0x78, 0x07, 0x00, 0x00,
}
