// Code generated by protoc-gen-go.
// source: common/msp_principal.proto
// DO NOT EDIT!

package common

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type MSPPrincipal_Classification int32

const (
	MSPPrincipal_ROLE MSPPrincipal_Classification = 0
	// one of a member of MSP network, and the one of an
	// administrator of an MSP network
	MSPPrincipal_ORGANIZATION_UNIT MSPPrincipal_Classification = 1
	// groupping of entities, per MSP affiliation
	// E.g., this can well be represented by an MSP's
	// Organization unit
	MSPPrincipal_IDENTITY MSPPrincipal_Classification = 2
)

var MSPPrincipal_Classification_name = map[int32]string{
	0: "ROLE",
	1: "ORGANIZATION_UNIT",
	2: "IDENTITY",
}
var MSPPrincipal_Classification_value = map[string]int32{
	"ROLE":              0,
	"ORGANIZATION_UNIT": 1,
	"IDENTITY":          2,
}

func (x MSPPrincipal_Classification) String() string {
	return proto.EnumName(MSPPrincipal_Classification_name, int32(x))
}
func (MSPPrincipal_Classification) EnumDescriptor() ([]byte, []int) {
	return fileDescriptor4, []int{0, 0}
}

type MSPRole_MSPRoleType int32

const (
	MSPRole_MEMBER MSPRole_MSPRoleType = 0
	MSPRole_ADMIN  MSPRole_MSPRoleType = 1
)

var MSPRole_MSPRoleType_name = map[int32]string{
	0: "MEMBER",
	1: "ADMIN",
}
var MSPRole_MSPRoleType_value = map[string]int32{
	"MEMBER": 0,
	"ADMIN":  1,
}

func (x MSPRole_MSPRoleType) String() string {
	return proto.EnumName(MSPRole_MSPRoleType_name, int32(x))
}
func (MSPRole_MSPRoleType) EnumDescriptor() ([]byte, []int) { return fileDescriptor4, []int{2, 0} }

// MSPPrincipal aims to represent an MSP-centric set of identities.
// In particular, this structure allows for definition of
//  - a group of identities that are member of the same MSP
//  - a group of identities that are member of the same organization unit
//    in the same MSP
//  - a group of identities that are administering a specific MSP
//  - a specific identity
// Expressing these groups is done given two fields of the fields below
//  - Classification, that defines the type of classification of identities
//    in an MSP this principal would be defined on; Classification can take
//    three values:
//     (i)  ByMSPRole: that represents a classification of identities within
//          MSP based on one of the two pre-defined MSP rules, "member" and "admin"
//     (ii) ByOrganizationUnit: that represents a classification of identities
//          within MSP based on the organization unit an identity belongs to
//     (iii)ByIdentity that denotes that MSPPrincipal is mapped to a single
//          identity/certificate; this would mean that the Principal bytes
//          message
type MSPPrincipal struct {
	// Classification describes the way that one should process
	// Principal. An Classification value of "ByOrganizationUnit" reflects
	// that "Principal" contains the name of an organization this MSP
	// handles. A Classification value "ByIdentity" means that
	// "Principal" contains a specific identity. Default value
	// denotes that Principal contains one of the groups by
	// default supported by all MSPs ("admin" or "member").
	PrincipalClassification MSPPrincipal_Classification `protobuf:"varint,1,opt,name=principal_classification,json=principalClassification,enum=common.MSPPrincipal_Classification" json:"principal_classification,omitempty"`
	// Principal completes the policy principal definition. For the default
	// principal types, Principal can be either "Admin" or "Member".
	// For the ByOrganizationUnit/ByIdentity values of Classification,
	// PolicyPrincipal acquires its value from an organization unit or
	// identity, respectively.
	Principal []byte `protobuf:"bytes,2,opt,name=principal,proto3" json:"principal,omitempty"`
}

func (m *MSPPrincipal) Reset()                    { *m = MSPPrincipal{} }
func (m *MSPPrincipal) String() string            { return proto.CompactTextString(m) }
func (*MSPPrincipal) ProtoMessage()               {}
func (*MSPPrincipal) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{0} }

// OrganizationUnit governs the organization of the Principal
// field of a policy principal when a specific organization unity members
// are to be defined within a policy principal.
type OrganizationUnit struct {
	// MSPIdentifier represents the identifier of the MSP this organization unit
	// refers to
	MspIdentifier string `protobuf:"bytes,1,opt,name=msp_identifier,json=mspIdentifier" json:"msp_identifier,omitempty"`
	// OrganizationUnitIdentifier defines the organizational unit under the
	// MSP identified with MSPIdentifier
	OrganizationalUnitIdentifier string `protobuf:"bytes,2,opt,name=organizational_unit_identifier,json=organizationalUnitIdentifier" json:"organizational_unit_identifier,omitempty"`
	// CertifiersIdentifier is the hash of certificates chain of trust
	// related to this organizational unit
	CertifiersIdentifier []byte `protobuf:"bytes,3,opt,name=certifiers_identifier,json=certifiersIdentifier,proto3" json:"certifiers_identifier,omitempty"`
}

func (m *OrganizationUnit) Reset()                    { *m = OrganizationUnit{} }
func (m *OrganizationUnit) String() string            { return proto.CompactTextString(m) }
func (*OrganizationUnit) ProtoMessage()               {}
func (*OrganizationUnit) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{1} }

// MSPRole governs the organization of the Principal
// field of an MSPPrincipal when it aims to define one of the
// two dedicated roles within an MSP: Admin and Members.
type MSPRole struct {
	// MSPIdentifier represents the identifier of the MSP this principal
	// refers to
	MspIdentifier string `protobuf:"bytes,1,opt,name=msp_identifier,json=mspIdentifier" json:"msp_identifier,omitempty"`
	// MSPRoleType defines which of the available, pre-defined MSP-roles
	// an identiy should posess inside the MSP with identifier MSPidentifier
	Role MSPRole_MSPRoleType `protobuf:"varint,2,opt,name=Role,enum=common.MSPRole_MSPRoleType" json:"Role,omitempty"`
}

func (m *MSPRole) Reset()                    { *m = MSPRole{} }
func (m *MSPRole) String() string            { return proto.CompactTextString(m) }
func (*MSPRole) ProtoMessage()               {}
func (*MSPRole) Descriptor() ([]byte, []int) { return fileDescriptor4, []int{2} }

func init() {
	proto.RegisterType((*MSPPrincipal)(nil), "common.MSPPrincipal")
	proto.RegisterType((*OrganizationUnit)(nil), "common.OrganizationUnit")
	proto.RegisterType((*MSPRole)(nil), "common.MSPRole")
	proto.RegisterEnum("common.MSPPrincipal_Classification", MSPPrincipal_Classification_name, MSPPrincipal_Classification_value)
	proto.RegisterEnum("common.MSPRole_MSPRoleType", MSPRole_MSPRoleType_name, MSPRole_MSPRoleType_value)
}

func init() { proto.RegisterFile("common/msp_principal.proto", fileDescriptor4) }

var fileDescriptor4 = []byte{
	// 372 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x8c, 0x92, 0xdf, 0x6a, 0xe2, 0x40,
	0x14, 0xc6, 0x1d, 0xd7, 0x75, 0xf5, 0xac, 0x1b, 0xb2, 0xc3, 0xca, 0xca, 0xae, 0x2c, 0x92, 0xdd,
	0x05, 0xa1, 0x34, 0x01, 0x7d, 0x80, 0xa2, 0x35, 0x94, 0x40, 0x93, 0xc8, 0x18, 0x2f, 0xea, 0x45,
	0x43, 0x8c, 0xa3, 0x0e, 0xe4, 0x1f, 0x93, 0x78, 0x61, 0x5f, 0xa0, 0x2f, 0xd4, 0xd7, 0xe8, 0x3b,
	0x95, 0x4c, 0x30, 0xc6, 0x5e, 0xf5, 0x2a, 0x9c, 0xef, 0xfb, 0x7e, 0xe7, 0x4f, 0x12, 0xf8, 0xe5,
	0xc7, 0x61, 0x18, 0x47, 0x5a, 0x98, 0x26, 0x6e, 0xc2, 0x59, 0xe4, 0xb3, 0xc4, 0x0b, 0xd4, 0x84,
	0xc7, 0x59, 0x8c, 0x9b, 0x85, 0xa7, 0xbc, 0x22, 0xe8, 0x98, 0x8b, 0xf9, 0xfc, 0x64, 0xe3, 0x47,
	0xe8, 0x95, 0x59, 0xd7, 0x0f, 0xbc, 0x34, 0x65, 0x5b, 0xe6, 0x7b, 0x19, 0x8b, 0xa3, 0x1e, 0x1a,
	0xa0, 0xa1, 0x34, 0xfa, 0xab, 0x16, 0xac, 0x5a, 0xe5, 0xd4, 0xdb, 0x8b, 0x28, 0xf9, 0x59, 0x36,
	0xb9, 0x34, 0x70, 0x1f, 0xda, 0xa5, 0xd5, 0xab, 0x0f, 0xd0, 0xb0, 0x43, 0xce, 0x82, 0x72, 0x03,
	0xd2, 0xbb, 0x7c, 0x0b, 0x1a, 0xc4, 0xbe, 0xd7, 0xe5, 0x1a, 0xee, 0xc2, 0x77, 0x9b, 0xdc, 0x4d,
	0x2c, 0x63, 0x35, 0x71, 0x0c, 0xdb, 0x72, 0x97, 0x96, 0xe1, 0xc8, 0x08, 0x77, 0xa0, 0x65, 0xcc,
	0x74, 0xcb, 0x31, 0x9c, 0x07, 0xb9, 0xae, 0xbc, 0x20, 0x90, 0x6d, 0xbe, 0xf3, 0x22, 0xf6, 0x24,
	0xf8, 0x65, 0xc4, 0x32, 0xfc, 0x1f, 0xa4, 0xfc, 0x1d, 0xb0, 0x0d, 0x8d, 0x32, 0xb6, 0x65, 0x94,
	0x8b, 0x4b, 0xda, 0xe4, 0x5b, 0x98, 0x26, 0x46, 0x29, 0xe2, 0x19, 0xfc, 0x89, 0x2b, 0xa8, 0x17,
	0xb8, 0x87, 0x88, 0x65, 0x55, 0xac, 0x2e, 0xb0, 0xfe, 0x65, 0x2a, 0x1f, 0x51, 0xe9, 0x32, 0x86,
	0xae, 0x4f, 0x79, 0x51, 0xa4, 0x55, 0xf8, 0x93, 0x38, 0xf6, 0xc7, 0xd9, 0x3c, 0x43, 0xca, 0x33,
	0x82, 0x2f, 0xe6, 0x62, 0x4e, 0xe2, 0x80, 0x7e, 0x74, 0x5b, 0x0d, 0x1a, 0x79, 0x5c, 0xec, 0x24,
	0x8d, 0x7e, 0x57, 0x3e, 0x4a, 0x2e, 0x9f, 0x9e, 0xce, 0x31, 0xa1, 0x44, 0x04, 0x95, 0x7f, 0xf0,
	0xb5, 0x22, 0x62, 0x80, 0xa6, 0xa9, 0x9b, 0x53, 0x9d, 0xc8, 0x35, 0xdc, 0x86, 0xcf, 0x93, 0x99,
	0x69, 0x58, 0x32, 0x9a, 0x5e, 0xaf, 0xae, 0x76, 0x2c, 0xdb, 0x1f, 0xd6, 0x79, 0x43, 0x6d, 0x7f,
	0x4c, 0x28, 0x0f, 0xe8, 0x66, 0x47, 0xb9, 0xb6, 0xf5, 0xd6, 0x9c, 0xf9, 0x9a, 0xf8, 0x7f, 0x52,
	0xad, 0x18, 0xb7, 0x6e, 0x8a, 0x72, 0xfc, 0x16, 0x00, 0x00, 0xff, 0xff, 0xeb, 0xd1, 0x3b, 0xb8,
	0x6c, 0x02, 0x00, 0x00,
}
