// Code generated by protoc-gen-go.
// source: msp/mspconfig.proto
// DO NOT EDIT!

/*
Package msp is a generated protocol buffer package.

It is generated from these files:
	msp/mspconfig.proto

It has these top-level messages:
	MSPConfig
	FabricMSPConfig
	SigningIdentityInfo
	KeyInfo
	FabricOUIdentifier
*/
package msp

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This is a compile-time assertion to ensure that this generated file
// is compatible with the proto package it is being compiled against.
// A compilation error at this line likely means your copy of the
// proto package needs to be updated.
const _ = proto.ProtoPackageIsVersion2 // please upgrade the proto package

// MSPConfig collects all the configuration information for
// an MSP. The Config field should be unmarshalled in a way
// that depends on the Type
type MSPConfig struct {
	// Type holds the type of the MSP; the default one would
	// be of type FABRIC implementing an X.509 based provider
	Type int32 `protobuf:"varint,1,opt,name=type" json:"type,omitempty"`
	// Config is MSP dependent configuration info
	Config []byte `protobuf:"bytes,2,opt,name=config,proto3" json:"config,omitempty"`
}

func (m *MSPConfig) Reset()                    { *m = MSPConfig{} }
func (m *MSPConfig) String() string            { return proto.CompactTextString(m) }
func (*MSPConfig) ProtoMessage()               {}
func (*MSPConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{0} }

// FabricMSPConfig collects all the configuration information for
// a Fabric MSP.
// Here we assume a default certificate validation policy, where
// any certificate signed by any of the listed rootCA certs would
// be considered as valid under this MSP.
// This MSP may or may not come with a signing identity. If it does,
// it can also issue signing identities. If it does not, it can only
// be used to validate and verify certificates.
type FabricMSPConfig struct {
	// Name holds the identifier of the MSP; MSP identifier
	// is chosen by the application that governs this MSP.
	// For example, and assuming the default implementation of MSP,
	// that is X.509-based and considers a single Issuer,
	// this can refer to the Subject OU field or the Issuer OU field.
	Name string `protobuf:"bytes,1,opt,name=name" json:"name,omitempty"`
	// List of root certificates trusted by this MSP
	// they are used upon certificate validation (see
	// comment for IntermediateCerts below)
	RootCerts [][]byte `protobuf:"bytes,2,rep,name=root_certs,json=rootCerts,proto3" json:"root_certs,omitempty"`
	// List of intermediate certificates trusted by this MSP;
	// they are used upon certificate validation as follows:
	// validation attempts to build a path from the certificate
	// to be validated (which is at one end of the path) and
	// one of the certs in the RootCerts field (which is at
	// the other end of the path). If the path is longer than
	// 2, certificates in the middle are searched within the
	// IntermediateCerts pool
	IntermediateCerts [][]byte `protobuf:"bytes,3,rep,name=intermediate_certs,json=intermediateCerts,proto3" json:"intermediate_certs,omitempty"`
	// Identity denoting the administrator of this MSP
	Admins [][]byte `protobuf:"bytes,4,rep,name=admins,proto3" json:"admins,omitempty"`
	// Identity revocation list
	RevocationList [][]byte `protobuf:"bytes,5,rep,name=revocation_list,json=revocationList,proto3" json:"revocation_list,omitempty"`
	// SigningIdentity holds information on the signing identity
	// this peer is to use, and which is to be imported by the
	// MSP defined before
	SigningIdentity *SigningIdentityInfo `protobuf:"bytes,6,opt,name=signing_identity,json=signingIdentity" json:"signing_identity,omitempty"`
	// OrganizationalUnitIdentifiers holds one or more
	// fabric organizational unit identifiers that belong to
	// this MSP configuration
	OrganizationalUnitIdentifiers []*FabricOUIdentifier `protobuf:"bytes,7,rep,name=organizational_unit_identifiers,json=organizationalUnitIdentifiers" json:"organizational_unit_identifiers,omitempty"`
}

func (m *FabricMSPConfig) Reset()                    { *m = FabricMSPConfig{} }
func (m *FabricMSPConfig) String() string            { return proto.CompactTextString(m) }
func (*FabricMSPConfig) ProtoMessage()               {}
func (*FabricMSPConfig) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{1} }

func (m *FabricMSPConfig) GetSigningIdentity() *SigningIdentityInfo {
	if m != nil {
		return m.SigningIdentity
	}
	return nil
}

func (m *FabricMSPConfig) GetOrganizationalUnitIdentifiers() []*FabricOUIdentifier {
	if m != nil {
		return m.OrganizationalUnitIdentifiers
	}
	return nil
}

// SigningIdentityInfo represents the configuration information
// related to the signing identity the peer is to use for generating
// endorsements
type SigningIdentityInfo struct {
	// PublicSigner carries the public information of the signing
	// identity. For an X.509 provider this would be represented by
	// an X.509 certificate
	PublicSigner []byte `protobuf:"bytes,1,opt,name=public_signer,json=publicSigner,proto3" json:"public_signer,omitempty"`
	// PrivateSigner denotes a reference to the private key of the
	// peer's signing identity
	PrivateSigner *KeyInfo `protobuf:"bytes,2,opt,name=private_signer,json=privateSigner" json:"private_signer,omitempty"`
}

func (m *SigningIdentityInfo) Reset()                    { *m = SigningIdentityInfo{} }
func (m *SigningIdentityInfo) String() string            { return proto.CompactTextString(m) }
func (*SigningIdentityInfo) ProtoMessage()               {}
func (*SigningIdentityInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{2} }

func (m *SigningIdentityInfo) GetPrivateSigner() *KeyInfo {
	if m != nil {
		return m.PrivateSigner
	}
	return nil
}

// KeyInfo represents a (secret) key that is either already stored
// in the bccsp/keystore or key material to be imported to the
// bccsp key-store. In later versions it may contain also a
// keystore identifier
type KeyInfo struct {
	// Identifier of the key inside the default keystore; this for
	// the case of Software BCCSP as well as the HSM BCCSP would be
	// the SKI of the key
	KeyIdentifier string `protobuf:"bytes,1,opt,name=key_identifier,json=keyIdentifier" json:"key_identifier,omitempty"`
	// KeyMaterial (optional) for the key to be imported; this is
	// properly encoded key bytes, prefixed by the type of the key
	KeyMaterial []byte `protobuf:"bytes,2,opt,name=key_material,json=keyMaterial,proto3" json:"key_material,omitempty"`
}

func (m *KeyInfo) Reset()                    { *m = KeyInfo{} }
func (m *KeyInfo) String() string            { return proto.CompactTextString(m) }
func (*KeyInfo) ProtoMessage()               {}
func (*KeyInfo) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{3} }

// FabricOUIdentifier represents an organizazional unit and
// its related chain of trust identifier.
type FabricOUIdentifier struct {
	// CertifiersIdentifier is the hash of certificates chain of trust
	// related to this organizational unit
	CertifiersIdentifier []byte `protobuf:"bytes,1,opt,name=certifiers_identifier,json=certifiersIdentifier,proto3" json:"certifiers_identifier,omitempty"`
	// OrganizationUnitIdentifier defines the organizational unit under the
	// MSP identified with MSPIdentifier
	OrganizationalUnitIdentifier string `protobuf:"bytes,2,opt,name=organizational_unit_identifier,json=organizationalUnitIdentifier" json:"organizational_unit_identifier,omitempty"`
}

func (m *FabricOUIdentifier) Reset()                    { *m = FabricOUIdentifier{} }
func (m *FabricOUIdentifier) String() string            { return proto.CompactTextString(m) }
func (*FabricOUIdentifier) ProtoMessage()               {}
func (*FabricOUIdentifier) Descriptor() ([]byte, []int) { return fileDescriptor0, []int{4} }

func init() {
	proto.RegisterType((*MSPConfig)(nil), "msp.MSPConfig")
	proto.RegisterType((*FabricMSPConfig)(nil), "msp.FabricMSPConfig")
	proto.RegisterType((*SigningIdentityInfo)(nil), "msp.SigningIdentityInfo")
	proto.RegisterType((*KeyInfo)(nil), "msp.KeyInfo")
	proto.RegisterType((*FabricOUIdentifier)(nil), "msp.FabricOUIdentifier")
}

func init() { proto.RegisterFile("msp/mspconfig.proto", fileDescriptor0) }

var fileDescriptor0 = []byte{
	// 458 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x7c, 0x53, 0xdd, 0x6e, 0xd3, 0x30,
	0x14, 0x56, 0xda, 0xad, 0x53, 0x4f, 0xd3, 0x16, 0x3c, 0x18, 0xb9, 0x60, 0x10, 0x82, 0x10, 0x11,
	0x12, 0xad, 0xb4, 0x5e, 0x70, 0x4f, 0x11, 0x52, 0x05, 0x13, 0x28, 0xd5, 0x6e, 0xb8, 0x89, 0xd2,
	0xd4, 0xcd, 0x8e, 0x1a, 0xff, 0xc8, 0x76, 0x27, 0x85, 0x97, 0xe0, 0xfd, 0x78, 0x1a, 0x14, 0xdb,
	0xa2, 0x2d, 0x4c, 0xbb, 0x3b, 0xfe, 0x7e, 0x4e, 0xbe, 0x73, 0x1c, 0xc3, 0x39, 0xd3, 0x72, 0xca,
	0xb4, 0x2c, 0x05, 0xdf, 0x60, 0x35, 0x91, 0x4a, 0x18, 0x41, 0xba, 0x4c, 0xcb, 0xe4, 0x03, 0xf4,
	0xaf, 0x97, 0xdf, 0xe7, 0x16, 0x27, 0x04, 0x4e, 0x4c, 0x23, 0x69, 0x14, 0xc4, 0x41, 0x7a, 0x9a,
	0xd9, 0x9a, 0x5c, 0x40, 0xcf, 0xb9, 0xa2, 0x4e, 0x1c, 0xa4, 0x61, 0xe6, 0x4f, 0xc9, 0xef, 0x0e,
	0x8c, 0x3f, 0x17, 0x2b, 0x85, 0xe5, 0x91, 0x9f, 0x17, 0xcc, 0xf9, 0xfb, 0x99, 0xad, 0xc9, 0x25,
	0x80, 0x12, 0xc2, 0xe4, 0x25, 0x55, 0x46, 0x47, 0x9d, 0xb8, 0x9b, 0x86, 0x59, 0xbf, 0x45, 0xe6,
	0x2d, 0x40, 0xde, 0x03, 0x41, 0x6e, 0xa8, 0x62, 0x74, 0x8d, 0x85, 0xa1, 0x5e, 0xd6, 0xb5, 0xb2,
	0xc7, 0x87, 0x8c, 0x93, 0x5f, 0x40, 0xaf, 0x58, 0x33, 0xe4, 0x3a, 0x3a, 0xb1, 0x12, 0x7f, 0x22,
	0x6f, 0x61, 0xac, 0xe8, 0x9d, 0x28, 0x0b, 0x83, 0x82, 0xe7, 0x35, 0x6a, 0x13, 0x9d, 0x5a, 0xc1,
	0x68, 0x0f, 0x7f, 0x45, 0x6d, 0xc8, 0x1c, 0x1e, 0x69, 0xac, 0x38, 0xf2, 0x2a, 0xc7, 0x35, 0xe5,
	0x06, 0x4d, 0x13, 0xf5, 0xe2, 0x20, 0x1d, 0x5c, 0x45, 0x13, 0xa6, 0xe5, 0x64, 0xe9, 0xc8, 0x85,
	0xe7, 0x16, 0x7c, 0x23, 0xb2, 0xb1, 0x3e, 0x06, 0x49, 0x0e, 0x2f, 0x85, 0xaa, 0x0a, 0x8e, 0x3f,
	0x6d, 0xe3, 0xa2, 0xce, 0x77, 0x1c, 0x8d, 0x6f, 0xb8, 0x41, 0xaa, 0x74, 0x74, 0x16, 0x77, 0xd3,
	0xc1, 0xd5, 0x33, 0xdb, 0xd3, 0xad, 0xe9, 0xdb, 0xcd, 0xe2, 0x2f, 0x9f, 0x5d, 0x1e, 0xfb, 0x6f,
	0x38, 0x9a, 0x3d, 0xab, 0x13, 0x01, 0xe7, 0xf7, 0x04, 0x21, 0xaf, 0x61, 0x28, 0x77, 0xab, 0x1a,
	0xcb, 0xbc, 0x4d, 0x44, 0x95, 0x5d, 0x74, 0x98, 0x85, 0x0e, 0x5c, 0x5a, 0x8c, 0xcc, 0x60, 0x24,
	0x15, 0xde, 0xb5, 0xcb, 0xf4, 0xaa, 0x8e, 0x9d, 0x2f, 0xb4, 0x59, 0xbe, 0x50, 0x37, 0xd3, 0xd0,
	0x6b, 0x9c, 0x29, 0x59, 0xc2, 0x99, 0x67, 0xc8, 0x1b, 0x18, 0x6d, 0x69, 0x73, 0x30, 0x8c, 0xbf,
	0xce, 0xe1, 0x96, 0x36, 0xfb, 0x8c, 0xe4, 0x15, 0x84, 0xad, 0x8c, 0x15, 0x86, 0x2a, 0x2c, 0x6a,
	0xff, 0x77, 0x0c, 0xb6, 0xb4, 0xb9, 0xf6, 0x50, 0xf2, 0x2b, 0x00, 0xf2, 0xff, 0xec, 0x64, 0x06,
	0x4f, 0xdb, 0x5b, 0x76, 0xa3, 0xfe, 0xfb, 0x9d, 0x30, 0x7b, 0xb2, 0x27, 0x0f, 0x4c, 0x9f, 0xe0,
	0xc5, 0xc3, 0x2b, 0xb7, 0x01, 0xfa, 0xd9, 0xf3, 0x87, 0x16, 0xfb, 0xf1, 0xdd, 0x8f, 0xb4, 0x42,
	0x73, 0xbb, 0x5b, 0x4d, 0x4a, 0xc1, 0xa6, 0xb7, 0x8d, 0xa4, 0xaa, 0xa6, 0xeb, 0x8a, 0xaa, 0xe9,
	0xc6, 0xe6, 0x9c, 0xda, 0x97, 0xa1, 0xdb, 0xa7, 0xb2, 0xea, 0xd9, 0x7a, 0xf6, 0x27, 0x00, 0x00,
	0xff, 0xff, 0x35, 0x7e, 0x6d, 0x6e, 0x3c, 0x03, 0x00, 0x00,
}
