// Code generated by protoc-gen-go.
// source: peer/proposal.proto
// DO NOT EDIT!

package peer

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

// This structure is necessary to sign the proposal which contains the header
// and the payload. Without this structure, we would have to concatenate the
// header and the payload to verify the signature, which could be expensive
// with large payload
//
// When an endorser receives a SignedProposal message, it should verify the
// signature over the proposal bytes. This verification requires the following
// steps:
// 1. Verification of the validity of the certificate that was used to produce
//    the signature.  The certificate will be available once proposalBytes has
//    been unmarshalled to a Proposal message, and Proposal.header has been
//    unmarshalled to a Header message. While this unmarshalling-before-verifying
//    might not be ideal, it is unavoidable because i) the signature needs to also
//    protect the signing certificate; ii) it is desirable that Header is created
//    once by the client and never changed (for the sake of accountability and
//    non-repudiation). Note also that it is actually impossible to conclusively
//    verify the validity of the certificate included in a Proposal, because the
//    proposal needs to first be endorsed and ordered with respect to certificate
//    expiration transactions. Still, it is useful to pre-filter expired
//    certificates at this stage.
// 2. Verification that the certificate is trusted (signed by a trusted CA) and
//    that it is allowed to transact with us (with respect to some ACLs);
// 3. Verification that the signature on proposalBytes is valid;
// 4. Detect replay attacks;
type SignedProposal struct {
	// The bytes of Proposal
	ProposalBytes []byte `protobuf:"bytes,1,opt,name=proposal_bytes,json=proposalBytes,proto3" json:"proposal_bytes,omitempty"`
	// Signaure over proposalBytes; this signature is to be verified against
	// the creator identity contained in the header of the Proposal message
	// marshaled as proposalBytes
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (m *SignedProposal) Reset()                    { *m = SignedProposal{} }
func (m *SignedProposal) String() string            { return proto.CompactTextString(m) }
func (*SignedProposal) ProtoMessage()               {}
func (*SignedProposal) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{0} }

// A Proposal is sent to an endorser for endorsement.  The proposal contains:
// 1. A header which should be unmarshaled to a Header message.  Note that
//    Header is both the header of a Proposal and of a Transaction, in that i)
//    both headers should be unmarshaled to this message; and ii) it is used to
//    compute cryptographic hashes and signatures.  The header has fields common
//    to all proposals/transactions.  In addition it has a type field for
//    additional customization. An example of this is the ChaincodeHeaderExtension
//    message used to extend the Header for type CHAINCODE.
// 2. A payload whose type depends on the header's type field.
// 3. An extension whose type depends on the header's type field.
//
// Let us see an example. For type CHAINCODE (see the Header message),
// we have the following:
// 1. The header is a Header message whose extensions field is a
//    ChaincodeHeaderExtension message.
// 2. The payload is a ChaincodeProposalPayload message.
// 3. The extension is a ChaincodeAction that might be used to ask the
//    endorsers to endorse a specific ChaincodeAction, thus emulating the
//    submitting peer model.
type Proposal struct {
	// The header of the proposal. It is the bytes of the Header
	Header []byte `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// The payload of the proposal as defined by the type in the proposal
	// header.
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
	// Optional extensions to the proposal. Its content depends on the Header's
	// type field.  For the type CHAINCODE, it might be the bytes of a
	// ChaincodeAction message.
	Extension []byte `protobuf:"bytes,3,opt,name=extension,proto3" json:"extension,omitempty"`
}

func (m *Proposal) Reset()                    { *m = Proposal{} }
func (m *Proposal) String() string            { return proto.CompactTextString(m) }
func (*Proposal) ProtoMessage()               {}
func (*Proposal) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{1} }

// ChaincodeHeaderExtension is the Header's extentions message to be used when
// the Header's type is CHAINCODE.  This extensions is used to specify which
// chaincode to invoke and what should appear on the ledger.
type ChaincodeHeaderExtension struct {
	// The PayloadVisibility field controls to what extent the Proposal's payload
	// (recall that for the type CHAINCODE, it is ChaincodeProposalPayload
	// message) field will be visible in the final transaction and in the ledger.
	// Ideally, it would be configurable, supporting at least 3 main visibility
	// modes:
	// 1. all bytes of the payload are visible;
	// 2. only a hash of the payload is visible;
	// 3. nothing is visible.
	// Notice that the visibility function may be potentially part of the ESCC.
	// In that case it overrides PayloadVisibility field.  Finally notice that
	// this field impacts the content of ProposalResponsePayload.proposalHash.
	PayloadVisibility []byte `protobuf:"bytes,1,opt,name=payload_visibility,json=payloadVisibility,proto3" json:"payload_visibility,omitempty"`
	// The ID of the chaincode to target.
	ChaincodeId *ChaincodeID `protobuf:"bytes,2,opt,name=chaincode_id,json=chaincodeId" json:"chaincode_id,omitempty"`
}

func (m *ChaincodeHeaderExtension) Reset()                    { *m = ChaincodeHeaderExtension{} }
func (m *ChaincodeHeaderExtension) String() string            { return proto.CompactTextString(m) }
func (*ChaincodeHeaderExtension) ProtoMessage()               {}
func (*ChaincodeHeaderExtension) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{2} }

func (m *ChaincodeHeaderExtension) GetChaincodeId() *ChaincodeID {
	if m != nil {
		return m.ChaincodeId
	}
	return nil
}

// ChaincodeProposalPayload is the Proposal's payload message to be used when
// the Header's type is CHAINCODE.  It contains the arguments for this
// invocation.
type ChaincodeProposalPayload struct {
	// Input contains the arguments for this invocation. If this invocation
	// deploys a new chaincode, ESCC/VSCC are part of this field.
	Input []byte `protobuf:"bytes,1,opt,name=input,proto3" json:"input,omitempty"`
	// TransientMap contains data (e.g. cryptographic material) that might be used
	// to implement some form of application-level confidentiality. The contents
	// of this field are supposed to always be omitted from the transaction and
	// excluded from the ledger.
	TransientMap map[string][]byte `protobuf:"bytes,2,rep,name=TransientMap" json:"TransientMap,omitempty" protobuf_key:"bytes,1,opt,name=key" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (m *ChaincodeProposalPayload) Reset()                    { *m = ChaincodeProposalPayload{} }
func (m *ChaincodeProposalPayload) String() string            { return proto.CompactTextString(m) }
func (*ChaincodeProposalPayload) ProtoMessage()               {}
func (*ChaincodeProposalPayload) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{3} }

func (m *ChaincodeProposalPayload) GetTransientMap() map[string][]byte {
	if m != nil {
		return m.TransientMap
	}
	return nil
}

// ChaincodeAction contains the actions the events generated by the execution
// of the chaincode.
type ChaincodeAction struct {
	// This field contains the read set and the write set produced by the
	// chaincode executing this invocation.
	Results []byte `protobuf:"bytes,1,opt,name=results,proto3" json:"results,omitempty"`
	// This field contains the events generated by the chaincode executing this
	// invocation.
	Events []byte `protobuf:"bytes,2,opt,name=events,proto3" json:"events,omitempty"`
	// This field contains the result of executing this invocation.
	Response *Response `protobuf:"bytes,3,opt,name=response" json:"response,omitempty"`
}

func (m *ChaincodeAction) Reset()                    { *m = ChaincodeAction{} }
func (m *ChaincodeAction) String() string            { return proto.CompactTextString(m) }
func (*ChaincodeAction) ProtoMessage()               {}
func (*ChaincodeAction) Descriptor() ([]byte, []int) { return fileDescriptor7, []int{4} }

func (m *ChaincodeAction) GetResponse() *Response {
	if m != nil {
		return m.Response
	}
	return nil
}

func init() {
	proto.RegisterType((*SignedProposal)(nil), "protos.SignedProposal")
	proto.RegisterType((*Proposal)(nil), "protos.Proposal")
	proto.RegisterType((*ChaincodeHeaderExtension)(nil), "protos.ChaincodeHeaderExtension")
	proto.RegisterType((*ChaincodeProposalPayload)(nil), "protos.ChaincodeProposalPayload")
	proto.RegisterType((*ChaincodeAction)(nil), "protos.ChaincodeAction")
}

func init() { proto.RegisterFile("peer/proposal.proto", fileDescriptor7) }

var fileDescriptor7 = []byte{
	// 419 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x64, 0x52, 0xdf, 0x6b, 0xd4, 0x40,
	0x10, 0xe6, 0xee, 0xb0, 0x3f, 0x26, 0x67, 0x6d, 0xb7, 0x45, 0xc2, 0xd1, 0x87, 0x12, 0x10, 0x2a,
	0x6a, 0x02, 0x11, 0x44, 0x7c, 0x11, 0xab, 0x05, 0xfb, 0x20, 0x94, 0xa8, 0x7d, 0xe8, 0xcb, 0xb1,
	0x49, 0xc6, 0x64, 0x31, 0xee, 0xae, 0xbb, 0x9b, 0xc3, 0x3c, 0xfa, 0xe7, 0xf9, 0x5f, 0x49, 0xb2,
	0x3f, 0x6c, 0xbd, 0xa7, 0xe4, 0x9b, 0xef, 0x9b, 0x6f, 0x66, 0x76, 0x06, 0x8e, 0x25, 0xa2, 0xca,
	0xa4, 0x12, 0x52, 0x68, 0xda, 0xa5, 0x52, 0x09, 0x23, 0xc8, 0xce, 0xf4, 0xd1, 0xab, 0x93, 0x89,
	0xac, 0x5a, 0xca, 0x78, 0x25, 0x6a, 0xb4, 0xec, 0xea, 0xf4, 0x5e, 0xca, 0x5a, 0xa1, 0x96, 0x82,
	0x6b, 0xc7, 0x26, 0x5f, 0xe1, 0xe0, 0x33, 0x6b, 0x38, 0xd6, 0xd7, 0x4e, 0x40, 0x9e, 0xc0, 0x41,
	0x10, 0x97, 0x83, 0x41, 0x1d, 0xcf, 0xce, 0x66, 0xe7, 0xcb, 0xe2, 0xa1, 0x8f, 0x5e, 0x8c, 0x41,
	0x72, 0x0a, 0xfb, 0x9a, 0x35, 0x9c, 0x9a, 0x5e, 0x61, 0x3c, 0x9f, 0x14, 0xff, 0x02, 0xc9, 0x2d,
	0xec, 0x05, 0xc3, 0xc7, 0xb0, 0xd3, 0x22, 0xad, 0x51, 0x39, 0x23, 0x87, 0x48, 0x0c, 0xbb, 0x92,
	0x0e, 0x9d, 0xa0, 0xb5, 0xcb, 0xf7, 0x70, 0xf4, 0xc6, 0x5f, 0x06, 0xb9, 0x66, 0x82, 0xc7, 0x0b,
	0xeb, 0x1d, 0x02, 0xc9, 0xef, 0x19, 0xc4, 0xef, 0xfd, 0x90, 0x1f, 0x27, 0xaf, 0x4b, 0x4f, 0x92,
	0x17, 0x40, 0x9c, 0xcb, 0x7a, 0xc3, 0x34, 0x2b, 0x59, 0xc7, 0xcc, 0xe0, 0x0a, 0x1f, 0x39, 0xe6,
	0x26, 0x10, 0xe4, 0x15, 0x2c, 0xc3, 0x7b, 0xad, 0x99, 0x6d, 0x24, 0xca, 0x8f, 0xed, 0xe3, 0xe8,
	0x34, 0x94, 0xb9, 0xfa, 0x50, 0x44, 0x41, 0x78, 0x55, 0x27, 0x7f, 0xee, 0xf6, 0xe0, 0x27, 0xbd,
	0x76, 0xed, 0x9f, 0xc0, 0x03, 0xc6, 0x65, 0x6f, 0x5c, 0x59, 0x0b, 0xc8, 0x0d, 0x2c, 0xbf, 0x28,
	0xca, 0x35, 0x43, 0x6e, 0x3e, 0x51, 0x19, 0xcf, 0xcf, 0x16, 0xe7, 0x51, 0x9e, 0x6f, 0x95, 0xfa,
	0xcf, 0x2d, 0xbd, 0x9b, 0x74, 0xc9, 0x8d, 0x1a, 0x8a, 0x7b, 0x3e, 0xab, 0xb7, 0x70, 0xb4, 0x25,
	0x21, 0x87, 0xb0, 0xf8, 0x8e, 0x76, 0xee, 0xfd, 0x62, 0xfc, 0x1d, 0x9b, 0xda, 0xd0, 0xae, 0xf7,
	0xbb, 0xb2, 0xe0, 0xcd, 0xfc, 0xf5, 0x2c, 0xf9, 0x09, 0x8f, 0x42, 0xf1, 0x77, 0x95, 0x19, 0x5f,
	0x31, 0x86, 0x5d, 0x85, 0xba, 0xef, 0x8c, 0x5f, 0xbe, 0x87, 0xe3, 0x32, 0x71, 0x83, 0xdc, 0x68,
	0xe7, 0xe3, 0x10, 0x79, 0x0e, 0x7b, 0xfe, 0xb2, 0xa6, 0x8d, 0x45, 0xf9, 0xa1, 0x9f, 0xac, 0x70,
	0xf1, 0x22, 0x28, 0x2e, 0x9e, 0xdd, 0x3e, 0x6d, 0x98, 0x69, 0xfb, 0x32, 0xad, 0xc4, 0x8f, 0xac,
	0x1d, 0x24, 0xaa, 0x0e, 0xeb, 0x06, 0x55, 0xf6, 0x8d, 0x96, 0x8a, 0x55, 0x99, 0x4d, 0xcd, 0xc6,
	0xd3, 0x2d, 0xed, 0x79, 0xbf, 0xfc, 0x1b, 0x00, 0x00, 0xff, 0xff, 0x28, 0x14, 0xac, 0x8e, 0xfc,
	0x02, 0x00, 0x00,
}
