// Code generated by protoc-gen-go.
// source: peer/transaction.proto
// DO NOT EDIT!

package peer

import proto "github.com/golang/protobuf/proto"
import fmt "fmt"
import math "math"
import _ "github.com/golang/protobuf/ptypes/timestamp"
import common "github.com/hyperledger/fabric/protos/common"

// Reference imports to suppress errors if they are not otherwise used.
var _ = proto.Marshal
var _ = fmt.Errorf
var _ = math.Inf

type TxValidationCode int32

const (
	TxValidationCode_VALID                        TxValidationCode = 0
	TxValidationCode_NIL_ENVELOPE                 TxValidationCode = 1
	TxValidationCode_BAD_PAYLOAD                  TxValidationCode = 2
	TxValidationCode_BAD_COMMON_HEADER            TxValidationCode = 3
	TxValidationCode_BAD_CREATOR_SIGNATURE        TxValidationCode = 4
	TxValidationCode_INVALID_ENDORSER_TRANSACTION TxValidationCode = 5
	TxValidationCode_INVALID_CONFIG_TRANSACTION   TxValidationCode = 6
	TxValidationCode_UNSUPPORTED_TX_PAYLOAD       TxValidationCode = 7
	TxValidationCode_BAD_PROPOSAL_TXID            TxValidationCode = 8
	TxValidationCode_DUPLICATE_TXID               TxValidationCode = 9
	TxValidationCode_ENDORSEMENT_POLICY_FAILURE   TxValidationCode = 10
	TxValidationCode_MVCC_READ_CONFLICT           TxValidationCode = 11
	TxValidationCode_PHANTOM_READ_CONFLICT        TxValidationCode = 12
	TxValidationCode_UNKNOWN_TX_TYPE              TxValidationCode = 13
	TxValidationCode_TARGET_CHAIN_NOT_FOUND       TxValidationCode = 14
	TxValidationCode_MARSHAL_TX_ERROR             TxValidationCode = 15
	TxValidationCode_NIL_TXACTION                 TxValidationCode = 16
	TxValidationCode_INVALID_OTHER_REASON         TxValidationCode = 255
)

var TxValidationCode_name = map[int32]string{
	0:   "VALID",
	1:   "NIL_ENVELOPE",
	2:   "BAD_PAYLOAD",
	3:   "BAD_COMMON_HEADER",
	4:   "BAD_CREATOR_SIGNATURE",
	5:   "INVALID_ENDORSER_TRANSACTION",
	6:   "INVALID_CONFIG_TRANSACTION",
	7:   "UNSUPPORTED_TX_PAYLOAD",
	8:   "BAD_PROPOSAL_TXID",
	9:   "DUPLICATE_TXID",
	10:  "ENDORSEMENT_POLICY_FAILURE",
	11:  "MVCC_READ_CONFLICT",
	12:  "PHANTOM_READ_CONFLICT",
	13:  "UNKNOWN_TX_TYPE",
	14:  "TARGET_CHAIN_NOT_FOUND",
	15:  "MARSHAL_TX_ERROR",
	16:  "NIL_TXACTION",
	255: "INVALID_OTHER_REASON",
}
var TxValidationCode_value = map[string]int32{
	"VALID":                        0,
	"NIL_ENVELOPE":                 1,
	"BAD_PAYLOAD":                  2,
	"BAD_COMMON_HEADER":            3,
	"BAD_CREATOR_SIGNATURE":        4,
	"INVALID_ENDORSER_TRANSACTION": 5,
	"INVALID_CONFIG_TRANSACTION":   6,
	"UNSUPPORTED_TX_PAYLOAD":       7,
	"BAD_PROPOSAL_TXID":            8,
	"DUPLICATE_TXID":               9,
	"ENDORSEMENT_POLICY_FAILURE":   10,
	"MVCC_READ_CONFLICT":           11,
	"PHANTOM_READ_CONFLICT":        12,
	"UNKNOWN_TX_TYPE":              13,
	"TARGET_CHAIN_NOT_FOUND":       14,
	"MARSHAL_TX_ERROR":             15,
	"NIL_TXACTION":                 16,
	"INVALID_OTHER_REASON":         255,
}

func (x TxValidationCode) String() string {
	return proto.EnumName(TxValidationCode_name, int32(x))
}
func (TxValidationCode) EnumDescriptor() ([]byte, []int) { return fileDescriptor10, []int{0} }

// This message is necessary to facilitate the verification of the signature
// (in the signature field) over the bytes of the transaction (in the
// transactionBytes field).
type SignedTransaction struct {
	// The bytes of the Transaction. NDD
	TransactionBytes []byte `protobuf:"bytes,1,opt,name=transaction_bytes,json=transactionBytes,proto3" json:"transaction_bytes,omitempty"`
	// Signature of the transactionBytes The public key of the signature is in
	// the header field of TransactionAction There might be multiple
	// TransactionAction, so multiple headers, but there should be same
	// transactor identity (cert) in all headers
	Signature []byte `protobuf:"bytes,2,opt,name=signature,proto3" json:"signature,omitempty"`
}

func (m *SignedTransaction) Reset()                    { *m = SignedTransaction{} }
func (m *SignedTransaction) String() string            { return proto.CompactTextString(m) }
func (*SignedTransaction) ProtoMessage()               {}
func (*SignedTransaction) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{0} }

// ProcessedTransaction wraps an Envelope that includes a transaction along with an indication
// of whether the transaction was validated or invalidated by committing peer.
// The use case is that GetTransactionByID API needs to retrieve the transaction Envelope
// from block storage, and return it to a client, and indicate whether the transaction
// was validated or invalidated by committing peer. So that the originally submitted
// transaction Envelope is not modified, the ProcessedTransaction wrapper is returned.
type ProcessedTransaction struct {
	// An Envelope which includes a processed transaction
	TransactionEnvelope *common.Envelope `protobuf:"bytes,1,opt,name=transactionEnvelope" json:"transactionEnvelope,omitempty"`
	// An indication of whether the transaction was validated or invalidated by committing peer
	ValidationCode int32 `protobuf:"varint,2,opt,name=validationCode" json:"validationCode,omitempty"`
}

func (m *ProcessedTransaction) Reset()                    { *m = ProcessedTransaction{} }
func (m *ProcessedTransaction) String() string            { return proto.CompactTextString(m) }
func (*ProcessedTransaction) ProtoMessage()               {}
func (*ProcessedTransaction) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{1} }

func (m *ProcessedTransaction) GetTransactionEnvelope() *common.Envelope {
	if m != nil {
		return m.TransactionEnvelope
	}
	return nil
}

// The transaction to be sent to the ordering service. A transaction contains
// one or more TransactionAction. Each TransactionAction binds a proposal to
// potentially multiple actions. The transaction is atomic meaning that either
// all actions in the transaction will be committed or none will.  Note that
// while a Transaction might include more than one Header, the Header.creator
// field must be the same in each.
// A single client is free to issue a number of independent Proposal, each with
// their header (Header) and request payload (ChaincodeProposalPayload).  Each
// proposal is independently endorsed generating an action
// (ProposalResponsePayload) with one signature per Endorser. Any number of
// independent proposals (and their action) might be included in a transaction
// to ensure that they are treated atomically.
type Transaction struct {
	// The payload is an array of TransactionAction. An array is necessary to
	// accommodate multiple actions per transaction
	Actions []*TransactionAction `protobuf:"bytes,1,rep,name=actions" json:"actions,omitempty"`
}

func (m *Transaction) Reset()                    { *m = Transaction{} }
func (m *Transaction) String() string            { return proto.CompactTextString(m) }
func (*Transaction) ProtoMessage()               {}
func (*Transaction) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{2} }

func (m *Transaction) GetActions() []*TransactionAction {
	if m != nil {
		return m.Actions
	}
	return nil
}

// TransactionAction binds a proposal to its action.  The type field in the
// header dictates the type of action to be applied to the ledger.
type TransactionAction struct {
	// The header of the proposal action, which is the proposal header
	Header []byte `protobuf:"bytes,1,opt,name=header,proto3" json:"header,omitempty"`
	// The payload of the action as defined by the type in the header For
	// chaincode, it's the bytes of ChaincodeActionPayload
	Payload []byte `protobuf:"bytes,2,opt,name=payload,proto3" json:"payload,omitempty"`
}

func (m *TransactionAction) Reset()                    { *m = TransactionAction{} }
func (m *TransactionAction) String() string            { return proto.CompactTextString(m) }
func (*TransactionAction) ProtoMessage()               {}
func (*TransactionAction) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{3} }

// ChaincodeActionPayload is the message to be used for the TransactionAction's
// payload when the Header's type is set to CHAINCODE.  It carries the
// chaincodeProposalPayload and an endorsed action to apply to the ledger.
type ChaincodeActionPayload struct {
	// This field contains the bytes of the ChaincodeProposalPayload message from
	// the original invocation (essentially the arguments) after the application
	// of the visibility function. The main visibility modes are "full" (the
	// entire ChaincodeProposalPayload message is included here), "hash" (only
	// the hash of the ChaincodeProposalPayload message is included) or
	// "nothing".  This field will be used to check the consistency of
	// ProposalResponsePayload.proposalHash.  For the CHAINCODE type,
	// ProposalResponsePayload.proposalHash is supposed to be H(ProposalHeader ||
	// f(ChaincodeProposalPayload)) where f is the visibility function.
	ChaincodeProposalPayload []byte `protobuf:"bytes,1,opt,name=chaincode_proposal_payload,json=chaincodeProposalPayload,proto3" json:"chaincode_proposal_payload,omitempty"`
	// The list of actions to apply to the ledger
	Action *ChaincodeEndorsedAction `protobuf:"bytes,2,opt,name=action" json:"action,omitempty"`
}

func (m *ChaincodeActionPayload) Reset()                    { *m = ChaincodeActionPayload{} }
func (m *ChaincodeActionPayload) String() string            { return proto.CompactTextString(m) }
func (*ChaincodeActionPayload) ProtoMessage()               {}
func (*ChaincodeActionPayload) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{4} }

func (m *ChaincodeActionPayload) GetAction() *ChaincodeEndorsedAction {
	if m != nil {
		return m.Action
	}
	return nil
}

// ChaincodeEndorsedAction carries information about the endorsement of a
// specific proposal
type ChaincodeEndorsedAction struct {
	// This is the bytes of the ProposalResponsePayload message signed by the
	// endorsers.  Recall that for the CHAINCODE type, the
	// ProposalResponsePayload's extenstion field carries a ChaincodeAction
	ProposalResponsePayload []byte `protobuf:"bytes,1,opt,name=proposal_response_payload,json=proposalResponsePayload,proto3" json:"proposal_response_payload,omitempty"`
	// The endorsement of the proposal, basically the endorser's signature over
	// proposalResponsePayload
	Endorsements []*Endorsement `protobuf:"bytes,2,rep,name=endorsements" json:"endorsements,omitempty"`
}

func (m *ChaincodeEndorsedAction) Reset()                    { *m = ChaincodeEndorsedAction{} }
func (m *ChaincodeEndorsedAction) String() string            { return proto.CompactTextString(m) }
func (*ChaincodeEndorsedAction) ProtoMessage()               {}
func (*ChaincodeEndorsedAction) Descriptor() ([]byte, []int) { return fileDescriptor10, []int{5} }

func (m *ChaincodeEndorsedAction) GetEndorsements() []*Endorsement {
	if m != nil {
		return m.Endorsements
	}
	return nil
}

func init() {
	proto.RegisterType((*SignedTransaction)(nil), "protos.SignedTransaction")
	proto.RegisterType((*ProcessedTransaction)(nil), "protos.ProcessedTransaction")
	proto.RegisterType((*Transaction)(nil), "protos.Transaction")
	proto.RegisterType((*TransactionAction)(nil), "protos.TransactionAction")
	proto.RegisterType((*ChaincodeActionPayload)(nil), "protos.ChaincodeActionPayload")
	proto.RegisterType((*ChaincodeEndorsedAction)(nil), "protos.ChaincodeEndorsedAction")
	proto.RegisterEnum("protos.TxValidationCode", TxValidationCode_name, TxValidationCode_value)
}

func init() { proto.RegisterFile("peer/transaction.proto", fileDescriptor10) }

var fileDescriptor10 = []byte{
	// 724 bytes of a gzipped FileDescriptorProto
	0x1f, 0x8b, 0x08, 0x00, 0x00, 0x09, 0x6e, 0x88, 0x02, 0xff, 0x74, 0x54, 0x4d, 0x6f, 0xe3, 0x36,
	0x14, 0xac, 0x93, 0x26, 0x69, 0x9e, 0xd3, 0x84, 0x61, 0xb2, 0x5e, 0xc7, 0x08, 0xba, 0x0b, 0x1f,
	0x8a, 0x6d, 0x17, 0x88, 0x81, 0xec, 0xa1, 0x40, 0xd1, 0x0b, 0x2d, 0x31, 0xb1, 0x50, 0x99, 0x14,
	0x28, 0x3a, 0x4d, 0x7a, 0x28, 0x21, 0x5b, 0x5c, 0x47, 0x80, 0x2d, 0x0a, 0x92, 0xb2, 0x68, 0xae,
	0xfd, 0x01, 0xed, 0x7f, 0xea, 0x1f, 0x6b, 0xa1, 0x2f, 0x7f, 0x64, 0xdb, 0x8b, 0x69, 0xce, 0x8c,
	0xde, 0xcc, 0x7b, 0x94, 0x08, 0x9d, 0x44, 0xeb, 0x74, 0x90, 0xa7, 0x41, 0x9c, 0x05, 0xb3, 0x3c,
	0x32, 0xf1, 0x55, 0x92, 0x9a, 0xdc, 0xe0, 0xfd, 0x72, 0xc9, 0x7a, 0x6f, 0xe6, 0xc6, 0xcc, 0x17,
	0x7a, 0x50, 0x6e, 0xa7, 0x4f, 0x1f, 0x07, 0x79, 0xb4, 0xd4, 0x59, 0x1e, 0x2c, 0x93, 0x4a, 0xd8,
	0xbb, 0x2c, 0x0b, 0x24, 0xa9, 0x49, 0x4c, 0x16, 0x2c, 0x54, 0xaa, 0xb3, 0xc4, 0xc4, 0x99, 0xae,
	0xd9, 0xb3, 0x99, 0x59, 0x2e, 0x4d, 0x3c, 0xa8, 0x96, 0x0a, 0xec, 0xff, 0x06, 0xa7, 0x7e, 0x34,
	0x8f, 0x75, 0x28, 0xd7, 0xb6, 0xf8, 0x3d, 0x9c, 0x6e, 0xa4, 0x50, 0xd3, 0xe7, 0x5c, 0x67, 0xdd,
	0xd6, 0xdb, 0xd6, 0xbb, 0x23, 0x81, 0x36, 0x88, 0x61, 0x81, 0xe3, 0x4b, 0x38, 0xcc, 0xa2, 0x79,
	0x1c, 0xe4, 0x4f, 0xa9, 0xee, 0xee, 0x94, 0xa2, 0x35, 0xd0, 0xff, 0xa3, 0x05, 0xe7, 0x5e, 0x6a,
	0x66, 0x3a, 0xcb, 0xb6, 0x3d, 0x86, 0x70, 0xb6, 0x51, 0x8a, 0xc6, 0x9f, 0xf4, 0xc2, 0x24, 0xba,
	0x74, 0x69, 0x5f, 0xa3, 0xab, 0x3a, 0x64, 0x83, 0x8b, 0xff, 0x12, 0xe3, 0x6f, 0xe1, 0xf8, 0x53,
	0xb0, 0x88, 0xc2, 0xa0, 0x40, 0x2d, 0x13, 0x56, 0xfe, 0x7b, 0xe2, 0x05, 0xda, 0x1f, 0x42, 0x7b,
	0xd3, 0xfa, 0x03, 0x1c, 0x54, 0xff, 0x8a, 0xa6, 0x76, 0xdf, 0xb5, 0xaf, 0x2f, 0xaa, 0x61, 0x64,
	0x57, 0x1b, 0x2a, 0x52, 0xfe, 0x8a, 0x46, 0xd9, 0xa7, 0x70, 0xfa, 0x19, 0x8b, 0x3b, 0xb0, 0xff,
	0xa8, 0x83, 0x50, 0xa7, 0xf5, 0x74, 0xea, 0x1d, 0xee, 0xc2, 0x41, 0x12, 0x3c, 0x2f, 0x4c, 0x10,
	0xd6, 0x13, 0x69, 0xb6, 0xfd, 0xbf, 0x5a, 0xd0, 0xb1, 0x1e, 0x83, 0x28, 0x9e, 0x99, 0x50, 0x57,
	0x55, 0xbc, 0x8a, 0xc2, 0x3f, 0x41, 0x6f, 0xd6, 0x30, 0x6a, 0x75, 0x88, 0x4d, 0x9d, 0xca, 0xa0,
	0xbb, 0x52, 0x78, 0xb5, 0xa0, 0x79, 0xfa, 0x07, 0xd8, 0xaf, 0xa2, 0x95, 0x8e, 0xed, 0xeb, 0x37,
	0x4d, 0x4f, 0x2b, 0x37, 0x1a, 0x87, 0x26, 0xcd, 0x74, 0x58, 0x77, 0x56, 0xcb, 0xfb, 0x7f, 0xb6,
	0xe0, 0xf5, 0xff, 0x68, 0xf0, 0x8f, 0x70, 0xf1, 0xd9, 0xdb, 0xf4, 0x22, 0xd1, 0xeb, 0x46, 0x20,
	0x6a, 0x7e, 0x1d, 0xe8, 0x48, 0x57, 0xd5, 0x96, 0x3a, 0xce, 0xb3, 0xee, 0x4e, 0x39, 0xea, 0xb3,
	0x26, 0x16, 0x5d, 0x73, 0x62, 0x4b, 0xf8, 0xfd, 0xdf, 0xbb, 0x80, 0xe4, 0xef, 0x77, 0x5b, 0x47,
	0x88, 0x0f, 0x61, 0xef, 0x8e, 0xb8, 0x8e, 0x8d, 0xbe, 0xc0, 0x08, 0x8e, 0x98, 0xe3, 0x2a, 0xca,
	0xee, 0xa8, 0xcb, 0x3d, 0x8a, 0x5a, 0xf8, 0x04, 0xda, 0x43, 0x62, 0x2b, 0x8f, 0x3c, 0xb8, 0x9c,
	0xd8, 0x68, 0x07, 0xbf, 0x82, 0xd3, 0x02, 0xb0, 0xf8, 0x78, 0xcc, 0x99, 0x1a, 0x51, 0x62, 0x53,
	0x81, 0x76, 0xf1, 0x05, 0xbc, 0x2a, 0x61, 0x41, 0x89, 0xe4, 0x42, 0xf9, 0xce, 0x2d, 0x23, 0x72,
	0x22, 0x28, 0xfa, 0x12, 0xbf, 0x85, 0x4b, 0x87, 0x95, 0x0e, 0x8a, 0x32, 0x9b, 0x0b, 0x9f, 0x0a,
	0x25, 0x05, 0x61, 0x3e, 0xb1, 0xa4, 0xc3, 0x19, 0xda, 0xc3, 0xdf, 0x40, 0xaf, 0x51, 0x58, 0x9c,
	0xdd, 0x38, 0xb7, 0x5b, 0xfc, 0x3e, 0xee, 0x41, 0x67, 0xc2, 0xfc, 0x89, 0xe7, 0x71, 0x21, 0xa9,
	0xad, 0xe4, 0xfd, 0x2a, 0xcf, 0x41, 0x93, 0xc7, 0x13, 0xdc, 0xe3, 0x3e, 0x71, 0x95, 0xbc, 0x77,
	0x6c, 0xf4, 0x15, 0xc6, 0x70, 0x6c, 0x4f, 0x3c, 0xd7, 0xb1, 0x88, 0xa4, 0x15, 0x76, 0x58, 0xd8,
	0xd4, 0x01, 0xc6, 0x94, 0x49, 0xe5, 0x71, 0xd7, 0xb1, 0x1e, 0xd4, 0x0d, 0x71, 0xdc, 0x22, 0x28,
	0xe0, 0x0e, 0xe0, 0xf1, 0x9d, 0x65, 0x29, 0x41, 0x49, 0x15, 0xc4, 0x75, 0x2c, 0x89, 0xda, 0x45,
	0x6f, 0xde, 0x88, 0x30, 0xc9, 0xc7, 0x2f, 0xa8, 0x23, 0x7c, 0x06, 0x27, 0x13, 0xf6, 0x33, 0xe3,
	0xbf, 0xb0, 0x22, 0x95, 0x7c, 0xf0, 0x28, 0xfa, 0xba, 0x88, 0x2b, 0x89, 0xb8, 0xa5, 0x52, 0x59,
	0x23, 0xe2, 0x30, 0xc5, 0xb8, 0x54, 0x37, 0x7c, 0xc2, 0x6c, 0x74, 0x8c, 0xcf, 0x01, 0x8d, 0x89,
	0xf0, 0x47, 0x65, 0x52, 0x45, 0x85, 0xe0, 0x02, 0x9d, 0x34, 0x73, 0x97, 0xf7, 0x75, 0xcb, 0x08,
	0x5f, 0xc0, 0x79, 0x33, 0x12, 0x2e, 0x47, 0x54, 0x14, 0xce, 0x3e, 0x67, 0xe8, 0x9f, 0xd6, 0xf0,
	0xfd, 0xaf, 0xdf, 0xcd, 0xa3, 0xfc, 0xf1, 0x69, 0x5a, 0x7c, 0xc9, 0x83, 0xc7, 0xe7, 0x44, 0xa7,
	0x0b, 0x1d, 0xce, 0x75, 0x3a, 0xf8, 0x18, 0x4c, 0xd3, 0x68, 0x56, 0x5d, 0x62, 0xd9, 0xa0, 0xb8,
	0xb1, 0xa6, 0xd5, 0x05, 0xf7, 0xe1, 0xdf, 0x00, 0x00, 0x00, 0xff, 0xff, 0xa1, 0x6e, 0x52, 0x79,
	0x01, 0x05, 0x00, 0x00,
}
