cask :v1 => 'malwarebytes-anti-malware' do
  version '1.1.3.72'
  sha256 '9ef3c6e40b7995e6b9d1b4724881e21f8b4028c5199f346215cb8afb148a925e'

  # mbamupdates.com is the official download host per the vendor homepage
  url "https://data-cdn.mbamupdates.com/v1/mbam-mac/data/mbam-mac-#{version}.zip"
  name 'Malwarebytes Anti-Malware for Mac'
  name 'AdwareMedic'
  appcast 'https://data-cdn.mbamupdates.com/v1/mbam-mac/updates.xml',
          :sha256 => '9ef3c6e40b7995e6b9d1b4724881e21f8b4028c5199f346215cb8afb148a925e',
          :format => :sparkle
  homepage 'https://www.malwarebytes.org/antimalware/mac/'
  license :gratis

  app 'Malwarebytes Anti-Malware.app'

  zap :delete => [
                  '~/Library/Preferences/com.malwarebytes.antimalware.plist',
                  '~/Library/Caches/com.malwarebytes.antimalware',
                  '~/Library/Application Support/com.malwarebytes.antimalware',
                  '~/Library/Saved Application State/com.malwarebytes.antimalware.savedState'
                 ]

  depends_on :macos => '>= :lion'
end
