/*
Copyright 2016 The Rook Authors. All rights reserved.

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

	http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.

Some of the code below came from https://github.com/coreos/etcd-operator
which also has the apache 2.0 license.
*/
package operator

import "sync"

type tprTracker struct {
	stopChMap   map[string]chan struct{}
	clusterRVs  map[string]string
	waitCluster sync.WaitGroup
}

func newTPRTracker() *tprTracker {
	return &tprTracker{
		clusterRVs: make(map[string]string),
		stopChMap:  map[string]chan struct{}{},
	}
}

func (t *tprTracker) add(name, version string) {
	t.stopChMap[name] = make(chan struct{})
	t.clusterRVs[name] = version
}

func (t *tprTracker) stop() {
	for _, stop := range t.stopChMap {
		close(stop)
	}
	t.waitCluster.Wait()
}
