/* SPDX-License-Identifier: GPL-2.0-only */

#ifndef AMD_STONEYRIDGE_GPIO_H
#define AMD_STONEYRIDGE_GPIO_H

#define GPIO_DEVICE_NAME	"AMD0030"
#define GPIO_DEVICE_DESC	"GPIO Controller"

#ifndef __ACPI__
#include <soc/iomap.h>
#include <amdblocks/gpio_banks.h>

/* The following sections describe only the GPIOs defined for this SOC */

#define SOC_GPIO_TOTAL_PINS		149

/* Bank 0: GPIO_0 - GPIO_63 */
#define GPIO_0				0
#define GPIO_1				1
#define GPIO_2				2
#define GPIO_3				3
#define GPIO_4				4
#define GPIO_5				5
#define GPIO_6				6
#define GPIO_7				7
#define GPIO_8				8
#define GPIO_9				9
#define GPIO_10				10
#define GPIO_11				11
#define GPIO_12				12
#define GPIO_13				13
#define GPIO_14				14
#define GPIO_15				15
#define GPIO_16				16
#define GPIO_17				17
#define GPIO_18				18
#define GPIO_19				19
#define GPIO_20				20
#define GPIO_21				21
#define GPIO_22				22
#define GPIO_23				23
#define GPIO_24				24
#define GPIO_25				25
#define GPIO_26				26
#define GPIO_39				39
#define GPIO_40				40
#define GPIO_42				42

/* Bank 1: GPIO_64 - GPIO_127 */
#define GPIO_64				64
#define GPIO_65				65
#define GPIO_66				66
#define GPIO_67				67
#define GPIO_68				68
#define GPIO_69				69
#define GPIO_70				70
#define GPIO_71				71
#define GPIO_72				72
#define GPIO_74				74
#define GPIO_75				75
#define GPIO_76				76
#define GPIO_84				84
#define GPIO_85				85
#define GPIO_86				86
#define GPIO_87				87
#define GPIO_88				88
#define GPIO_89				89
#define GPIO_90				90
#define GPIO_91				91
#define GPIO_92				92
#define GPIO_93				93
#define GPIO_95				95
#define GPIO_96				96
#define GPIO_97				97
#define GPIO_98				98
#define GPIO_99				99
#define GPIO_100			100
#define GPIO_101			101
#define GPIO_102			102
#define GPIO_113			113
#define GPIO_114			114
#define GPIO_115			115
#define GPIO_116			116
#define GPIO_117			117
#define GPIO_118			118
#define GPIO_119			119
#define GPIO_120			120
#define GPIO_121			121
#define GPIO_122			122
#define GPIO_126			126

/* Bank 2: GPIO_128 - GPIO_191 */
#define GPIO_129			129
#define GPIO_130			130
#define GPIO_131			131
#define GPIO_132			132
#define GPIO_133			133
#define GPIO_134			134
#define GPIO_135			135
#define GPIO_136			136
#define GPIO_137			137
#define GPIO_138			138
#define GPIO_139			139
#define GPIO_140			140
#define GPIO_141			141
#define GPIO_142			142
#define GPIO_143			143
#define GPIO_144			144
#define GPIO_145			145
#define GPIO_146			146
#define GPIO_147			147
#define GPIO_148			148

#define GPIO_SCL_HIGH			0
#define GPIO_SCL_LOW			GPIO_OUTPUT_ENABLE

/* IOMUX function names and values generated from BKDG. */
#define GPIO_0_IOMUX_PWR_BTN_L 0
#define GPIO_0_IOMUX_GPIOxx 1
#define GPIO_1_IOMUX_SYS_RESET_L 0
#define GPIO_1_IOMUX_GPIOxx 1
#define GPIO_2_IOMUX_WAKE_L 0
#define GPIO_2_IOMUX_GPIOxx 1
#define GPIO_3_IOMUX_GPIOxx 0
#define GPIO_4_IOMUX_GPIOxx 0
#define GPIO_5_IOMUX_GPIOxx 0
#define GPIO_5_IOMUX_DEVSLP0_S5 1
#define GPIO_6_IOMUX_GPIOxx 0
#define GPIO_6_IOMUX_LDT_RST_L 1
#define GPIO_7_IOMUX_GPIOxx 0
#define GPIO_7_IOMUX_LDT_PWROK 1
#define GPIO_8_IOMUX_GPIOxx 0
#define GPIO_8_IOMUX_SerPortTX_OUT 1
#define GPIO_9_IOMUX_GPIOxx 0
#define GPIO_9_IOMUX_SerPortRX_OUT 1
#define GPIO_10_IOMUX_S0A3_GPIO 0
#define GPIO_10_IOMUX_GPIOxx 1
#define GPIO_11_IOMUX_GPIOxx 0
#define GPIO_11_IOMUX_USB_OC7_L 1
#define GPIO_12_IOMUX_IR_LED_L 0
#define GPIO_12_IOMUX_LLB_L 1
#define GPIO_12_IOMUX_GPIOxx 2
#define GPIO_13_IOMUX_USB_OC5_L 0
#define GPIO_13_IOMUX_GPIOxx 1
#define GPIO_14_IOMUX_USB_OC6_L 0
#define GPIO_14_IOMUX_GPIOxx 1
#define GPIO_15_IOMUX_IR_RX1 0
#define GPIO_15_IOMUX_GPIOxx 1
#define GPIO_16_IOMUX_USB_OC0_L 0
#define GPIO_16_IOMUX_TRST_L 1
#define GPIO_16_IOMUX_GPIOxx 2
#define GPIO_17_IOMUX_USB_OC1_L 0
#define GPIO_17_IOMUX_TDI 1
#define GPIO_17_IOMUX_GPIOxx 2
#define GPIO_18_IOMUX_USB_OC2_L 0
#define GPIO_18_IOMUX_TCK 1
#define GPIO_18_IOMUX_GPIOxx 2
#define GPIO_19_IOMUX_SCL1 0
#define GPIO_19_IOMUX_I2C3_SCL 1
#define GPIO_19_IOMUX_GPIOxx 2
#define GPIO_20_IOMUX_SDA1 0
#define GPIO_20_IOMUX_I2C3_SDA 1
#define GPIO_20_IOMUX_GPIOxx 2
#define GPIO_21_IOMUX_LPC_PD_L 0
#define GPIO_21_IOMUX_GPIOxx 1
#define GPIO_22_IOMUX_LPC_PME_L 0
#define GPIO_22_IOMUX_GPIOxx 1
#define GPIO_23_IOMUX_USB_OC4_L 0
#define GPIO_23_IOMUX_IR_RX0 1
#define GPIO_23_IOMUX_GPIOxx 2
#define GPIO_24_IOMUX_USB_OC3_L 0
#define GPIO_24_IOMUX_GPIOxx 1
#define GPIO_25_IOMUX_SD0_CD 0
#define GPIO_25_IOMUX_GPIOxx 1
#define GPIO_26_IOMUX_PCIE_RST_L 0
#define GPIO_26_IOMUX_GPIOxx 1
#define GPIO_39_IOMUX_VDDGFX_PD 0
#define GPIO_39_IOMUX_GPIOxx 1
#define GPIO_40_IOMUX_GPIOxx 0
#define GPIO_42_IOMUX_S5_MUX_CTRL 0
#define GPIO_42_IOMUX_GPIOxx 1
#define GPIO_64_IOMUX_GPIOxx 0
#define GPIO_65_IOMUX_GPIOxx 0
#define GPIO_66_IOMUX_GPIOxx 0
#define GPIO_67_IOMUX_GPIOxx 0
#define GPIO_67_IOMUX_DEVSLP0 1
#define GPIO_69_IOMUX_GPIOxx 0
#define GPIO_69_IOMUX_SGPIO_LOAD 1
#define GPIO_70_IOMUX_GPIOxx 0
#define GPIO_70_IOMUX_DEVSLP1 1
#define GPIO_74_IOMUX_LPCCLK0 0
#define GPIO_74_IOMUX_GPIOxx 1
#define GPIO_75_IOMUX_LPCCLK1 0
#define GPIO_75_IOMUX_GPIOxx 1
#define GPIO_76_IOMUX_GPIOxx 0
#define GPIO_76_IOMUX_SPI_TPM_CS_L 1
#define GPIO_84_IOMUX_FANIN0 0
#define GPIO_84_IOMUX_GPIOxx 1
#define GPIO_85_IOMUX_FANOUT0 0
#define GPIO_85_IOMUX_GPIOxx 1
#define GPIO_86_IOMUX_GPIOxx 1
#define GPIO_87_IOMUX_SERIRQ 0
#define GPIO_87_IOMUX_GPIOxx 1
#define GPIO_88_IOMUX_LPC_CLKRUN_L 0
#define GPIO_88_IOMUX_GPIOxx 1
#define GPIO_90_IOMUX_GPIOxx 0
#define GPIO_91_IOMUX_SPKR 0
#define GPIO_91_IOMUX_GPIOxx 1
#define GPIO_92_IOMUX_CLK_REQ0_L 0
#define GPIO_92_IOMUX_SATA_IS0_L 1
#define GPIO_92_IOMUX_SATA_ZP0_L 2
#define GPIO_92_IOMUX_GPIOxx 3
#define GPIO_93_IOMUX_SD0_LED 0
#define GPIO_93_IOMUX_GPIOxx 1
#define GPIO_95_IOMUX_GPIOxx 0
#define GPIO_96_IOMUX_GPIOxx 0
#define GPIO_97_IOMUX_GPIOxx 0
#define GPIO_98_IOMUX_GPIOxx 0
#define GPIO_99_IOMUX_GPIOxx 0
#define GPIO_100_IOMUX_GPIOxx 0
#define GPIO_101_IOMUX_SD0_WP 0
#define GPIO_101_IOMUX_GPIOxx 1
#define GPIO_102_IOMUX_SD0_PWR_CTRL 0
#define GPIO_102_IOMUX_GPIOxx 1
#define GPIO_113_IOMUX_SCL0 0
#define GPIO_113_IOMUX_I2C2_SCL 1
#define GPIO_113_IOMUX_GPIOxx 2
#define GPIO_114_IOMUX_SDA0 0
#define GPIO_114_IOMUX_I2C2_SDA 1
#define GPIO_114_IOMUX_GPIOxx 2
#define GPIO_115_IOMUX_CLK_REQ1_L 0
#define GPIO_115_IOMUX_GPIOxx 1
#define GPIO_116_IOMUX_CLK_REQ2_L 0
#define GPIO_116_IOMUX_GPIOxx 1
#define GPIO_117_IOMUX_ESPI_CLK 0
#define GPIO_117_IOMUX_GPIOxx 1
#define GPIO_118_IOMUX_SPI_CS1_L 0
#define GPIO_118_IOMUX_GPIOxx 1
#define GPIO_119_IOMUX_SPI_CS2_L 0
#define GPIO_119_IOMUX_ESPI_CS_L 1
#define GPIO_119_IOMUX_GPIOxx 2
#define GPIO_120_IOMUX_ESPI_DAT1 0
#define GPIO_120_IOMUX_GPIOxx 1
#define GPIO_121_IOMUX_ESPI_DAT0 0
#define GPIO_121_IOMUX_GPIOxx 1
#define GPIO_122_IOMUX_ESPI_DAT2 0
#define GPIO_122_IOMUX_GPIOxx 1
#define GPIO_126_IOMUX_GA20IN 0
#define GPIO_126_IOMUX_GPIOxx 1
#define GPIO_129_IOMUX_KBRST_L 0
#define GPIO_129_IOMUX_GPIOxx 1
#define GPIO_130_IOMUX_SATA_ACT_L 0
#define GPIO_130_IOMUX_GPIOxx 1
#define GPIO_131_IOMUX_CLK_REQ3_L 0
#define GPIO_131_IOMUX_SATA_IS1_L 1
#define GPIO_131_IOMUX_SATA_ZP1_L 2
#define GPIO_131_IOMUX_GPIOxx 3
#define GPIO_132_IOMUX_CLK_REQG_L 0
#define GPIO_132_IOMUX_OSCIN 1
#define GPIO_132_IOMUX_GPIOxx 2
#define GPIO_133_IOMUX_ESPI_DAT3 0
#define GPIO_133_IOMUX_GPIOxx 1
#define GPIO_135_IOMUX_UART0_CTS_L 0
#define GPIO_135_IOMUX_GPIOxx 1
#define GPIO_136_IOMUX_UART0_RXD 0
#define GPIO_136_IOMUX_GPIOxx 1
#define GPIO_137_IOMUX_UART0_RTS_L 0
#define GPIO_137_IOMUX_GPIOxx 1
#define GPIO_138_IOMUX_UART0_TXD 0
#define GPIO_138_IOMUX_GPIOxx 1
#define GPIO_139_IOMUX_UART0_INTR 0
#define GPIO_139_IOMUX_GPIOxx 1
#define GPIO_140_IOMUX_UART1_CTS_L 0
#define GPIO_140_IOMUX_GPIOxx 1
#define GPIO_141_IOMUX_UART1_RXD 0
#define GPIO_141_IOMUX_GPIOxx 1
#define GPIO_142_IOMUX_UART1_RTS_L 0
#define GPIO_142_IOMUX_GPIOxx 1
#define GPIO_143_IOMUX_UART1_TXD 0
#define GPIO_143_IOMUX_GPIOxx 1
#define GPIO_144_IOMUX_UART1_INTR 0
#define GPIO_144_IOMUX_GPIOxx 1
#define GPIO_145_IOMUX_I2C0_SCL 0
#define GPIO_145_IOMUX_GPIOxx 1
#define GPIO_146_IOMUX_I2C0_SDA 0
#define GPIO_146_IOMUX_GPIOxx 1
#define GPIO_147_IOMUX_I2C1_SCL 0
#define GPIO_147_IOMUX_GPIOxx 1
#define GPIO_148_IOMUX_I2C1_SDA 0
#define GPIO_148_IOMUX_GPIOxx 1

#define GPIO_2_EVENT GEVENT_8

#endif /* __ACPI__ */
#endif /* AMD_STONEYRIDGE_GPIO_H */
