/* SPDX-License-Identifier: GPL-2.0-only */

#include <memlayout.h>
#include <arch/header.ld>

/* SYSTEM_IMEM : 0x14680000 - 0x146AB000 */
#define SSRAM_START(addr) REGION_START(ssram, addr)
#define SSRAM_END(addr) REGION_END(ssram, addr)

/* BOOT_IMEM   : 0x14800000 - 0x14980000 */
#define BSRAM_START(addr) REGION_START(bsram, addr)
#define BSRAM_END(addr) REGION_END(bsram, addr)

/* AOP : 0x0B000000 - 0x0B100000 */
#define AOPSRAM_START(addr) REGION_START(aopsram, addr)
#define AOPSRAM_END(addr) REGION_END(aopsram, addr)

SECTIONS
{
	AOPSRAM_START(0x0B000000)
	REGION(aop, 0x0B000000, 0x100000, 4096)
	AOPSRAM_END(0x0B100000)

	SSRAM_START(0x14680000)
	OVERLAP_VERSTAGE_ROMSTAGE(0x14680000, 100K)
	REGION(qcsdi, 0x14699000, 52K, 4K)
	SSRAM_END(0x146AB000)

	BSRAM_START(0x14800000)
	REGION(pbl_timestamps, 0x14800000, 84K, 4K)
	BOOTBLOCK(0x14819000, 40K)
	PRERAM_CBFS_CACHE(0x14823000, 70K)
	PRERAM_CBMEM_CONSOLE(0x14834800, 32K)
	TIMESTAMP(0x1483C800, 1K)
	TTB(0x1483D000, 56K)
	STACK(0x1484B000, 16K)
	VBOOT2_WORK(0x1484F000, 12K)
	DMA_COHERENT(0x14853000, 8K)
	REGION(ddr_training, 0x14855000, 8K, 4K)
	REGION(qclib_serial_log, 0x14857000, 4K, 4K)
	REGION(ddr_information, 0x1485B000, 1K, 1K)
	FMAP_CACHE(0x1485B400, 2K)
	CBFS_MCACHE(0x1485BC00,8K)
	REGION(dcb, 0x14875000, 32K, 4K)
	REGION(pmic, 0x1487D000, 96K, 4K)
	REGION(qclib, 0x14895000, 748K, 4K)
	BSRAM_END(0x14950000)

	DRAM_START(0x80000000)
	/* Various hardware/software subsystems make use of this area */
	REGION(dram_aop,  0x80800000, 0x040000, 0x1000)
	REGION(dram_soc,  0x80900000, 0x200000, 0x1000)
	BL31(0x80B00000, 1M)
	POSTRAM_CBFS_CACHE(0x9F800000, 16M)
	RAMSTAGE(0xA0800000, 16M)
}
