/** @file

Copyright (c) 2021, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

/*
 * Intel CPX-SP FSP has been using FSPM_CONFIG intead of FSP_M_CONFIG.
 * Other Intel FSPs have been using FSP_M_CONFIG. The feedback from Intel
 * is that they will converge to use FSPM_CONFIG over time. So both will
 * co-exist for some time. Today coreboot common code expects FSP_M_CONFIG.
 */
#define FSP_M_CONFIG	FSPM_CONFIG

#define SPEED_REC_96GT      0
#define SPEED_REC_104GT     1
#define ADAPTIVE_CTLE 	    0x3f

#define CPXSP_2S6KTI_EPARAM_TABLE \
        /* Socket 0  */                                                                                       \
        {0x0, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK0), 0x2C33383F, ADAPTIVE_CTLE},   \
        {0x0, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK1), 0x2B35353F, ADAPTIVE_CTLE},   \
        {0x0, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK2), 0x2D37353F, ADAPTIVE_CTLE},   \
        {0x0, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK3), 0x2D37353F, ADAPTIVE_CTLE},   \
        {0x0, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK4), 0x2D37353F, ADAPTIVE_CTLE},   \
        {0x0, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK5), 0x2C35363F, ADAPTIVE_CTLE},   \
        /* Socket 1 */                                                                                        \
        {0x1, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK0), 0x2C33383F, ADAPTIVE_CTLE},   \
        {0x1, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK1), 0x2B35353F, ADAPTIVE_CTLE},   \
        {0x1, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK2), 0x2D35373F, ADAPTIVE_CTLE},   \
        {0x1, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK3), 0x2D35373F, ADAPTIVE_CTLE},   \
        {0x1, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK4), 0x2A2F3A3F, ADAPTIVE_CTLE},   \
        {0x1, (1 << SPEED_REC_96GT) | (1 << SPEED_REC_104GT), (1 << KTI_LINK5), 0x2C35363F, ADAPTIVE_CTLE}

#define CPXSP_2S6KTI_EPARAM_TABLE_COUNT 12 // NOTE - needs to match number of elements in CPXSP_2S6KTI_EPARAM_TABLE


#pragma pack(1)

typedef struct {
	UINT8  SocketID;
	UINT8  Freq;
	UINT32 Link;
	UINT32 AllLanesTXEQ;
	UINT8  CTLEPEAK;
} ALL_LANES_EPARAM_LINK_INFO;

typedef enum {
	KTI_LINK0 =  0x0,
	KTI_LINK1,
	KTI_LINK2,
	KTI_LINK3,
	KTI_LINK4,
	KTI_LINK5
} KTI_LOGIC_LINK;

#define IIO_BIFURCATE_xxxxxxxx          0xFE
#define IIO_BIFURCATE_x4x4x4x4          0x0
#define IIO_BIFURCATE_x4x4xxx8          0x1
#define IIO_BIFURCATE_xxx8x4x4          0x2
#define IIO_BIFURCATE_xxx8xxx8          0x3
#define IIO_BIFURCATE_xxxxxx16          0x4
#define IIO_BIFURCATE_x2x2x4x8          0x5
#define IIO_BIFURCATE_x4x2x2x8          0x6
#define IIO_BIFURCATE_x8x2x2x4          0x7
#define IIO_BIFURCATE_x8x4x2x2          0x8
#define IIO_BIFURCATE_x2x2x4x4x4        0x9
#define IIO_BIFURCATE_x4x2x2x4x4        0xA
#define IIO_BIFURCATE_x4x4x2x2x4        0xB
#define IIO_BIFURCATE_x4x4x4x2x2        0xC
#define IIO_BIFURCATE_x2x2x2x2x8        0xD
#define IIO_BIFURCATE_x8x2x2x2x2        0xE
#define IIO_BIFURCATE_x2x2x2x2x4x4      0xF
#define IIO_BIFURCATE_x2x2x4x2x2x4      0x10
#define IIO_BIFURCATE_x2x2x4x4x2x2      0x11
#define IIO_BIFURCATE_x4x2x2x2x2x4      0x12
#define IIO_BIFURCATE_x4x2x2x4x2x2      0x13
#define IIO_BIFURCATE_x4x4x2x2x2x2      0x14
#define IIO_BIFURCATE_x2x2x2x2x2x2x4    0x15
#define IIO_BIFURCATE_x2x2x2x2x4x2x2    0x16
#define IIO_BIFURCATE_x2x2x4x2x2x2x2    0x17
#define IIO_BIFURCATE_x4x2x2x2x2x2x2    0x18
#define IIO_BIFURCATE_x2x2x2x2x2x2x2x2  0x19
#define IIO_BIFURCATE_AUTO              0xFF

typedef struct {
	UINT8 Socket;
	UINT8 IouNumber;
	UINT8 Bifurcation;
} UPD_IIO_BIFURCATION_DATA_ENTRY;

typedef enum {
        Iio_Socket0 = 0,
        Iio_Socket1,
        Iio_Socket2,
        Iio_Socket3,
        Iio_Socket4,
        Iio_Socket5,
        Iio_Socket6,
        Iio_Socket7
} IIO_SOCKETS;

typedef enum {
        Iio_Iou0 = 0,
        Iio_Iou1,
        Iio_Iou2,
        Iio_Iou3,
        Iio_Mcp0,
        Iio_Mcp1,
        Iio_IouMax
} IIO_IOUS;

/** FSP-M Configuration
**/
typedef struct {

/** Offset 0x0040 - Customer Revision
  The Customer can set this revision string for their own purpose.
**/
  UINT8                       CustomerRevision[32];

/** Offset 0x0060 - Bus Ratio
  Indicates the ratio of Bus/MMIOL/IO resource to be allocated for each CPU's IIO.
  Default 0x1
**/
  UINT8                       BusRatio[8];

/** Offset 0x0068 - D2K Credit Config
  Set the D2K Credit Config. 1: Min,<b>2: Med (Default), 3: Max.
  1:Min, 2:Med, 3:Max
**/
  UINT8                       D2KCreditConfig;

/** Offset 0x0069 - Snoop Throttle Config
  Set the Snoop Throttle Config. <b>0: Disable(Default)</b>, 1: Min, 2: Med, 3: Max
  0:Disable, 1:Min, 2:Med, 3:Max
**/
  UINT8                       SnoopThrottleConfig;

/** Offset 0x006A - Snoop Throttle Config
  Set the Snoop All Core Config. <b>0: Disable(Default)</b>, 1: Enable, 2: Auto
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       SnoopAllCores;

/** Offset 0x006B - Legacy VGA Socket
  Socket that claims the legacy VGA range. Default: Socket 0
**/
  UINT8                       LegacyVgaSoc;

/** Offset 0x006C - Legacy VGA Stack
  Stack that claims the legacy VGA range. Default: Stack 0
**/
  UINT8                       LegacyVgaStack;

/** Offset 0x006D - Pcie P2P Performance Mode
  Enable: Enable PCIe P2P Performance Mode, <b>Disable(Default)</b>: Disable PCIe
  P2P Performance Mode
  $EN_DIS
**/
  UINT8                       P2pRelaxedOrdering;

/** Offset 0x006E - Debug Print Level
  Debug Print Level Bitmask. 0: Disable, 1: Fatal, 2: Warning, 4: Summary, 8: Detail,
  <b>0xF: All(Default)</b>
  1:Fatal, 2:Warning, 4:Summary, 8:Detail, 0x0F:All
**/
  UINT8                       DebugPrintLevel;

/** Offset 0x006F - SNC
  <b>Enable(Default)</b> or Disable SNC
  $EN_DIS
**/
  UINT8                       SncEn;

/** Offset 0x0070 - UMA Clustering
  Set number of enabled UMA Clusters. <b>0: Disable(Default)</b>, 2: Two Clusters,
  4: Four Clusters
  0:Disable, 2:Two Clusters, 4:Four Clusters
**/
  UINT8                       UmaClustering;

/** Offset 0x0071 - IODC Mode
  IODC Mode. 0: Disable, <b>1: Auto(Default)</b>, 2: Push, 3: AllocFlow 4: NonAlloc, 5: WCILF
  0:Disable, 1:Auto, 2:Push, 3:AllocFlow 4:NonAlloc, 5:WCILF
**/
  UINT8                       IoDcMode;

/** Offset 0x0072 - Degrade Precedence
  Degrade Precedence. <b>0: Topology(Default)</b>, 1: Feature
  0:Topology, 1:Feature
**/
  UINT8                       DegradePrecedence;

/** Offset 0x0073 - Degrade 4 Socket Preference
  Degrade 4 Socket Preference. <b>0: Fully Connect(Default)</b>, 1: Dual Link Ring
  0:Fully Connect, 1:Dual Link Ring
**/
  UINT8                       Degrade4SPreference;

/** Offset 0x0074 - Directory Mode
  <b>Enable(Default)</b> or Disable Directory Mode
  $EN_DIS
**/
  UINT8                       DirectoryModeEn;

/** Offset 0x0075 - XPT Prefetch Enable
  XPT Prefetch. 0: Disable, 1: Enable, <b>2: Auto(Default)</b>
**/
  UINT8                       XptPrefetchEn;

/** Offset 0x0076 - KTI Prefetch Enable
  <b>Enable(Default)</b> or Disable KTI Prefetch
  $EN_DIS
**/
  UINT8                       KtiPrefetchEn;

/** Offset 0x0077 - XPT Remote Prefetch Enable
  Enable or <b>Disable(Default)</b> XPT Remote Prefetch
  $EN_DIS
**/
  UINT8                       XptRemotePrefetchEn;

/** Offset 0x0078 - KTI FPGA
  Enable or Disable KTI FPGA, Default: 0x1 (Enable)
**/
  UINT8                       KtiFpgaEnable[8];

/** Offset 0x0080 - DDRT QoS Mode
  DDRT QoS. <b>0: Mode 0(Default)</b>, 1: Mode 1, 2: Mode 2
**/
  UINT8                       DdrtQosMode;

/** Offset 0x0081 - KTI Link Speed Mode
  KTI Link Speed Mode. 0: Slow, <b>1: Full(Default)</b>
**/
  UINT8                       KtiLinkSpeedMode;

/** Offset 0x0082 - KTI Link Speed
  KTI Link Speed. 0: 128GT, 1: 144GT, 2: 160GT, <b>3: Max KTI Link Speed(Default)</b>,
  4: Frequency Per Link
**/
  UINT8                       KtiLinkSpeed;

/** Offset 0x0083 - KTI Link L0p
  KTI Link L0p. 0: Disable, 1: Enable, <b>2: Auto(Default)</b>
**/
  UINT8                       KtiLinkL0pEn;

/** Offset 0x0084 - KTI Link L1
  KTI Link L1. 0: Disable, 1: Enable, <b>2: Auto(Default)</b>
**/
  UINT8                       KtiLinkL1En;

/** Offset 0x0085 - KTI Failover
  KTI Failover. 0: Disable, 1: Enable, <b>2: Auto(Default)</b>
**/
  UINT8                       KtiFailoverEn;

/** Offset 0x0086 - KTI LB Enable
  Enable or <b>Disable(Default)</b> KTI LB
  $EN_DIS
**/
  UINT8                       KtiLbEn;

/** Offset 0x0087 - KTI CRC Mode
  KTI CRC Mode.  0: 16bit, 1: 32bit, <b>2: Auto(Default)</b>
  0:16bit, 1:32bit, 2:Auto
**/
  UINT8                       KtiCrcMode;

/** Offset 0x0088 - KTI CPU Socket Hotplug
  Enable or <b>Disable(Default)</b> KTI CPU Socket Hotplug
  $EN_DIS
**/
  UINT8                       KtiCpuSktHotPlugEn;

/** Offset 0x0089 - KTI CPU Socket HotPlug Topology
  KTI CPU Socket HotPlug Topology. <b>0: 4 Socket(Default)</b>, 1: 8 Socket
  0:4Socket, 1:8Socket
**/
  UINT8                       KtiCpuSktHotPlugTopology;

/** Offset 0x008A - KTI SKU Mismatch Check
  <b>Enable(Default)</b> or Disable KTI SKU Mismatch Check
  $EN_DIS
**/
  UINT8                       KtiSkuMismatchCheck;

/** Offset 0x008B - IRQ Threshold
  IRQ Threshold. 0: Disable, <b>1: Auto(Default)</b>, 2: Low, 3: Medium, 4: High
  0:Disable, 1:Auto, 2:Low, 3:Medium, 4:High
**/
  UINT8                       IrqThreshold;

/** Offset 0x008C - TOR threshold - Loctorem threshold normal
  TOR threshold - Loctorem threshold normal. 0: Disable, <b>1: Auto(Default)</b>,
  2: Low, 3: Medium, 4: High
  0:Disable, 1:Auto, 2:Low, 3:Medium, 4:High
**/
  UINT8                       TorThresLoctoremNorm;

/** Offset 0x008D - TOR threshold - Loctorem threshold empty
  TOR threshold - Loctorem threshold empty.  0: Disable, <b>1: Auto(Default)</b>,
  2: Low, 3: Medium, 4: High
  0:Disable, 1:Auto, 2:Low, 3:Medium, 4:High
**/
  UINT8                       TorThresLoctoremEmpty;

/** Offset 0x008E - MBA BW Calibration
  MBA BW Calibration setting. 0: Linear, 1: Biased, 2: Legacy, <b>3: Auto(Default)</b>
  0:Linear, 1:Biased, 2:Legacy, 3:Auto
**/
  UINT8                       MbeBwCal;

/** Offset 0x008F - TSC Sync in Sockets
  TSC Sync in Sockets. 0: Disable, 1: Enable, <b>2: Auto(Default)</b>
**/
  UINT8                       TscSyncEn;

/** Offset 0x0090 - HA A to S directory optimization
  HA A to S directory optimization. 0: Disable, 1: Enable, <b>2: Auto(Default)</b>
**/
  UINT8                       StaleAtoSOptEn;

/** Offset 0x0091 - LLC Deadline Allocation
  <b>Enable(Default)</b> or Disable LLC Deadline Allocation
  $EN_DIS
**/
  UINT8                       LLCDeadLineAlloc;

/** Offset 0x0092 - Split Lock
  Split Lock. <b>0: Disable(Default)</b>, 1: Enable, 2: Auto
**/
  UINT8                       SplitLock;

/** Offset 0x0093 - MMCFG Base Address
  MMCFG Base Address. 0: 1GB, 1: 1.5GB, 2: 1.75GB, 3: 2GB, 4: 2.25GB, 5: 3GB, <b>6:
  Auto(Default)</b>
  0:1GB, 1:1.5GB, 2:1.75GB, 3:2GB, 4:2.25GB, 5:3GB, 6:Auto
**/
  UINT8                       mmCfgBase;

/** Offset 0x0094 - MMCFG Size
  Select MMCFG Size. 0: 64MB, 1: 128MB, 2: 256MB, 3: 512MB, 4: 1GB, 5: 2GB, <b>6:
  Auto(Default)</b>
  0:64MB, 1:128MB, 2:256MB, 3:512MB, 4:1GB, 5:2GB, 6: Auto
**/
  UINT8                       mmCfgSize;

/** Offset 0x0095
**/
  UINT8                       UnusedUpdSpace0[3];

/*
 * UnusedUpdSpace0[0] is reserved for following UPD variable:
 * Offset 0x0095 - Usage type for Memory Refresh Watermark
 * Select Memory Refresh Watermark, 0: Auto, 1: High(default), 2: Low
  UINT8                       MemRefreshWaterMark;
 */

/** Offset 0x0098 - MMIO High Base Address
  MMIO High Base Address, a hex number for Bit[51:32]. Default: 0x6 (Gives 0x200)
**/
  UINT32                      mmiohBase;

/** Offset 0x009C - CPU Physical Address Limit
  <b>Enable(Default)</b> or Disable CPU Physical Address Limit
  0:Disable, 1:Enable
**/
  UINT8                       CpuPaLimit;

/** Offset 0x009D - High Gap
  Enable or <b>Disable(Default)</b> High Gap
  $EN_DIS
**/
  UINT8                       highGap;

/** Offset 0x009E - MMIO High Size
  MMIO High Size, Number of 1GB contiguous regions to be assigned for MMIOH space
  per CPU.  Range 1-1024, Default: 3
**/
  UINT16                      mmiohSize;

/** Offset 0x00A0 - ISOC
  <b>Enable(Default)</b> or Disable ISOC
  $EN_DIS
**/
  UINT8                       isocEn;

/** Offset 0x00A1 - DCA
  Enable or <b>Disable(Default)</b> DCA
  $EN_DIS
**/
  UINT8                       dcaEn;

/** Offset 0x00A2
**/
  UINT8                       UnusedUpdSpace1[2];

/** Offset 0x00A4 - BoardTypeBitmask
  Board Type Bitmask. Default: 0x1
**/
  UINT32                      BoardTypeBitmask;

/** Offset 0x00A8 - AllLanesPtr
  Pointer to array of ALL_LANES_EPARAM_LINK_INFO
**/
  UINT32                      AllLanesPtr;

/** Offset 0x00AC - PerLanePtr
  Pointer to array of PER_LANE_EPARAM_LINK_INFO
**/
  UINT32                      PerLanePtr;

/** Offset 0x00B0 - AllLanesSizeOfTable
  Number of elements in AllLanesPtr array.
**/
  UINT32                      AllLanesSizeOfTable;

/** Offset 0x00B4 - PerLaneSizeOfTable
  Number of elements in PerLanePtr array.
**/
  UINT32                      PerLaneSizeOfTable;

/** Offset 0x00B8 - WaitTimeForPSBP
  Number of milliseconds to wait for remote CPUs to initialize. Default: 30 sec
**/
  UINT32                      WaitTimeForPSBP;

/** Offset 0x00BC - IsKtiNvramDataReady
  IsKtiNvramDataReady. Default: Disable
  $EN_DIS
**/
  UINT8                       IsKtiNvramDataReady;

/** Offset 0x00BD - BoardId
  Board ID
**/
  UINT8                       BoardId;

/** Offset 0x00BE - WaSerializationEn
  <b>Enable(Default)</b> or Disable BIOS serialization WA
  $EN_DIS
**/
  UINT8                       WaSerializationEn;

/** Offset 0x00BF - KtiInEnableMktme
  Enable(Default) or Disable MkTme status decides D2Kti feature state
  $EN_DIS
**/
  UINT8                       KtiInEnableMktme;

/** Offset 0x00C0 - Processor VmxEnable Function
  Enable(Default) or Disable Processor VmxEnable Function
  $EN_DIS
**/
  UINT8                       VmxEnable;

/** Offset 0x00C1 - Processor X2apic Function
  Enable(Default) or Disable Processor X2apic Function
  $EN_DIS
**/
  UINT8                       X2apic;

/** Offset 0x00C2 - DDR frequency limit
  Enable(Default) or Disable Processor X2apic Function
**/
  UINT8                       DdrFreqLimit;

/** Offset 0x00C3 - Memory Serial Debug Message Level
  Enable(Default) or Disable Processor X2apic Function
**/
  UINT8                       serialDebugMsgLvl;

/** Offset 0x00C4 - IIO ConfigIOU0
  ConfigIOU[MAX_SOCKET][0]: MAX_SOCKET=8, 0x00:x4x4x4x4, 0x01:x4x4xxx8, 0x02:xxx8x4x4,
  0x03:xxx8xxx8, 0x04:xxxxxx16, <b>0xFF:AUTO(Default)</b>
**/
  UINT8                       IioConfigIOU0[8];

/** Offset 0x00CC - IIO ConfigIOU1
  ConfigIOU[MAX_SOCKET][1]: MAX_SOCKET=8, 0x00:x4x4x4x4, 0x01:x4x4xxx8, 0x02:xxx8x4x4,
  0x03:xxx8xxx8, 0x04:xxxxxx16, <b>0xFF:AUTO(Default)</b>
**/
  UINT8                       IioConfigIOU1[8];

/** Offset 0x00D4 - IIO ConfigIOU2
  ConfigIOU[MAX_SOCKET][2]: MAX_SOCKET=8, 0x00:x4x4x4x4, 0x01:x4x4xxx8, 0x02:xxx8x4x4,
  0x03:xxx8xxx8, 0x04:xxxxxx16, <b>0xFF:AUTO(Default)</b>
**/
  UINT8                       IioConfigIOU2[8];

/** Offset 0x00DC - IIO ConfigIOU3
  ConfigIOU[MAX_SOCKET][3]: MAX_SOCKET=8, 0x00:x4x4x4x4, 0x01:x4x4xxx8, 0x02:xxx8x4x4,
  0x03:xxx8xxx8, 0x04:xxxxxx16, <b>0xFF:AUTO(Default)</b>
**/
  UINT8                       IioConfigIOU3[8];

/** Offset 0x00E4 - IIO ConfigIOU4
  ConfigIOU[MAX_SOCKET][4]: MAX_SOCKET=8, 0x00:x4x4x4x4, 0x01:x4x4xxx8, 0x02:xxx8x4x4,
  0x03:xxx8xxx8, 0x04:xxxxxx16, <b>0xFF:AUTO(Default)</b>
**/
  UINT8                       IioConfigIOU4[8];

/** Offset 0x00EC - IIO PCIE Config Table Ptr
  Pointer to array of UPD_IIO_PCIE_PORT_CONFIG
**/
  UINT32                      IioPcieConfigTablePtr;

/** Offset 0x00F0 - IIO PCIE Config Table Number
  Number of elements in IioPcieConfigTablePtr array.
**/
  UINT32                      IioPcieConfigTableNumber;

/** Offset 0x00F4 - IIO PCIE Root Port Enable
  <b>Enable(Default)</b> or Disable IIO PCH rootport
**/
  UINT8                       IIOPcieRootPortEnable;

/** Offset 0x00F5 - IIO DeEmphasis
  IIO DeEmphasis. Default: 0x1
**/
  UINT8                       DeEmphasis;

/** Offset 0x00F6 - IIO PCIe Root Port Link Speed
  IIO PCIe Root Port Link Speed. <b>0: Auto(Default)</b>, 1: Gen1, 2: Gen2, 3: Gen3, 4: Gen4
  0:Auto, 1:Gen1, 2:Gen2, 3:Gen3, 4:Gen4
**/
  UINT8                       IIOPciePortLinkSpeed;

/** Offset 0x00F7 - IIO PCIe Root Port Max Payload
  IIO PCIe Root Port Max Payload. 0: 128B, 1: 256B, 2: 512B, <b>7: Auto(Default)</b>
  0:128B, 1: 256B, 2:512B, 7:Auto
**/
  UINT8                       IIOPcieMaxPayload;

/** Offset 0x00F8 - IIO DfxDnTxPreset
  IIO Downstream Transmitter Preset. Default: Auto(0xFF), otherwise preset 0-10
**/
  UINT8                       DfxDnTxPreset;

/** Offset 0x00F9 - IIO DfxRxPreset
  IIO Downstream Reciever Preset. Default: Auto(0xFF), otherwise preset 0-10
**/
  UINT8                       DfxRxPreset;

/** Offset 0x00FA - IIO DfxUpTxPreset
  IIO Upstream Transmitter Preset. Default: Auto(0xFF), otherwise preset 0-10
**/
  UINT8                       DfxUpTxPreset;

/** Offset 0x00FB - IIO PCIe Common Clock
  IIO PCIe Common Clock. 0: Disable, <b>1: Enable(Default)</b>, 2: Auto
**/
  UINT8                       PcieCommonClock;

/** Offset 0x00FC - IIO Non-Transparent Port Definition
  IIO Non-Transparent Port Definition. <b>0: Transparent(Default)</b>, 1: Non-Transparent
  Bridge, 2: Non-Transparent Root Port
**/
  UINT8                       NtbPpd;

/** Offset 0x00FD - IIO Non-Transparent Bridge BAR Size Override
  Enable or <b>Disable(Default)</b> IIO Non-Transparent Bridge BAR Size Override.
**/
  UINT8                       NtbBarSizeOverride;

/** Offset 0x00FE - IIO Non-Transparent Bridge Split BAR Mode
  Enable or <b>Disable(Default)</b> IIO Non-Transparent Bridge Split BAR Mode
**/
  UINT8                       NtbSplitBar;

/** Offset 0x00FF - IIO NtbBarSizeImBar1
  IIO NtbBarSizeImBar1. Default: 0x16
**/
  UINT8                       NtbBarSizeImBar1;

/** Offset 0x0100 - IIO NtbBarSizeImBar2
  IIO PNtbBarSizeImBar2. Default: 0x16
**/
  UINT8                       NtbBarSizeImBar2;

/** Offset 0x0101 - IIO NtbBarSizeImBar2_0
  IIO PNtbBarSizeImBar2_0. Default: 0x0C
**/
  UINT8                       NtbBarSizeImBar2_0;

/** Offset 0x0102 - IIO NtbBarSizeImBar2_1
  IIO NtbBarSizeImBar2_1. Default: 0x0C
**/
  UINT8                       NtbBarSizeImBar2_1;

/** Offset 0x0103 - IIO NtbBarSizeEmBarSZ1
  IIO NtbBarSizeEmBarSZ1. . Default: 0x16
**/
  UINT8                       NtbBarSizeEmBarSZ1;

/** Offset 0x0104 - IIO NtbBarSizeEmBarSZ2
  IIO NtbBarSizeEmBarSZ2. . Default: 0x16
**/
  UINT8                       NtbBarSizeEmBarSZ2;

/** Offset 0x0105 - IIO NtbBarSizeEmBarSZ2_0
  IIO NtbBarSizeEmBarSZ2_0. . Default: 0x0C
**/
  UINT8                       NtbBarSizeEmBarSZ2_0;

/** Offset 0x0106 - IIO NtbBarSizeEmBarSZ2_1
  IIO NtbBarSizeEmBarSZ2_1. . Default: 0x0C
**/
  UINT8                       NtbBarSizeEmBarSZ2_1;

/** Offset 0x0107 - IIO Non-Transparent Cross Link Override
  IIO Non-Transparent Cross Link Override. 1:Operate as RP, 2:Operate as NTB-NTB (NT
  Port), <b>3:Operate as NTB-> DSP (NTB EP)(Default)</b>
**/
  UINT8                       NtbXlinkCtlOverride;

/** Offset 0x0108 - VT-d Support
  Enable or <b>Disable(Default)</b> VT-d Support
**/
  UINT8                       VtdSupport;

/** Offset 0x0109 - IIO PCIe Port Hide
  Hide or visible for IIO Pcie Port, 1 : Hide, 0 : Visible
**/
  UINT8                       PEXPHIDE;

/** Offset 0x010A - IIO Pcie Port Menu Hide
  Hide or visible for IIO PCIe Port Menu, 1 : Hide, 0 : Visible
**/
  UINT8                       HidePEXPMenu;

/** Offset 0x010B - PchSirqMode
  PchSirqMode. <b>0: Quiet Mode(Default)</b> 1: Continuous Mode
**/
  UINT8                       PchSirqMode;

/** Offset 0x010C - PchAdrEn
  PchAdr 0:PLATFORM POR, <b>1:FORCE ENABLE(Default)</b>, 2:FORCE DISABLE
**/
  UINT8                       PchAdrEn;

/** Offset 0x010D - ThermalDeviceEnable
  Thermal Device Mode. 0: Disable, 1: Enabled in PCI  mode, <b>2: Enabled in ACPI
  mode(Default)</b>
**/
  UINT8                       ThermalDeviceEnable;

/** Offset 0x010E - PchPcieRootPortFunctionSwap
  Root port swapping based on device connection status : <b>TRUE(Default)</b> or FALSE
  TRUE : 0x01, FALSE : 0x00
**/
  UINT8                       PchPcieRootPortFunctionSwap;

/** Offset 0x010F - PCH PCIE PLL Ssc
  Valid spread range : 0x00-0x14 (A value of 0 is SSC of 0.0%. A value of 20 is SSC
  of 2.0%), Auto : 0xFE(Set to hardware default), <b>Disable(Default)</b> : 0xFF
**/
  UINT8                       PchPciePllSsc;

/** Offset 0x0110 - PCH PCIE Root Port Index
  Index assigned to every PCH PCIE Root Port
**/
  UINT8                       PchPciePortIndex[20];

/** Offset 0x0124 - PCH PCIE Root Port Enable or Disable
  0-19: PCH rootport, if port is enabled(Default), the value is 0x01, if the port
  is disabled, the value is 0x00
**/
  UINT8                       PchPcieForceEnable[20];

/** Offset 0x0138 - PCH PCIE Root Port Link Speed
  0-19: PCH rootport, 0x00 : Pcie Auto Speed(Default), 0x01 : Pcie Gen1 Speed, 0x02
  : Pcie Gen2 Speed, 0x03 : Pcie Gen3 Speed
**/
  UINT8                       PchPciePortLinkSpeed[20];

/** Offset 0x014C - PchDciEn
  Enable or <b>Disable(Default)</b> PCH DCI
**/
  UINT8                       PchDciEn;

/** Offset 0x014D - MeUmaEnable
  Enable or disable ME UMA feature
**/
  UINT8                       MeUmaEnable;

/** Offset 0x014E - SerialIoUartDebugEnable
  <b>Enable(Default)</b> or Disable SerialIo Uart debug library in FSP.
  0:Disable, 1:Enable
**/
  UINT8                       SerialIoUartDebugEnable;

/** Offset 0x014F
**/
  UINT8                       UnusedUpdSpace2;

/** Offset 0x0150 - ISA Serial Base selection
  Select ISA Serial Base address could be initialized by boot loader. Default is 0x3F8
  0x3F8, 0x2F8
**/
  UINT16                      SerialIoUartDebugIoBase;

/** Offset 0x0152
**/
  UINT8                       UnusedUpdSpace3[2];

/** Offset 0x0154
**/
  UINT8                       ReservedMemoryInitUpd[16];
} FSPM_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSPM_CONFIG                 FspmConfig;

/** Offset 0x0164
**/
  UINT8                       UnusedUpdSpace4[2];

/** Offset 0x0166
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
