# Contributing to Nexus

First off, thank you for considering contributing to Nexus! It's people like you that make this project such a great tool for Discord communities.

## Code of Conduct

This project and everyone participating in it is governed by our [Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code.

## I don't want to read this whole thing, I just have a question!!!

Please don't file an issue to ask a question. You'll get faster results by using the community chat resources:

- Join our [Discord Server](https://discord.gg/nexushosting)
- Check out the [discord.js guide](https://discordjs.guide/)

## What should I know before I get started?

### Project Structure

Our project uses discord.js v14, which means you should be familiar with modern JavaScript and Node.js. The main entry point of the bot is located in `index.js`, with commands and event handlers organized into separate directories.

### Development Environment

Ensure you have Node.js v16 or newer installed, as discord.js v14 requires it. Additionally, you'll need a Discord account and a test server to try out your changes.

## How Can I Contribute?

### Reporting Bugs

If you encounter a bug, please file an issue with a clear title and description, as much relevant information as possible, and a code sample or an executable test case demonstrating the expected behavior that is not occurring.

### Suggesting Enhancements

Enhancement suggestions are also welcome. Please include as many details as possible, with a focus on why the enhancement would be beneficial to Nexus.

### Your First Code Contribution

Unsure where to begin contributing to Nexus? Look for 'good first issue' labels on our issue tracker.

### Pull Requests

1. Fork the repository and create your branch from `main`.
2. Ensure you have tested your code.
3. Update the README.md with details of changes, if applicable.
4. Issue the pull request.

## Styleguides

### Git Commit Messages

- Use the present tense ("Add feature" not "Added feature").
- Use the imperative mood ("Move cursor to..." not "Moves cursor to...").
- Limit the first line to 72 characters or less.
- Reference issues and pull requests liberally after the first line.

### JavaScript Styleguide

All JavaScript must adhere to [Airbnb's JavaScript Style Guide](https://github.com/airbnb/javascript).

### Documentation Styleguide

- Use Markdown for documentation.
- Document new code based on any changes.

## Questions or Need Help?

Feel free to contact us at [contact@toowake.dev] if you have any questions or need help.

Thank you for your contributions to Nexus!
