/* tslint:disable */
/* eslint-disable */

import React, { FunctionComponent } from 'react';
import { ViewProps } from 'react-native';
import { Svg, GProps, Path } from 'react-native-svg';
import { getIconColor } from './helper';

interface Props extends GProps, ViewProps {
  size?: number;
  color?: string | string[];
}

let KqAlbum: FunctionComponent<Props> = ({ size, color, ...rest }) => {
  return (
    <Svg viewBox="0 0 1236 1024" width={size} height={size} {...rest}>
      <Path
        d="M854.88796479 400.23194027a50.11824427 50.11824427 0 0 0-86.71251733 0l-184.9601856 318.21107306a47.33389653 47.33389653 0 0 1-82.33711467 0l-89.49686507-154.33237013a50.11824427 50.11824427 0 0 0-86.71251733 0l-131.2620672 234.6806656a24.26359467 24.26359467 0 0 0 21.08148373 35.7987456h832.5197184a29.832288 29.832288 0 0 0 26.25241387-44.54954987z m0 0"
        fill={getIconColor(color, 0, '#333333')}
      />
      <Path
        d="M1047.40566399-34.12617387H214.88594559A178.993728 178.993728 0 0 0 34.30116159 144.8675552v630.0579232a178.993728 178.993728 0 0 0 169.84515947 178.19820053h842.86157866a177.40267307 177.40267307 0 0 0 95.46332267-27.8434688 198.88192 198.88192 0 0 0 21.08148373-15.51278933 178.19820053 178.19820053 0 0 0 64.0399776-134.8419424V144.8675552A178.993728 178.993728 0 0 0 1048.99671892-34.12617387z m107.3962368 809.05165227a106.60070933 106.60070933 0 0 1-27.8434688 71.99525547 110.57834773 110.57834773 0 0 1-28.241232 22.27477546 105.0096544 105.0096544 0 0 1-50.91377173 13.12620587H214.88594559a106.20294507 106.20294507 0 0 1-39.776384-8.35304 107.79400107 107.79400107 0 0 1-66.02879787-99.0431968V144.8675552a107.3962368 107.3962368 0 0 1 107.3962368-107.39623787h830.92866347a107.3962368 107.3962368 0 0 1 107.3962368 107.39623787v630.0579232z m0 0"
        fill={getIconColor(color, 1, '#333333')}
      />
      <Path
        d="M190.62235092 223.62479573a107.3962368 107.3962368 0 1 0 107.3962368-107.39623786 107.3962368 107.3962368 0 0 0-107.3962368 107.39623786z m0 0"
        fill={getIconColor(color, 2, '#333333')}
      />
    </Svg>
  );
};

KqAlbum.defaultProps = {
  size: 18,
};

KqAlbum = React.memo ? React.memo(KqAlbum) : KqAlbum;

export default KqAlbum;
