/* tslint:disable */
/* eslint-disable */

import React, { FunctionComponent } from 'react';
import { ViewProps } from 'react-native';
import { Svg, GProps, Path } from 'react-native-svg';
import { getIconColor } from './helper';

interface Props extends GProps, ViewProps {
  size?: number;
  color?: string | string[];
}

let KqLoading2: FunctionComponent<Props> = ({ size, color, ...rest }) => {
  return (
    <Svg viewBox="0 0 1024 1024" width={size} height={size} {...rest}>
      <Path
        d="M870.6304 753.0752c0 3.4048 2.7904 6.1952 6.2464 6.1952a6.1696 6.1696 0 1 0 0-12.416 6.272 6.272 0 0 0-6.2464 6.2208z m-137.9328 141.2608c0 6.8096 5.5552 12.3392 12.416 12.3392a12.3904 12.3904 0 0 0 12.4416-12.3392 12.3904 12.3904 0 0 0-12.4416-12.3392 12.3904 12.3904 0 0 0-12.416 12.3392z m-185.9328 72.704c0 10.24 8.3712 18.56 18.688 18.56 10.3168 0 18.688-8.2944 18.688-18.5344 0-10.24-8.3712-18.5344-18.688-18.5344a18.6112 18.6112 0 0 0-18.688 18.5344z m-200.1152-9.728c0 13.6192 11.1104 24.6784 24.832 24.6784 13.7472 0 24.8576-11.0592 24.8576-24.6784a24.7552 24.7552 0 0 0-24.832-24.6784 24.7552 24.7552 0 0 0-24.8576 24.6784z m-177.5616-90.4448a30.976 30.976 0 0 0 31.104 30.8736 30.976 30.976 0 0 0 31.104-30.8736 30.976 30.976 0 0 0-31.104-30.8736 30.976 30.976 0 0 0-31.104 30.8736z m-122.9568-153.7536c0 20.48 16.7168 37.0944 37.376 37.0944 20.608 0 37.3248-16.6144 37.3248-37.0944s-16.7168-37.0688-37.3504-37.0688-37.3504 16.6144-37.3504 37.0688zM0 524.3392c0 23.8592 19.4816 43.2128 43.52 43.2128 24.064 0 43.52-19.3536 43.52-43.2128 0-23.8592-19.456-43.2128-43.52-43.2128-24.0384 0-43.52 19.3536-43.52 43.2128z m37.9648-187.5456c0 27.2896 22.272 49.408 49.7664 49.408a49.5872 49.5872 0 0 0 49.792-49.408c0-27.2896-22.272-49.408-49.792-49.408a49.5872 49.5872 0 0 0-49.7664 49.408z m113.92-151.2448c0 30.72 25.0624 55.6288 56.0128 55.6288a55.808 55.808 0 0 0 56.0128-55.6288c0-30.72-25.088-55.6032-56.0128-55.6032a55.808 55.808 0 0 0-56.0384 55.6032z m167.2192-86.6048a61.952 61.952 0 0 0 62.208 61.7472 61.952 61.952 0 0 0 62.208-61.7472 61.952 61.952 0 0 0-62.208-61.7472 61.952 61.952 0 0 0-62.208 61.7472z m187.8528-5.376a68.1984 68.1984 0 0 0 68.4544 67.9168 68.1984 68.1984 0 0 0 68.4544-67.9424A68.1984 68.1984 0 0 0 575.4112 25.6a68.1984 68.1984 0 0 0-68.4544 67.9424z m171.9808 76.8c0 40.9088 33.408 74.0608 74.624 74.0608s74.624-33.152 74.624-74.0608c0-40.9344-33.408-74.0864-74.624-74.0864s-74.624 33.152-74.624 74.0864z m122.2144 144.256c0 44.3392 36.1984 80.3072 80.8704 80.3072 44.672 0 80.896-35.968 80.896-80.3072s-36.224-80.2816-80.896-80.2816-80.896 35.9424-80.896 80.2816z m48.5888 186.88c0 47.7696 39.0144 86.5024 87.1424 86.5024S1024 549.2736 1024 501.504s-39.0144-86.4768-87.1168-86.4768c-48.128 0-87.1424 38.7072-87.1424 86.4768z"
        fill={getIconColor(color, 0, '#333333')}
      />
    </Svg>
  );
};

KqLoading2.defaultProps = {
  size: 18,
};

KqLoading2 = React.memo ? React.memo(KqLoading2) : KqLoading2;

export default KqLoading2;
