/* tslint:disable */
/* eslint-disable */

import React, { FunctionComponent } from 'react';
import { ViewProps } from 'react-native';
import { Svg, GProps, Path } from 'react-native-svg';
import { getIconColor } from './helper';

interface Props extends GProps, ViewProps {
  size?: number;
  color?: string | string[];
}

let KqShanchu: FunctionComponent<Props> = ({ size, color, ...rest }) => {
  return (
    <Svg viewBox="0 0 1024 1024" width={size} height={size} {...rest}>
      <Path
        d="M621.11046201 803.32004011c-20.1585243 0-36.40277333-16.24424789-36.40277334-36.40277334L584.70768867 366.29105209c0-20.1585243 16.24424789-36.40277333 36.40277334-36.40277334s36.40277333 16.24424789 36.40277333 36.40277334l0 400.43050098C657.51323421 786.88007737 641.26898631 803.32004011 621.11046201 803.32004011z"
        fill={getIconColor(color, 0, '#333333')}
      />
      <Path
        d="M402.69382429 803.32004011c-20.1585243 0-36.40277333-16.24424789-36.40277334-36.40277334L366.29105209 366.29105209c0-20.1585243 16.24424789-36.40277333 36.40277333-36.40277334 20.1585243 0 36.40277333 16.24424789 36.40277333 36.40277334l0 400.43050098C439.09659762 786.88007737 422.85234973 803.32004011 402.69382429 803.32004011z"
        fill={getIconColor(color, 1, '#333333')}
      />
      <Path
        d="M985.33390336 184.2771877l-182.01386439 0L803.32004011 111.47164217c0-60.27986034-48.53702997-109.20831886-108.4254629-109.20831886L329.88827875 2.26332331c-60.27986034 0-109.20831886 48.92845853-109.20831886 109.20831886l0 72.80554553-182.01386439 0c-20.1585243 0-36.40277333 16.24424789-36.40277333 36.40277333s16.24424789 36.40277333 36.40277333 36.40277334l946.66780786 0c20.1585243 0 36.40277333-16.24424789 36.40277333-36.40277334S1005.4924288 184.2771877 985.33390336 184.2771877zM293.48550656 111.47164217c0-19.96281059 16.4399616-36.40277333 36.40277333-36.40277334l365.00629732 0c19.96281059 0 35.61991737 16.04853419 35.61991737 36.40277334l0 72.80554553L293.48550656 184.2771877 293.48550656 111.47164217 293.48550656 111.47164217z"
        fill={getIconColor(color, 2, '#333333')}
      />
      <Path
        d="M766.91726677 1021.73667669L257.27844693 1021.73667669c-60.27986034 0-109.20831886-48.92845853-109.20831886-109.20831886L148.07012807 365.89962354c0-20.1585243 16.24424789-36.40277333 36.40277334-36.40277333s36.40277333 16.24424789 36.40277333 36.40277333l0 546.62873429c0 20.1585243 16.4399616 36.40277333 36.40277333 36.40277334l509.83453355 0c20.1585243 0 36.40277333-16.24424789 36.40277333-36.40277334L803.51575381 367.26962062c0-20.1585243 16.24424789-36.40277333 36.40277334-36.40277333s36.40277333 16.24424789 36.40277333 36.40277333l0 545.25873721C876.12558563 972.61250446 827.19712711 1021.73667669 766.91726677 1021.73667669z"
        fill={getIconColor(color, 3, '#333333')}
      />
    </Svg>
  );
};

KqShanchu.defaultProps = {
  size: 18,
};

KqShanchu = React.memo ? React.memo(KqShanchu) : KqShanchu;

export default KqShanchu;
