/* tslint:disable */
/* eslint-disable */

import React, { FunctionComponent } from 'react';
import { ViewProps } from 'react-native';
import { Svg, GProps, Path } from 'react-native-svg';
import { getIconColor } from './helper';

interface Props extends GProps, ViewProps {
  size?: number;
  color?: string | string[];
}

let KqVoice: FunctionComponent<Props> = ({ size, color, ...rest }) => {
  return (
    <Svg viewBox="0 0 1024 1024" width={size} height={size} {...rest}>
      <Path
        d="M846.87855746 341.8606843a36.98680776 36.98680776 0 0 0-36.98680776 36.98680776v105.63432297c0 149.42670335-133.67032325 270.96535365-297.8917497 270.96535365S214.1082503 633.83454476 214.1082503 484.48181503V374.7049696a36.98680776 36.98680776 0 0 0-73.97361552 0v109.77684543c0 182.49290949 154.01306751 330.8100086 347.52804571 342.64578708v114.88102491H333.57563937c-18.64135111 0-33.73196868 16.57008987-33.73196869 37.06078138 0 20.41671789 15.09061757 36.91283414 33.73196869 36.91283414h368.75847336c18.56737749 0 33.73196868-16.49611627 33.73196868-36.91283414 0-20.4906915-15.16459119-37.06078138-33.73196868-37.06078138H561.63629602v-117.17420699c181.45727887-22.85784719 322.22906921-165.848846 322.2290692-340.352605V378.84749206c0-20.4906915-16.49611627-36.98680776-36.98680776-36.98680776z"
        fill={getIconColor(color, 0, '#333333')}
      />
      <Path
        d="M517.91788924 704.62729481a230.13191789 230.13191789 0 0 0 229.90999703-229.83602341V230.82628741A230.2058915 230.2058915 0 0 0 517.91788924 0.99026398a230.05794427 230.05794427 0 0 0-229.7620498 229.83602343v243.96498399a230.05794427 230.05794427 0 0 0 229.7620498 229.83602341z m98.31093503-146.54173235a57.62544649 57.62544649 0 1 1 0-115.17691936 57.62544649 57.62544649 0 0 1 0 115.17691936zM362.12945495 230.82628741c0-85.95734124 69.90506667-155.8624079 155.78843429-155.8624079a156.08432875 156.08432875 0 0 1 155.93638152 155.8624079v32.91825891H362.12945495v-32.91825891z"
        fill={getIconColor(color, 1, '#333333')}
      />
    </Svg>
  );
};

KqVoice.defaultProps = {
  size: 18,
};

KqVoice = React.memo ? React.memo(KqVoice) : KqVoice;

export default KqVoice;
