/* tslint:disable */
/* eslint-disable */

import React, { CSSProperties, SVGAttributes, FunctionComponent } from 'react';
import { getIconColor } from './helper';

interface Props extends Omit<SVGAttributes<SVGElement>, 'color'> {
  size?: number;
  color?: string | string[];
}

const DEFAULT_STYLE: CSSProperties = {
  display: 'block',
};

const KqJiankang: FunctionComponent<Props> = ({ size, color, style: _style, ...rest }) => {
  const style = _style ? { ...DEFAULT_STYLE, ..._style } : DEFAULT_STYLE;

  return (
    <svg viewBox="0 0 1024 1024" width={size + 'px'} height={size + 'px'} style={style} {...rest}>
      <path
        d="M731.78800001 21.34033333H330.08400001C168.975 21.34033333 37.89999999 152.41433332 37.89999999 313.52433333v99.579c0 15.77 12.782 28.554 28.55400001 28.55399999s28.554-12.785 28.554-28.55399999v-99.58c0-129.62000001 105.455-235.075 235.07599999-235.075h401.70400002c129.62000001 0 235.075 105.455 235.07499999 235.076v401.707c0 129.62000001-105.455 235.07-235.07499999 235.07H330.08400001c-129.62000001 0-235.07599999-105.45-235.07600001-235.07V595.85033333h116.12399999a28.552 28.552 0 0 0 26.01700001-16.786l26.01600001-57.51599999L370.51 782.96933332a28.55 28.55 0 0 0 27.4 17.69100001 28.561 28.561 0 0 0 26.116-19.54699999l138.99-419.02300001 58.463 206.88c3.474 12.29700001 14.70000001 20.791 27.47800001 20.79099999h224.62999999c15.771 0 28.55299999-12.782 28.55300001-28.55399999s-12.782-28.554-28.55400001-28.554H670.56400001l-77.88200001-275.606c-3.413-12.069-14.30000001-20.50000001-26.837-20.78-12.36400002-0.363-23.79600001 7.649-27.74500001 19.555l-144.02699999 434.19-103.22900001-251.397a28.542 28.542 0 0 0-25.90999999-17.701c-11.266-0.40399999-21.82400001 6.39699999-26.52 16.781l-45.703 101.047H28.576C12.80400001 538.74233333 0.01999999 551.52333333 0.01999999 567.29633333s12.783 28.554 28.55500001 28.554H37.89999999v119.381c0 161.10799999 131.07499999 292.178 292.18400002 292.17800001h401.704c161.113 0 292.183-131.07 292.18299999-292.17800001V313.52433333c0-161.11-131.07-292.184-292.18299999-292.184z"
        fill={getIconColor(color, 0, '#333333')}
      />
    </svg>
  );
};

KqJiankang.defaultProps = {
  size: 18,
};

export default KqJiankang;
