/* tslint:disable */
/* eslint-disable */

import React, { CSSProperties, SVGAttributes, FunctionComponent } from 'react';
import { getIconColor } from './helper';

interface Props extends Omit<SVGAttributes<SVGElement>, 'color'> {
  size?: number;
  color?: string | string[];
}

const DEFAULT_STYLE: CSSProperties = {
  display: 'block',
};

const KqLoading: FunctionComponent<Props> = ({ size, color, style: _style, ...rest }) => {
  const style = _style ? { ...DEFAULT_STYLE, ..._style } : DEFAULT_STYLE;

  return (
    <svg viewBox="0 0 1024 1024" width={size + 'px'} height={size + 'px'} style={style} {...rest}>
      <path
        d="M510.4 988.48c-64.42666667 0-126.93333333-12.58666667-185.81333333-37.54666667-56.85333333-24-107.84-58.45333333-151.68-102.29333333s-78.18666667-94.82666667-102.29333334-151.68C45.76 638.08 33.06666667 575.57333333 33.06666667 511.14666667s12.58666667-126.93333333 37.54666666-185.81333334c24-56.85333333 58.45333333-107.84 102.29333334-151.68S267.73333333 95.46666667 324.58666667 71.46666667c58.88-24.85333333 121.38666667-37.54666667 185.81333333-37.54666667 52.58666667 0 104.32 8.53333333 153.70666667 25.28 27.84 9.49333333 42.77333333 39.78666667 33.28 67.62666667-7.57333333 22.18666667-28.26666667 36.16-50.45333334 36.16-5.65333333 0-11.52-0.96-17.17333333-2.88-38.29333333-13.01333333-78.50666667-19.62666667-119.36-19.62666667-98.98666667 0-192 38.50666667-262.08 108.58666667C178.34666667 319.04 139.73333333 412.16 139.73333333 511.14666667c0 98.98666667 38.50666667 192 108.58666667 262.08 69.97333333 69.97333333 163.09333333 108.58666667 262.08 108.58666666s192-38.50666667 262.08-108.58666666C842.45333333 703.25333333 881.06666667 610.13333333 881.06666667 511.14666667c0-62.50666667-15.89333333-124.37333333-45.86666667-178.77333334-14.18666667-25.81333333-4.90666667-58.24 20.90666667-72.42666666 25.81333333-14.18666667 58.24-4.90666667 72.42666666 20.90666666 38.72 70.08 59.09333333 149.76 59.09333334 230.29333334 0 64.42666667-12.58666667 126.93333333-37.54666667 185.81333333-24 56.85333333-58.45333333 107.84-102.29333333 151.68-43.84 43.84-94.82666667 78.18666667-151.68 102.29333333-58.77333333 24.85333333-121.28 37.54666667-185.70666667 37.54666667z"
        fill={getIconColor(color, 0, '#333333')}
      />
    </svg>
  );
};

KqLoading.defaultProps = {
  size: 18,
};

export default KqLoading;
