/* tslint:disable */
/* eslint-disable */

import React, { CSSProperties, SVGAttributes, FunctionComponent } from 'react';
import { getIconColor } from './helper';

interface Props extends Omit<SVGAttributes<SVGElement>, 'color'> {
  size?: number;
  color?: string | string[];
}

const DEFAULT_STYLE: CSSProperties = {
  display: 'block',
};

const KqNotice: FunctionComponent<Props> = ({ size, color, style: _style, ...rest }) => {
  const style = _style ? { ...DEFAULT_STYLE, ..._style } : DEFAULT_STYLE;

  return (
    <svg viewBox="0 0 1024 1024" width={size + 'px'} height={size + 'px'} style={style} {...rest}>
      <path
        d="M533.48933531 66.03156543c-15.92282075-7.63777581-34.95253333-5.30760691-48.67463901 5.95487605L225.13031902 288.4332405H59.81778173c-11.9097521-0.12945383-23.30168889 4.53088395-31.58673383 12.9453827-8.54395259 8.41449876-13.33374419 19.93588939-13.3337442 31.97509532v361.56453926c0.51781531 24.20786569 19.93588939 43.75539358 44.14375506 44.53211653h167.77216l259.81383111 215.67007606c8.15559111 6.73159902 18.38244347 10.35630617 28.9976573 10.35630616 6.73159902 0 13.33374419-1.55344592 19.28862024-4.40143011 15.79336691-7.50832197 25.89076543-23.43114272 26.02021926-40.77795556V106.93897482c-0.12945383-17.47626667-10.22685235-33.26963358-26.02021926-40.77795557h-1.4239921z m174.11539752 225.63802074c-21.61878914-6.47269136-44.79102419 4.14252247-54.11169974 24.725681-9.32067555 20.58315852-2.07126124 44.92047803 16.95845136 56.95968394 47.25064691 28.99765728 74.43595061 81.68536494 70.5523358 136.96214914 0 106.92886124-63.43237531 142.14030222-65.37418272 143.69374814-20.32425086 12.03920592-27.96202667 37.80051753-17.47626667 59.03094519 10.48576 21.23042765 35.59980247 30.68055703 57.47749927 21.87769679 4.78979161-2.58907653 115.47281383-59.80766815 115.47281382-224.60239012 3.75416098-90.48822518-44.14375506-175.15102815-123.49895112-218.64751408z m140.58685631-132.43126519c-20.19479703-9.5795832-44.40266272-2.84798419-56.70077631 15.79336692-12.29811358 18.64135111-9.0617679 43.62593975 7.76722964 58.38367605 4.78979161 3.3657995 120.65096691 82.33263408 120.65096692 278.71408988 0 196.38145581-111.33029136 275.34829037-115.47281384 278.32572839-16.05227457 7.63777581-26.14967309 23.94895803-25.7613116 41.81358617 0.38836148 17.73517431 11.13302914 33.65799506 27.44421136 40.64850174 16.31118222 6.99050667 35.34089482 3.75416098 48.41573136-8.28504495 6.34323753-4.14252247 155.47404642-106.54049975 155.47404642-354.05621728s-154.05005431-347.4540721-160.65219951-351.46714073h-1.16508444z m0 0"
        fill={getIconColor(color, 0, '#333333')}
      />
    </svg>
  );
};

KqNotice.defaultProps = {
  size: 18,
};

export default KqNotice;
