/* tslint:disable */
/* eslint-disable */

import React, { CSSProperties, SVGAttributes, FunctionComponent } from 'react';
import { getIconColor } from './helper';

interface Props extends Omit<SVGAttributes<SVGElement>, 'color'> {
  size?: number;
  color?: string | string[];
}

const DEFAULT_STYLE: CSSProperties = {
  display: 'block',
};

const KqShoucang1: FunctionComponent<Props> = ({ size, color, style: _style, ...rest }) => {
  const style = _style ? { ...DEFAULT_STYLE, ..._style } : DEFAULT_STYLE;

  return (
    <svg viewBox="0 0 1024 1024" width={size + 'px'} height={size + 'px'} style={style} {...rest}>
      <path
        d="M785.06666667 998.05866667c-10.92266667 0-23.66577778-3.64088889-34.58844445-9.10222222l-236.65777777-118.3288889-238.47822223 118.3288889c-23.66577778 12.74311111-54.61333333 10.92266667-76.45866667-5.46133334-21.84533333-16.384-34.58844445-45.51111111-29.1271111-72.81777778l49.152-254.86222222L31.40266667 481.05244445C11.37777778 461.02755555 4.096 430.08 11.37777778 404.59377778c9.10222222-27.30666667 30.94755555-47.33155555 60.07466667-50.97244445l260.32355555-47.33155555 116.50844445-236.65777778c12.74311111-25.48622222 38.22933333-41.87022222 65.536-41.87022222s54.61333333 16.384 65.536 41.87022222l116.50844444 236.65777778 260.32355556 45.51111111c27.30666667 3.64088889 50.97244445 23.66577778 58.25422222 50.97244444 9.10222222 27.30666667 1.82044445 56.43377778-18.20444445 76.45866667L808.73244445 655.81511111l47.33155555 254.86222222c5.46133333 29.12711111-7.28177778 56.43377778-29.12711111 72.81777778-10.92266667 9.10222222-25.48622222 14.56355555-41.87022222 14.56355556z"
        fill={getIconColor(color, 0, '#333333')}
      />
    </svg>
  );
};

KqShoucang1.defaultProps = {
  size: 18,
};

export default KqShoucang1;
