/* eslint-disable @typescript-eslint/ban-ts-comment */
import React, { useEffect, useMemo, useRef } from 'react';
import { Image } from 'remax/one';
import dayjs, { Dayjs } from 'dayjs';
import QrCodeProps from './common';
// @ts-ignore
import QR from 'qrcode-base64';
import { getFileSystemManager, saveImageToPhotosAlbum } from 'remax/wechat';

export default ({
  content,
  className,
  onSetSrc,
  longTapSave,
  ...restProps
}: QrCodeProps) => {
  const src = useMemo(
    () =>
      QR.drawImg(content, {
        typeNumber: 4,
        errorCorrectLevel: 'L',
        size: 500,
      }),
    [content],
  );
  useEffect(() => {
    onSetSrc?.(src);
  }, [onSetSrc, src]);
  const timer = useRef<Dayjs>();
  return (
    <Image
      className={className}
      src={src}
      mode="aspectFill"
      onTouchStart={() => longTapSave && (timer.current = dayjs(new Date()))}
      onTouchEnd={() => {
        if (
          longTapSave &&
          timer.current &&
          dayjs(new Date()).diff(timer.current, 'second') > 2
        ) {
          // @ts-ignore
          const path = `${wx.env.USER_DATA_PATH}/${+new Date()}.png`;
          return getFileSystemManager().writeFile({
            filePath: path,
            data: src.slice(22),
            encoding: 'base64',
            success: () => saveImageToPhotosAlbum({ filePath: path }),
          });
        }
      }}
      {...restProps}
    />
  );
};
