% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Crossval_OmicsPLS.R
\name{crossval_o2m}
\alias{crossval_o2m}
\title{Cross-validate procedure for O2PLS}
\usage{
crossval_o2m(X, Y, a, ax, ay, nr_folds, nr_cores = 1, stripped = TRUE,
  p_thresh = 3000, q_thresh = p_thresh, tol = 1e-10,
  max_iterations = 100)
}
\arguments{
\item{X}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{Y}{Numeric matrix. Vectors will be coerced to matrix with \code{as.matrix} (if this is possible)}

\item{a}{Vector of positive integers. Denotes the numbers of joint components to consider.}

\item{ax}{Vector of non-negative integers. Denotes the numbers of X-specific components to consider.}

\item{ay}{Vector of non-negative integers. Denotes the numbers of Y-specific components to consider.}

\item{nr_folds}{Positive integer. Number of folds to consider. Note: \code{kcv=N} gives leave-one-out CV. Note that CV with less than two folds does not make sense.}

\item{nr_cores}{Positive integer. Number of cores to use for CV. You might want to use \code{\link{detectCores}()}. Defaults to 1.}

\item{stripped}{Logical. Use the stripped version of o2m (usually when cross-validating)?}

\item{p_thresh}{Integer. If \code{X} has more than \code{p_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{q_thresh}{Integer. If \code{Y} has more than \code{q_thresh} columns, a power method optimization is used, see \code{\link{o2m2}}}

\item{tol}{double. Threshold for power method iteration}

\item{max_iterations}{Integer, Maximum number of iterations for power method}
}
\value{
List of class \code{"cvo2m"} with the original and sorted Prediction errors and the number of folds used.
}
\description{
Cross-validate procedure for O2PLS
}
\details{
This is the standard CV approach. It minimizes the sum of the prediction errors of X and Y over a three-dimensional grid of integers.
Parallelization is possible on all platforms. On Windows it uses \code{\link{makePSOCKcluster}}, then exports all necessary objects to the workers,
 and then calls \code{\link{parLapply}}. On OSX and Linux the more friendly \code{\link{mclapply}} is used, which uses forking.
 A print method is defined, printing the minimizers and minimum in a readible way. Also the elapsed time is tracked and reported.
}
\examples{
local({
X = scale(jitter(tcrossprod(rnorm(100),runif(10))))
Y = scale(jitter(tcrossprod(rnorm(100),runif(10))))
crossval_o2m(X, Y, a = 1:4, ax = 1:2, ay = 1:2, 
             nr_folds = 5, nr_cores = 1)
})

}
