% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_stat_label.R
\name{add_stat_label}
\alias{add_stat_label}
\alias{add_stat_label.tbl_summary}
\alias{add_stat_label.tbl_svysummary}
\alias{add_stat_label.tbl_ard_summary}
\title{Add statistic labels}
\usage{
add_stat_label(x, ...)

\method{add_stat_label}{tbl_summary}(x, location = c("row", "column"), label = NULL, ...)

\method{add_stat_label}{tbl_svysummary}(x, location = c("row", "column"), label = NULL, ...)

\method{add_stat_label}{tbl_ard_summary}(x, location = c("row", "column"), label = NULL, ...)
}
\arguments{
\item{x}{(\code{tbl_summary})\cr
Object with class \code{'tbl_summary'} or with class \code{'tbl_svysummary'}}

\item{...}{These dots are for future extensions and must be empty.}

\item{location}{(\code{string})\cr
Location where statistic label will be included.
\code{"row"} (the default) to add the statistic label to the variable label row,
and \code{"column"} adds a column with the statistic label.}

\item{label}{(\code{\link[=syntax]{formula-list-selector}})\cr
indicates the updates to the statistic label, e.g. \code{label = all_categorical() ~ "No. (\%)"}.
When not specified, the default statistic labels are used.}
}
\value{
A \code{tbl_summary} or \code{tbl_svysummary} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}\cr
Adds or modifies labels describing the summary statistics presented for
each variable in a \code{\link[=tbl_summary]{tbl_summary()}} table.
}
\section{Tips}{


When using \code{add_stat_label(location='row')} with subsequent \code{tbl_merge()},
it's important to have somewhat of an understanding of the underlying
structure of the gtsummary table.
\code{add_stat_label(location='row')} works by adding a new column called
\code{"stat_label"} to \code{x$table_body}. The \code{"label"} and \code{"stat_label"}
columns are merged when the gtsummary table is printed.
The \code{tbl_merge()} function merges on the \code{"label"} column (among others),
which is typically the first column you see in a gtsummary table.
Therefore, when you want to merge a table that has run \code{add_stat_label(location='row')}
you need to match the \code{"label"} column values before the \code{"stat_column"}
is merged with it.

For example, the following two tables merge properly

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl1 <- trial \%>\% select(age, grade) |> tbl_summary() |> add_stat_label()
tbl2 <- lm(marker ~ age + grade, trial) |> tbl_regression()

tbl_merge(list(tbl1, tbl2))
}\if{html}{\out{</div>}}

The addition of the new \code{"stat_label"} column requires a default
labels for categorical variables, which is  \code{"No. (\%)"}. This
can be changed to either desired text or left blank using \code{NA_character_}.
The blank option is useful in the \code{location="row"} case to keep the
output for categorical variables identical what was produced without
a \code{"add_stat_label()"} function call.
}

\examples{
tbl <- trial |>
  dplyr::select(trt, age, grade, response) |>
  tbl_summary(by = trt)

# Example 1 ----------------------------------
# Add statistic presented to the variable label row
tbl |>
  add_stat_label(
    # update default statistic label for continuous variables
    label = all_continuous() ~ "med. (iqr)"
  )

# Example 2 ----------------------------------
tbl |>
  add_stat_label(
    # add a new column with statistic labels
    location = "column"
  )

# Example 3 ----------------------------------
trial |>
  select(age, grade, trt) |>
  tbl_summary(
    by = trt,
    type = all_continuous() ~ "continuous2",
    statistic = all_continuous() ~ c("{median} ({p25}, {p75})", "{min} - {max}"),
  ) |>
  add_stat_label(label = age ~ c("IQR", "Range"))
}
\author{
Daniel D. Sjoberg
}
