% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/select_helpers.R
\name{scoping_gtsummary}
\alias{scoping_gtsummary}
\alias{scope_table_body}
\alias{scope_header}
\title{Scoping for Table Body and Header}
\usage{
scope_table_body(table_body, data = NULL)

scope_header(table_body, header = NULL)
}
\arguments{
\item{table_body}{a data frame from \code{.$table_body}}

\item{data}{an optional data frame the attributes will be added to}

\item{header}{the header data frame from \code{.$table_styling$header}}
}
\value{
a data frame
}
\description{
\subsection{\code{scope_table_body()}}{

This function uses the information in \code{.$table_body} and adds them
as attributes to \code{data} (if passed). Once they've been assigned as
proper gtsummary attributes, gtsummary selectors like \code{all_continuous()}
will work properly.

Columns \code{c("var_type", "test_name", "contrasts_type")} and columns that
begin with \code{"selector_*"} are scoped. The values of these columns are
added as attributes to a data frame. For example, if \code{var_type='continuous'}
for variable \code{"age"}, then the attribute
\code{attr(.$age, 'gtsummary.var_type') <- 'continuous'} is set.
That attribute is then used in a selector like \code{all_continuous()}.
}

\subsection{\code{scope_header()}}{

This function takes information from \code{.$table_styling$header} and adds it
to \code{table_body}. Columns that begin with \code{'modify_selector_'} and the \code{hide}
column.
}
}
\examples{
tbl <- tbl_summary(trial, include = c(age, grade))

scope_table_body(tbl$table_body) |> select(all_continuous()) |> names()
}
\keyword{internal}
