% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optionstrat.R
\name{iv.calc}
\alias{iv.calc}
\title{Implied Volatility Calculation}
\usage{
iv.calc(type, price, s, x, t, r, d = 0)
}
\arguments{
\item{type}{String argument, either "call" or "put"}

\item{price}{Current price of the option}

\item{s}{Spot price of the underlying asset}

\item{x}{Strike Price of the underlying asset}

\item{t}{Time to expiration in years}

\item{r}{Annual continuously compounded risk-free rate}

\item{d}{Annual continuously compounded dividend yield}
}
\value{
Returns a single option's implied volatility
}
\description{
Computes the implied volatility of an option, either a call or put, given the option premium and key parameters
}
\examples{
iv.calc(type = "call", price = 2.93, s = 100, x = 100, t = (45/365), r = 0.02, d = 0)
}
