% Generated by roxygen2 (4.0.1): do not edit by hand
\name{list.parse}
\alias{list.parse}
\alias{list.parse.character}
\alias{list.parse.data.frame}
\alias{list.parse.default}
\alias{list.parse.matrix}
\title{Parse an object to be a list with identical structure}
\usage{
list.parse(x, ...)

\method{list.parse}{default}(x, ...)

\method{list.parse}{matrix}(x, ...)

\method{list.parse}{data.frame}(x, ...)

\method{list.parse}{character}(x, ..., type = NULL)
}
\arguments{
\item{x}{\code{The object}}

\item{...}{Additional parameters}

\item{type}{The type of data to parse.
Currently json and yaml are supported.
In default, \code{NULL} value will parse the character with
\code{list.parse.default}. Ignored when the length of \code{x}
is greater than 1.}
}
\description{
Parse an object to be a list with identical structure
}
\examples{
\dontrun{
x <- data.frame(a=1:3,type=c("A","C","B"))
list.parse(x)

x <- matrix(rnorm(1000),ncol=5)
rownames(x) <- paste0("item",1:nrow(x))
colnames(x) <- c("a","b","c","d","e")
list.parse(x)

z <- "
a:
  type: x
  class: A
  registered: yes
"
list.parse(z,type="yaml")
}
}

