% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gammCluster.R
\name{gammCluster}
\alias{gammCluster}
\title{Run a Generalized Additive Mixed Effects Model on the mean intensity over a region of interest}
\usage{
gammCluster(image, mask, fourdOut = NULL, formula, randomFormula, subjData,
  mc.preschedule = TRUE, ncores = 1, ...)
}
\arguments{
\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will call mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to mask. All clusters must be labeled with integers in the mask passed as an argument}

\item{fourdOut}{To be passed to mergeNifti, This is the path and file name without the suffix to save the fourd file. Default (NULL) means script won't write out 4D image.}

\item{formula}{Must be a formula passed to gamm4()}

\item{randomFormula}{Random effects formula passed to gamm4()}

\item{subjData}{Dataframe containing all the covariates used for the analysis}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{ncores}{Number of cores to use for the analysis}

\item{...}{Additional arguments passed to gamm4()}
}
\value{
Returns list of models fitted to the mean voxel intensity a region or interest.
}
\description{
This function is able to run a Generalized Additive Mixed Effects Model (GAMM) using the gamm4() function. 
All clusters or Regions of Interest must be labeled with integers in the mask passed as an argument.
}
\examples{


image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(c(rep(0,14),1,2), dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), id = rep(1:5,5))
fm1 <- "~ s(x)"
randomFormula <- "~(1|id)"
models <- gammCluster(image, mask, formula = fm1, 
                              randomFormula = randomFormula, subjData = covs, ncores = 1, REML=TRUE)
                              
}
