using Android.Views;
using Microsoft.Maui.Controls.Platform;
using AView = Android.Views.View;

namespace Microsoft.Maui.Controls.Compatibility.Platform.Android.FastRenderers
{
	internal class EffectControlProvider : IEffectControlProvider
	{
		readonly AView _control;
		readonly ViewGroup _container;

		public EffectControlProvider(AView control)
		{
			_control = control;
			_container = null;
		}

		public EffectControlProvider(AView control, ViewGroup container)
		{
			_control = control;
			_container = container;
		}

		public void RegisterEffect(Effect effect)
		{
			var platformEffect = effect as PlatformEffect;
			if (platformEffect == null)
			{
				return;
			}

			platformEffect.Container = _container;
			platformEffect.Control = _control;
		}
	}
}