/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.map.impl.client;

import com.hazelcast.client.ClientEndpoint;
import com.hazelcast.client.impl.client.BaseClientAddListenerRequest;
import com.hazelcast.map.impl.EntryEventFilter;
import com.hazelcast.map.impl.EventListenerFilter;
import com.hazelcast.map.impl.MapPortableHook;
import com.hazelcast.map.impl.MapService;
import com.hazelcast.map.impl.MapServiceContext;
import com.hazelcast.map.impl.client.ClientMapListener;
import com.hazelcast.map.impl.query.QueryEventFilter;
import com.hazelcast.nio.serialization.Data;
import com.hazelcast.query.Predicate;
import com.hazelcast.security.permission.MapPermission;
import com.hazelcast.spi.EventFilter;
import java.security.Permission;

public abstract class AbstractMapAddEntryListenerRequest
extends BaseClientAddListenerRequest {
    protected String name;
    protected Data key;
    protected boolean includeValue;
    protected int listenerFlags;

    public AbstractMapAddEntryListenerRequest() {
    }

    public AbstractMapAddEntryListenerRequest(String name, boolean includeValue, int listenerFlags) {
        this.name = name;
        this.includeValue = includeValue;
        this.listenerFlags = listenerFlags;
    }

    public AbstractMapAddEntryListenerRequest(String name, Data key, boolean includeValue, int listenerFlags) {
        this(name, includeValue, listenerFlags);
        this.key = key;
    }

    protected abstract Predicate getPredicate();

    public Object call() {
        MapService mapService = (MapService)this.getService();
        MapServiceContext mapServiceContext = mapService.getMapServiceContext();
        ClientEndpoint endpoint = this.getEndpoint();
        Object listener = this.newMapListener(endpoint);
        EventFilter eventFilter = this.getEventFilter();
        EventListenerFilter eventListenerFilter = new EventListenerFilter(this.listenerFlags, eventFilter);
        String registrationId = this.localOnly ? mapServiceContext.addLocalEventListener(listener, eventListenerFilter, this.name) : mapServiceContext.addEventListener(listener, eventListenerFilter, this.name);
        endpoint.addListenerDestroyAction("hz:impl:mapService", this.name, registrationId);
        return registrationId;
    }

    protected Object newMapListener(ClientEndpoint endpoint) {
        return new ClientMapListener(endpoint, this.getCallId());
    }

    protected EventFilter getEventFilter() {
        if (this.getPredicate() == null) {
            return new EntryEventFilter(this.includeValue, this.key);
        }
        return new QueryEventFilter(this.includeValue, this.key, this.getPredicate());
    }

    @Override
    public String getServiceName() {
        return "hz:impl:mapService";
    }

    @Override
    public int getFactoryId() {
        return MapPortableHook.F_ID;
    }

    @Override
    public Permission getRequiredPermission() {
        return new MapPermission(this.name, "listen");
    }

    @Override
    public String getDistributedObjectName() {
        return this.name;
    }
}

