/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.diag;

import com.google.common.base.CharMatcher;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import com.google.turbine.diag.LineMap;
import com.google.turbine.diag.SourceFile;

public class TurbineError
extends Error {
    final ErrorKind kind;

    public static TurbineError format(SourceFile source, int position, ErrorKind kind, Object ... args) {
        String path = (String)MoreObjects.firstNonNull((Object)source.path(), (Object)"<>");
        LineMap lineMap = LineMap.create(source.source());
        int lineNumber = lineMap.lineNumber(position);
        int column = lineMap.column(position);
        String message = kind.format(args);
        StringBuilder sb = new StringBuilder(path).append(":");
        sb.append(lineNumber).append(": error: ");
        sb.append(message.trim()).append(System.lineSeparator());
        sb.append(CharMatcher.breakingWhitespace().trimTrailingFrom((CharSequence)lineMap.line(position))).append(System.lineSeparator());
        sb.append(Strings.repeat((String)" ", (int)column)).append('^');
        String diagnostic = sb.toString();
        return new TurbineError(kind, diagnostic);
    }

    private TurbineError(ErrorKind kind, String diagnostic) {
        super(diagnostic);
        this.kind = kind;
    }

    public ErrorKind kind() {
        return this.kind;
    }

    public static enum ErrorKind {
        UNEXPECTED_INPUT("unexpected input: %c"),
        UNEXPECTED_IDENTIFIER("unexpected identifier '%s'"),
        UNEXPECTED_EOF("unexpected end of input"),
        EXPECTED_TOKEN("expected token %s"),
        INVALID_LITERAL("invalid literal: %s"),
        UNEXPECTED_TYPE_PARAMETER("unexpected type parameter %s"),
        SYMBOL_NOT_FOUND("symbol not found %s"),
        TYPE_PARAMETER_QUALIFIER("type parameter used as type qualifier"),
        UNEXPECTED_TOKEN("unexpected token: %s"),
        INVALID_ANNOTATION_ARGUMENT("invalid annotation argument"),
        CANNOT_RESOLVE("cannot resolve %s"),
        EXPRESSION_ERROR("could not evaluate constant expression"),
        CYCLIC_HIERARCHY("cycle in class hierarchy: %s"),
        NOT_AN_ANNOTATION("%s is not an annotation"),
        NONREPEATABLE_ANNOTATION("%s is not @Repeatable"),
        DUPLICATE_DECLARATION("duplicate declaration of %s");

        private final String message;

        private ErrorKind(String message) {
            this.message = message;
        }

        String format(Object ... args) {
            return String.format(this.message, args);
        }
    }
}

