/*
 * Decompiled with CFR 0.152.
 */
package com.google.turbine.options;

import com.google.common.base.CharMatcher;
import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.turbine.options.TurbineOptions;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.annotation.Nullable;

public class TurbineOptionsParser {
    private static final Splitter ARG_SPLITTER = Splitter.on((CharMatcher)CharMatcher.breakingWhitespace()).omitEmptyStrings().trimResults();

    public static TurbineOptions parse(Iterable<String> args) throws IOException {
        TurbineOptions.Builder builder = TurbineOptions.builder();
        TurbineOptionsParser.parse(builder, args);
        return builder.build();
    }

    public static void parse(TurbineOptions.Builder builder, Iterable<String> args) throws IOException {
        ArrayDeque<String> argumentDeque = new ArrayDeque<String>();
        TurbineOptionsParser.expandParamsFiles(argumentDeque, args);
        TurbineOptionsParser.parse(builder, argumentDeque);
    }

    private static void expandParamsFiles(Deque<String> argumentDeque, Iterable<String> args) throws IOException {
        for (String arg : args) {
            if (arg.isEmpty()) continue;
            if (arg.startsWith("@@")) {
                argumentDeque.addLast(arg.substring(1));
                continue;
            }
            if (arg.startsWith("@")) {
                Path paramsPath = Paths.get(arg.substring(1), new String[0]);
                if (!Files.exists(paramsPath, new LinkOption[0])) {
                    throw new AssertionError((Object)("params file does not exist: " + paramsPath));
                }
                Iterable split = ARG_SPLITTER.split((CharSequence)new String(Files.readAllBytes(paramsPath), StandardCharsets.UTF_8));
                if (Iterables.isEmpty((Iterable)split)) {
                    throw new AssertionError((Object)("empty params file: " + paramsPath));
                }
                TurbineOptionsParser.expandParamsFiles(argumentDeque, split);
                continue;
            }
            argumentDeque.addLast(arg);
        }
    }

    private static void parse(TurbineOptions.Builder builder, Deque<String> argumentDeque) {
        block38: while (!argumentDeque.isEmpty()) {
            String next;
            switch (next = argumentDeque.pollFirst()) {
                case "--output": {
                    builder.setOutput(TurbineOptionsParser.readOne(argumentDeque));
                    continue block38;
                }
                case "--source_jars": {
                    builder.setSourceJars((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block38;
                }
                case "--temp_dir": {
                    TurbineOptionsParser.readOne(argumentDeque);
                    continue block38;
                }
                case "--processors": {
                    builder.addProcessors((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block38;
                }
                case "--processorpath": {
                    builder.addProcessorPathEntries((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block38;
                }
                case "--classpath": {
                    builder.addClassPathEntries((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block38;
                }
                case "--bootclasspath": {
                    builder.addBootClassPathEntries((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block38;
                }
                case "--javacopts": {
                    builder.addAllJavacOpts((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    if (argumentDeque.isEmpty() || !argumentDeque.peekFirst().equals("--")) continue block38;
                    argumentDeque.removeFirst();
                    continue block38;
                }
                case "--sources": {
                    builder.addSources((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block38;
                }
                case "--output_deps": {
                    builder.setOutputDeps(TurbineOptionsParser.readOne(argumentDeque));
                    continue block38;
                }
                case "--direct_dependency": {
                    String jar = TurbineOptionsParser.readOne(argumentDeque);
                    String target = TurbineOptionsParser.readOne(argumentDeque);
                    builder.addDirectJarToTarget(jar, target);
                    if (argumentDeque.isEmpty() || argumentDeque.peekFirst().startsWith("--")) continue block38;
                    argumentDeque.removeFirst();
                    continue block38;
                }
                case "--indirect_dependency": {
                    String jar = TurbineOptionsParser.readOne(argumentDeque);
                    String target = TurbineOptionsParser.readOne(argumentDeque);
                    builder.addIndirectJarToTarget(jar, target);
                    if (argumentDeque.isEmpty() || argumentDeque.peekFirst().startsWith("--")) continue block38;
                    argumentDeque.removeFirst();
                    continue block38;
                }
                case "--deps_artifacts": {
                    builder.addAllDepsArtifacts((Iterable<String>)TurbineOptionsParser.readList(argumentDeque));
                    continue block38;
                }
                case "--target_label": {
                    builder.setTargetLabel(TurbineOptionsParser.readOne(argumentDeque));
                    continue block38;
                }
                case "--rule_kind": {
                    builder.setRuleKind(TurbineOptionsParser.readOne(argumentDeque));
                    continue block38;
                }
                case "--javac_fallback": {
                    builder.setJavacFallback(true);
                    continue block38;
                }
                case "--nojavac_fallback": {
                    builder.setJavacFallback(false);
                    continue block38;
                }
            }
            throw new IllegalArgumentException("unknown option: " + next);
        }
    }

    @Nullable
    private static String readOne(Deque<String> argumentDeque) {
        if (argumentDeque.isEmpty() || argumentDeque.peekFirst().startsWith("-")) {
            return null;
        }
        return argumentDeque.pollFirst();
    }

    private static ImmutableList<String> readList(Deque<String> argumentDeque) {
        ImmutableList.Builder result = ImmutableList.builder();
        while (!argumentDeque.isEmpty() && !argumentDeque.peekFirst().startsWith("--")) {
            result.add((Object)argumentDeque.pollFirst());
        }
        return result.build();
    }
}

