/*
 * Decompiled with CFR 0.152.
 */
package com.google.errorprone.fixes;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.io.CharStreams;
import com.google.errorprone.VisitorState;
import com.google.errorprone.apply.DescriptionBasedDiff;
import com.google.errorprone.apply.ImportOrganizer;
import com.google.errorprone.apply.SourceFile;
import com.google.errorprone.fixes.Fix;
import com.google.errorprone.fixes.SuggestedFix;
import com.google.errorprone.util.ASTHelpers;
import com.google.errorprone.util.ErrorProneToken;
import com.google.errorprone.util.ErrorProneTokens;
import com.google.errorprone.util.FindIdentifiers;
import com.sun.source.doctree.DocTree;
import com.sun.source.tree.AnnotationTree;
import com.sun.source.tree.AssignmentTree;
import com.sun.source.tree.ClassTree;
import com.sun.source.tree.ExpressionTree;
import com.sun.source.tree.MethodTree;
import com.sun.source.tree.ModifiersTree;
import com.sun.source.tree.NewArrayTree;
import com.sun.source.tree.Tree;
import com.sun.source.tree.VariableTree;
import com.sun.source.util.DocTreePath;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TreePath;
import com.sun.tools.javac.api.JavacTaskImpl;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.api.JavacTrees;
import com.sun.tools.javac.code.BoundKind;
import com.sun.tools.javac.code.Kinds;
import com.sun.tools.javac.code.Symbol;
import com.sun.tools.javac.code.Type;
import com.sun.tools.javac.code.TypeTag;
import com.sun.tools.javac.code.Types;
import com.sun.tools.javac.main.Arguments;
import com.sun.tools.javac.parser.Tokens;
import com.sun.tools.javac.tree.DCTree;
import com.sun.tools.javac.tree.JCTree;
import com.sun.tools.javac.tree.TreeScanner;
import com.sun.tools.javac.util.Context;
import com.sun.tools.javac.util.List;
import com.sun.tools.javac.util.Options;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Optional;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Nullable;
import javax.lang.model.element.ElementKind;
import javax.lang.model.element.Modifier;
import javax.lang.model.type.ArrayType;
import javax.lang.model.type.DeclaredType;
import javax.lang.model.type.TypeMirror;
import javax.lang.model.util.SimpleTypeVisitor8;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticCollector;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;

public class SuggestedFixes {
    @Nullable
    private static Modifier getTokModifierKind(ErrorProneToken tok) {
        switch (tok.kind()) {
            case PUBLIC: {
                return Modifier.PUBLIC;
            }
            case PROTECTED: {
                return Modifier.PROTECTED;
            }
            case PRIVATE: {
                return Modifier.PRIVATE;
            }
            case ABSTRACT: {
                return Modifier.ABSTRACT;
            }
            case STATIC: {
                return Modifier.STATIC;
            }
            case FINAL: {
                return Modifier.FINAL;
            }
            case TRANSIENT: {
                return Modifier.TRANSIENT;
            }
            case VOLATILE: {
                return Modifier.VOLATILE;
            }
            case SYNCHRONIZED: {
                return Modifier.SYNCHRONIZED;
            }
            case NATIVE: {
                return Modifier.NATIVE;
            }
            case STRICTFP: {
                return Modifier.STRICTFP;
            }
            case DEFAULT: {
                return Modifier.DEFAULT;
            }
        }
        return null;
    }

    public static Optional<SuggestedFix> addModifiers(Tree tree, VisitorState state, Modifier ... modifiers) {
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return Optional.empty();
        }
        Sets.SetView toAdd = Sets.difference(new TreeSet<Modifier>(Arrays.asList(modifiers)), originalModifiers.getFlags());
        if (originalModifiers.getFlags().isEmpty()) {
            int pos = state.getEndPosition(originalModifiers) != -1 ? state.getEndPosition(originalModifiers) + 1 : ((JCTree)tree).getStartPosition();
            int base = ((JCTree)tree).getStartPosition();
            Optional<Integer> insert = state.getTokensForNode(tree).stream().map(token -> token.pos() + base).filter(thisPos -> thisPos >= pos).findFirst();
            int insertPos = insert.orElse(pos);
            return Optional.of(SuggestedFix.replace(insertPos, insertPos, Joiner.on((char)' ').join((Iterable)toAdd) + " "));
        }
        TreeMap<Modifier, Integer> modifierPositions = new TreeMap<Modifier, Integer>();
        for (Modifier mod : toAdd) {
            modifierPositions.put(mod, -1);
        }
        java.util.List<ErrorProneToken> tokens = state.getTokensForNode(originalModifiers);
        int base = ((JCTree)((Object)originalModifiers)).getStartPosition();
        for (ErrorProneToken tok : tokens) {
            Modifier mod = SuggestedFixes.getTokModifierKind(tok);
            if (mod == null) continue;
            modifierPositions.put(mod, base + tok.pos());
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        ArrayList<Modifier> modifiersToWrite = new ArrayList<Modifier>();
        for (Modifier mod : modifierPositions.keySet()) {
            int p = (Integer)modifierPositions.get((Object)mod);
            if (p == -1) {
                modifiersToWrite.add(mod);
                continue;
            }
            if (modifiersToWrite.isEmpty()) continue;
            fix.replace(p, p, Joiner.on((char)' ').join(modifiersToWrite) + " ");
            modifiersToWrite.clear();
        }
        if (!modifiersToWrite.isEmpty()) {
            fix.postfixWith(originalModifiers, " " + Joiner.on((char)' ').join(modifiersToWrite));
        }
        return Optional.of(fix.build());
    }

    public static Optional<SuggestedFix> removeModifiers(Tree tree, VisitorState state, Modifier ... modifiers) {
        ImmutableSet toRemove = ImmutableSet.copyOf((Object[])modifiers);
        ModifiersTree originalModifiers = ASTHelpers.getModifiers(tree);
        if (originalModifiers == null) {
            return Optional.empty();
        }
        SuggestedFix.Builder fix = SuggestedFix.builder();
        java.util.List<ErrorProneToken> tokens = state.getTokensForNode(originalModifiers);
        int basePos = ((JCTree)((Object)originalModifiers)).getStartPosition();
        boolean empty = true;
        for (ErrorProneToken tok : tokens) {
            Modifier mod = SuggestedFixes.getTokModifierKind(tok);
            if (!toRemove.contains((Object)mod)) continue;
            empty = false;
            fix.replace(basePos + tok.pos(), basePos + tok.endPos() + 1, "");
            break;
        }
        if (empty) {
            return Optional.empty();
        }
        return Optional.of(fix.build());
    }

    public static String qualifyType(VisitorState state, SuggestedFix.Builder fix, Symbol sym) {
        if (sym.getKind() == ElementKind.TYPE_PARAMETER) {
            return sym.getSimpleName().toString();
        }
        ArrayDeque<String> names = new ArrayDeque<String>();
        Symbol curr = sym;
        while (curr != null) {
            names.addFirst(curr.getSimpleName().toString());
            Symbol found = FindIdentifiers.findIdent(curr.getSimpleName().toString(), state, Kinds.KindSelector.VAL_TYP);
            if (found == curr) break;
            if (curr.owner != null && curr.owner.getKind() == ElementKind.PACKAGE) {
                if (found != null) {
                    names.addFirst(curr.owner.getQualifiedName().toString());
                    break;
                }
                fix.addImport(curr.getQualifiedName().toString());
                break;
            }
            curr = curr.owner;
        }
        return Joiner.on((char)'.').join(names);
    }

    public static String qualifyType(final VisitorState state, SuggestedFix.Builder fix, TypeMirror type) {
        return type.accept(new SimpleTypeVisitor8<String, SuggestedFix.Builder>(){

            @Override
            protected String defaultAction(TypeMirror e, SuggestedFix.Builder builder) {
                return e.toString();
            }

            @Override
            public String visitArray(ArrayType t, SuggestedFix.Builder builder) {
                return t.getComponentType().accept(this, builder) + "[]";
            }

            @Override
            public String visitDeclared(DeclaredType t, SuggestedFix.Builder builder) {
                String baseType = SuggestedFixes.qualifyType(state, builder, ((Type)((Object)t)).tsym);
                if (t.getTypeArguments().isEmpty()) {
                    return baseType;
                }
                StringBuilder b = new StringBuilder(baseType);
                b.append('<');
                boolean started = false;
                for (TypeMirror typeMirror : t.getTypeArguments()) {
                    if (started) {
                        b.append(',');
                    }
                    b.append(typeMirror.accept(this, builder));
                    started = true;
                }
                b.append('>');
                return b.toString();
            }
        }, fix);
    }

    public static void replaceDocTree(SuggestedFix.Builder fix, DocTreePath docPath, String replacement) {
        DocTree leaf = docPath.getLeaf();
        Preconditions.checkArgument((boolean)(leaf instanceof DCTree.DCEndPosTree), (String)"no end position information for %s", (Object)((Object)leaf.getKind()));
        DCTree.DCEndPosTree node = (DCTree.DCEndPosTree)leaf;
        DCTree.DCDocComment comment = (DCTree.DCDocComment)docPath.getDocComment();
        fix.replace((int)node.getSourcePosition(comment), node.getEndPos(comment), replacement);
    }

    public static void qualifyDocReference(SuggestedFix.Builder fix, DocTreePath docPath, VisitorState state) {
        DocTree leaf = docPath.getLeaf();
        Preconditions.checkArgument((leaf.getKind() == DocTree.Kind.REFERENCE ? 1 : 0) != 0, (String)"expected a path to a reference, got %s instead", (Object)((Object)leaf.getKind()));
        DCTree.DCReference reference = (DCTree.DCReference)leaf;
        Symbol sym = (Symbol)JavacTrees.instance(state.context).getElement(docPath);
        if (sym == null) {
            return;
        }
        String refString = reference.toString();
        int idx = refString.indexOf(35);
        String qualifiedName = idx >= 0 ? sym.owner.getQualifiedName() + refString.substring(idx, refString.length()) : sym.getQualifiedName().toString();
        SuggestedFixes.replaceDocTree(fix, docPath, qualifiedName);
    }

    public static Fix addMembers(ClassTree classTree, VisitorState state, String firstMember, String ... otherMembers) {
        Preconditions.checkNotNull((Object)classTree);
        int classEndPosition = state.getEndPosition(classTree);
        StringBuilder stringBuilder = new StringBuilder();
        for (String memberSnippet : Lists.asList((Object)firstMember, (Object[])otherMembers)) {
            stringBuilder.append("\n\n").append(memberSnippet);
        }
        stringBuilder.append('\n');
        return SuggestedFix.replace(classEndPosition - 1, classEndPosition - 1, stringBuilder.toString());
    }

    public static SuggestedFix renameVariable(VariableTree tree, final String replacement, VisitorState state) {
        String name = tree.getName().toString();
        int typeLength = state.getSourceForNode(tree.getType()).length();
        int pos = ((JCTree)((Object)tree)).getStartPosition() + state.getSourceForNode(tree).indexOf(name, typeLength);
        final SuggestedFix.Builder fix = SuggestedFix.builder().replace(pos, pos + name.length(), replacement);
        final Symbol.VarSymbol sym = ASTHelpers.getSymbol(tree);
        ((JCTree)((Object)state.getPath().getCompilationUnit())).accept(new TreeScanner(){

            @Override
            public void visitIdent(JCTree.JCIdent tree) {
                if (sym.equals(ASTHelpers.getSymbol(tree))) {
                    fix.replace(tree, replacement);
                }
            }
        });
        return fix.build();
    }

    public static SuggestedFix renameMethod(MethodTree tree, String replacement, VisitorState state) {
        int basePos = ((JCTree)((Object)tree)).getStartPosition();
        int endPos = tree.getBody() != null ? ((JCTree)((Object)tree.getBody())).getStartPosition() : state.getEndPosition(tree);
        ImmutableList<ErrorProneToken> methodTokens = ErrorProneTokens.getTokens(state.getSourceCode().subSequence(basePos, endPos).toString(), state.context);
        for (ErrorProneToken token : methodTokens) {
            if (token.kind() != Tokens.TokenKind.IDENTIFIER || !token.name().equals(tree.getName())) continue;
            int nameStartPosition = basePos + token.pos();
            int nameEndPosition = basePos + token.endPos();
            return SuggestedFix.builder().replace(nameStartPosition, nameEndPosition, replacement).build();
        }
        throw new AssertionError();
    }

    public static Fix deleteExceptions(MethodTree tree, final VisitorState state, java.util.List<ExpressionTree> toDelete) {
        java.util.List<? extends ExpressionTree> trees = tree.getThrows();
        if (toDelete.size() == trees.size()) {
            return SuggestedFix.replace(SuggestedFixes.getThrowsPosition(tree, state) - 1, state.getEndPosition((Tree)Iterables.getLast(trees)), "");
        }
        String replacement = FluentIterable.from(tree.getThrows()).filter(Predicates.not((Predicate)Predicates.in(toDelete))).transform((Function)new Function<ExpressionTree, String>(){

            @Nullable
            public String apply(ExpressionTree input) {
                return state.getSourceForNode(input);
            }
        }).join(Joiner.on((String)", "));
        return SuggestedFix.replace(((JCTree)((Object)tree.getThrows().get(0))).getStartPosition(), state.getEndPosition((Tree)Iterables.getLast(tree.getThrows())), replacement);
    }

    private static int getThrowsPosition(MethodTree tree, VisitorState state) {
        for (ErrorProneToken token : state.getTokensForNode(tree)) {
            if (token.kind() != Tokens.TokenKind.THROWS) continue;
            return ((JCTree)((Object)tree)).getStartPosition() + token.pos();
        }
        throw new AssertionError();
    }

    @Nullable
    public static Fix addSuppressWarnings(VisitorState state, String warningToSuppress) {
        SuggestedFix.Builder fixBuilder = SuggestedFix.builder();
        SuggestedFixes.addSuppressWarnings(fixBuilder, state, warningToSuppress);
        return fixBuilder.isEmpty() ? null : fixBuilder.build();
    }

    public static void addSuppressWarnings(SuggestedFix.Builder fixBuilder, VisitorState state, String warningToSuppress) {
        Tree suppressibleNode = SuggestedFixes.suppressibleNode(state.getPath());
        if (suppressibleNode == null) {
            return;
        }
        SuppressWarnings existingAnnotation = ASTHelpers.getAnnotation(suppressibleNode, SuppressWarnings.class);
        if (existingAnnotation != null) {
            String[] values = existingAnnotation.value();
            if (Arrays.asList(values).contains(warningToSuppress)) {
                return;
            }
            AnnotationTree suppressAnnotationTree = ASTHelpers.getAnnotationWithSimpleName(SuggestedFixes.findAnnotationsTree(suppressibleNode), SuppressWarnings.class.getSimpleName());
            if (suppressAnnotationTree == null) {
                return;
            }
            fixBuilder.merge(SuggestedFixes.addValuesToAnnotationArgument(suppressAnnotationTree, "value", (Collection<String>)ImmutableList.of((Object)state.getTreeMaker().Literal(TypeTag.CLASS, warningToSuppress).toString()), state));
        } else {
            fixBuilder.prefixWith(suppressibleNode, "@SuppressWarnings(\"" + warningToSuppress + "\")\n");
        }
    }

    private static java.util.List<? extends AnnotationTree> findAnnotationsTree(Tree tree) {
        ModifiersTree maybeModifiers = ASTHelpers.getModifiers(tree);
        return maybeModifiers == null ? ImmutableList.of() : maybeModifiers.getAnnotations();
    }

    @Nullable
    private static Tree suppressibleNode(TreePath path) {
        return StreamSupport.stream(path.spliterator(), false).filter(tree -> tree instanceof MethodTree || tree instanceof ClassTree && ((ClassTree)tree).getSimpleName().length() != 0 || tree instanceof VariableTree).findFirst().orElse(null);
    }

    public static SuggestedFix.Builder addValuesToAnnotationArgument(AnnotationTree annotation, String parameterName, Collection<String> newValues, VisitorState state) {
        if (annotation.getArguments().isEmpty()) {
            String parameterPrefix = parameterName.equals("value") ? "" : parameterName + " = ";
            return SuggestedFix.builder().replace(annotation, annotation.toString().replaceFirst("\\(\\)", "(" + parameterPrefix + SuggestedFixes.newArgument(newValues) + ")"));
        }
        Optional<ExpressionTree> maybeExistingArgument = SuggestedFixes.findArgument(annotation, parameterName);
        if (!maybeExistingArgument.isPresent()) {
            return SuggestedFix.builder().prefixWith(annotation.getArguments().get(0), parameterName + " = " + SuggestedFixes.newArgument(newValues) + ", ");
        }
        ExpressionTree existingArgument = maybeExistingArgument.get();
        if (!existingArgument.getKind().equals((Object)Tree.Kind.NEW_ARRAY)) {
            return SuggestedFix.builder().replace(existingArgument, SuggestedFixes.newArgument(state.getSourceForNode(existingArgument), newValues));
        }
        NewArrayTree newArray = (NewArrayTree)existingArgument;
        if (newArray.getInitializers().isEmpty()) {
            return SuggestedFix.builder().replace(newArray, SuggestedFixes.newArgument(newValues));
        }
        return SuggestedFix.builder().postfixWith((Tree)Iterables.getLast(newArray.getInitializers()), ", " + Joiner.on((String)", ").join(newValues));
    }

    public static SuggestedFix.Builder updateAnnotationArgumentValues(AnnotationTree annotation, String parameterName, Collection<String> newValues) {
        if (annotation.getArguments().isEmpty()) {
            String parameterPrefix = parameterName.equals("value") ? "" : parameterName + " = ";
            return SuggestedFix.builder().replace(annotation, annotation.toString().replaceFirst("\\(\\)", "(" + parameterPrefix + SuggestedFixes.newArgument(newValues) + ")"));
        }
        Optional<ExpressionTree> maybeExistingArgument = SuggestedFixes.findArgument(annotation, parameterName);
        if (!maybeExistingArgument.isPresent()) {
            return SuggestedFix.builder().prefixWith(annotation.getArguments().get(0), parameterName + " = " + SuggestedFixes.newArgument(newValues) + ", ");
        }
        ExpressionTree existingArgument = maybeExistingArgument.get();
        return SuggestedFix.builder().replace(existingArgument, SuggestedFixes.newArgument(newValues));
    }

    private static String newArgument(String existingParameters, Collection<String> initializers) {
        return SuggestedFixes.newArgument((Collection<String>)ImmutableList.builder().add((Object)existingParameters).addAll(initializers).build());
    }

    private static String newArgument(Collection<String> initializers) {
        StringBuilder expression = new StringBuilder();
        if (initializers.size() > 1) {
            expression.append('{');
        }
        Joiner.on((String)", ").appendTo(expression, initializers);
        if (initializers.size() > 1) {
            expression.append('}');
        }
        return expression.toString();
    }

    private static Optional<ExpressionTree> findArgument(AnnotationTree annotation, String parameter) {
        for (ExpressionTree expressionTree : annotation.getArguments()) {
            AssignmentTree assignment;
            if (!expressionTree.getKind().equals((Object)Tree.Kind.ASSIGNMENT) || !(assignment = (AssignmentTree)expressionTree).getVariable().toString().equals(parameter)) continue;
            return Optional.of(ASTHelpers.stripParentheses(assignment.getExpression()));
        }
        return Optional.empty();
    }

    public static boolean compilesWithFix(Fix fix, VisitorState state) {
        if (fix.isEmpty()) {
            return true;
        }
        JCTree.JCCompilationUnit compilationUnit = (JCTree.JCCompilationUnit)state.getPath().getCompilationUnit();
        JavaFileObject modifiedFile = compilationUnit.getSourceFile();
        JavacTaskImpl javacTask = (JavacTaskImpl)state.context.get(JavacTask.class);
        if (javacTask == null) {
            throw new IllegalArgumentException("No JavacTask in context.");
        }
        Arguments arguments = Arguments.instance(javacTask.getContext());
        ArrayList<JavaFileObject> fileObjects = new ArrayList<JavaFileObject>(arguments.getFileObjects());
        for (int i = 0; i < fileObjects.size(); ++i) {
            SourceFile fixSource;
            JavaFileObject oldFile = (JavaFileObject)fileObjects.get(i);
            if (!modifiedFile.toUri().equals(oldFile.toUri())) continue;
            DescriptionBasedDiff diff = DescriptionBasedDiff.create(compilationUnit, ImportOrganizer.STATIC_FIRST_ORGANIZER);
            diff.handleFix(fix);
            try {
                fixSource = new SourceFile(modifiedFile.getName(), modifiedFile.getCharContent(false));
            }
            catch (IOException e) {
                return false;
            }
            diff.applyDifferences(fixSource);
            fileObjects.set(i, new SimpleJavaFileObject(modifiedFile.toUri(), JavaFileObject.Kind.SOURCE){

                @Override
                public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
                    return fixSource.getAsSequence();
                }
            });
            break;
        }
        DiagnosticCollector<JavaFileObject> diagnosticListener = new DiagnosticCollector<JavaFileObject>();
        Context context = new Context();
        Options.instance(context).putAll(Options.instance(javacTask.getContext()));
        context.put(Arguments.class, arguments);
        JavacTask newTask = JavacTool.create().getTask(CharStreams.nullWriter(), state.context.get(JavaFileManager.class), diagnosticListener, (Iterable<String>)ImmutableList.of(), arguments.getClassNames(), fileObjects, context);
        try {
            newTask.analyze();
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        return SuggestedFixes.countErrors(diagnosticListener) == 0L;
    }

    private static long countErrors(DiagnosticCollector<JavaFileObject> diagnosticCollector) {
        return diagnosticCollector.getDiagnostics().stream().filter(d -> d.getKind() == Diagnostic.Kind.ERROR).count();
    }

    public static String prettyType(final @Nullable VisitorState state, final @Nullable SuggestedFix.Builder fix, Type type) {
        return type.accept(new Types.DefaultTypeVisitor<String, Void>(){

            @Override
            public String visitWildcardType(Type.WildcardType t, Void unused) {
                StringBuilder sb = new StringBuilder();
                sb.append((Object)t.kind);
                if (t.kind != BoundKind.UNBOUND) {
                    sb.append(t.type.accept(this, null));
                }
                return sb.toString();
            }

            @Override
            public String visitClassType(Type.ClassType t, Void unused) {
                StringBuilder sb = new StringBuilder();
                if (state == null || fix == null) {
                    sb.append(t.tsym.getSimpleName());
                } else {
                    sb.append(SuggestedFixes.qualifyType(state, fix, t.tsym));
                }
                if (((List)t.getTypeArguments()).nonEmpty()) {
                    sb.append('<');
                    sb.append(t.getTypeArguments().stream().map(a -> a.accept(this, null)).collect(Collectors.joining(", ")));
                    sb.append(">");
                }
                return sb.toString();
            }

            @Override
            public String visitCapturedType(Type.CapturedType t, Void unused) {
                return t.wildcard.accept(this, null);
            }

            @Override
            public String visitArrayType(Type.ArrayType t, Void unused) {
                return t.elemtype.accept(this, null) + "[]";
            }

            @Override
            public String visitType(Type t, Void unused) {
                return t.toString();
            }
        }, null);
    }
}

