/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.truth;

import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.common.primitives.Doubles;
import com.google.common.truth.AbstractArraySubject;
import com.google.common.truth.Correspondence;
import com.google.common.truth.DoubleSubject;
import com.google.common.truth.FailureMetadata;
import com.google.common.truth.IterableSubject;
import com.google.common.truth.MathUtil;
import com.google.common.truth.Ordered;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.annotation.Nullable;

public final class PrimitiveDoubleArraySubject
extends AbstractArraySubject<PrimitiveDoubleArraySubject, double[]> {
    private static final Correspondence<Double, Number> EXACT_EQUALITY_CORRESPONDENCE = new Correspondence<Double, Number>(){

        @Override
        public boolean compare(Double actual, Number expected) {
            return actual.equals(PrimitiveDoubleArraySubject.checkedToDouble(expected));
        }

        @Override
        public String toString() {
            return "is exactly equal to";
        }
    };

    PrimitiveDoubleArraySubject(FailureMetadata metadata, @Nullable double[] o) {
        super(metadata, o);
    }

    @Override
    protected String underlyingType() {
        return "double";
    }

    @Override
    protected List<Double> listRepresentation() {
        return Doubles.asList((double[])((double[])this.actual()));
    }

    @Override
    public void isEqualTo(Object expected) {
        double[] actual = (double[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            double[] expectedArray = (double[])expected;
            if (!Arrays.equals(actual, expectedArray)) {
                this.fail("is equal to", (Object)Doubles.asList((double[])expectedArray));
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Deprecated
    public void isEqualTo(Object expected, double tolerance) {
        double[] actual = (double[])this.actual();
        if (actual == expected) {
            return;
        }
        try {
            double[] expectedArray = (double[])expected;
            if (expectedArray.length != actual.length) {
                this.failWithRawMessage("Arrays are of different lengths. expected: %s, actual %s", Doubles.asList((double[])expectedArray), Doubles.asList((double[])actual));
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expectedArray.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expectedArray[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (!unequalIndices.isEmpty()) {
                this.fail("is equal to", (Object)Doubles.asList((double[])expectedArray));
                return;
            }
        }
        catch (ClassCastException e) {
            this.failWithBadType(expected);
        }
    }

    @Override
    public void isNotEqualTo(Object expected) {
        double[] actual = (double[])this.actual();
        try {
            double[] expectedArray = (double[])expected;
            if (actual == expected || Arrays.equals(actual, expectedArray)) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Doubles.asList((double[])expectedArray));
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Deprecated
    public void isNotEqualTo(Object expectedArray, double tolerance) {
        double[] actual = (double[])this.actual();
        try {
            double[] expected = (double[])expectedArray;
            if (actual == expected) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Doubles.asList((double[])expected));
                return;
            }
            if (expected.length != actual.length) {
                return;
            }
            ArrayList<Integer> unequalIndices = new ArrayList<Integer>();
            for (int i = 0; i < expected.length; ++i) {
                if (MathUtil.equalWithinTolerance(actual[i], expected[i], tolerance)) continue;
                unequalIndices.add(i);
            }
            if (unequalIndices.isEmpty()) {
                this.failWithRawMessage("%s unexpectedly equal to %s.", this.actualAsString(), Doubles.asList((double[])expected));
                return;
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    @Deprecated
    public TolerantPrimitiveDoubleArrayComparison hasValuesWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.actual());
                ArrayList<Integer> mismatches = new ArrayList<Integer>();
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && !MathUtil.equalWithinTolerance(actual[expectedCount], number.doubleValue(), tolerance)) {
                        mismatches.add(expectedCount);
                    }
                    ++expectedCount;
                }
                if (actual.length != expectedCount) {
                    PrimitiveDoubleArraySubject.this.failWithRawMessage("Not true that %s has values within %s of <%s>. Expected length <%s> but got <%s>", PrimitiveDoubleArraySubject.this.actualAsString(), tolerance, Iterables.toString(expected), expectedCount, actual.length);
                    return;
                }
                if (!mismatches.isEmpty()) {
                    PrimitiveDoubleArraySubject.this.failWithBadResults("has values within " + tolerance + " of", Iterables.toString(expected), "differs at indexes", mismatches);
                    return;
                }
            }
        };
    }

    @Deprecated
    public TolerantPrimitiveDoubleArrayComparison hasValuesNotWithin(final double tolerance) {
        return new TolerantPrimitiveDoubleArrayComparison(){

            @Override
            public void ofElementsIn(Iterable<? extends Number> expected) {
                DoubleSubject.checkTolerance(tolerance);
                double[] actual = (double[])Preconditions.checkNotNull(PrimitiveDoubleArraySubject.this.actual());
                int expectedCount = 0;
                for (Number number : expected) {
                    if (expectedCount < actual.length && MathUtil.notEqualWithinTolerance(actual[expectedCount], number.doubleValue(), tolerance)) {
                        return;
                    }
                    ++expectedCount;
                }
                if (actual.length == expectedCount) {
                    PrimitiveDoubleArraySubject.this.fail("has values not within " + tolerance + " of", (Object)Iterables.toString(expected));
                }
            }
        };
    }

    public DoubleArrayAsIterable usingTolerance(double tolerance) {
        return new DoubleArrayAsIterable(Correspondence.tolerance(tolerance), this.iterableSubject());
    }

    private static double checkedToDouble(Number expected) {
        Preconditions.checkNotNull((Object)expected);
        Preconditions.checkArgument((expected instanceof Double || expected instanceof Float || expected instanceof Integer || expected instanceof Long ? 1 : 0) != 0, (String)"Expected value in assertion using exact double equality was of unsupported type %s (it may not have an exact double representation)", expected.getClass());
        if (expected instanceof Long) {
            Preconditions.checkArgument((Math.abs((Long)expected) <= 0x20000000000000L ? 1 : 0) != 0, (String)"Expected value %s in assertion using exact double equality was a long with an absolute value greater than 2^52 which has no exact double representation", (Object)expected);
        }
        return expected.doubleValue();
    }

    public DoubleArrayAsIterable usingExactEquality() {
        return new DoubleArrayAsIterable(EXACT_EQUALITY_CORRESPONDENCE, this.iterableSubject());
    }

    private IterableSubject iterableSubject() {
        return this.internalCustomName() != null ? (IterableSubject)this.check().that(this.listRepresentation()).named(this.internalCustomName(), new Object[0]) : this.check().that(this.listRepresentation());
    }

    public static final class DoubleArrayAsIterable
    extends IterableSubject.UsingCorrespondence<Double, Number> {
        DoubleArrayAsIterable(Correspondence<? super Double, Number> correspondence, IterableSubject subject) {
            IterableSubject iterableSubject = subject;
            iterableSubject.getClass();
            super(correspondence);
        }

        @CanIgnoreReturnValue
        public Ordered containsAllOf(double[] expected) {
            return this.containsAllIn(Doubles.asList((double[])expected));
        }

        public void containsAnyOf(double[] expected) {
            this.containsAnyIn(Doubles.asList((double[])expected));
        }

        @CanIgnoreReturnValue
        public Ordered containsExactly(double[] expected) {
            return this.containsExactlyElementsIn(Doubles.asList((double[])expected));
        }

        public void containsNoneOf(double[] excluded) {
            this.containsNoneIn(Doubles.asList((double[])excluded));
        }
    }

    public static abstract class TolerantPrimitiveDoubleArrayComparison {
        private TolerantPrimitiveDoubleArrayComparison() {
        }

        public void of(double ... expected) {
            this.ofElementsIn(Doubles.asList((double[])expected));
        }

        public abstract void ofElementsIn(Iterable<? extends Number> var1);

        @Deprecated
        public boolean equals(@Nullable Object o) {
            throw new UnsupportedOperationException("If you meant to compare double arrays, use .of() or .ofElementsIn() instead.");
        }

        @Deprecated
        public int hashCode() {
            throw new UnsupportedOperationException("Subject.hashCode() is not supported.");
        }
    }
}

