# AI21 

LiteLLM supports j2-light, j2-mid and j2-ultra from [AI21](https://www.ai21.com/studio/pricing).

They're available to use without a waitlist.

### API KEYS
```python
import os 
os.environ["AI21_API_KEY"] = "your-api-key"
```

### Sample Usage

```python
from litellm import completion 

# set env variable 
os.environ["AI21_API_KEY"] = "your-api-key"

messages = [{"role": "user", "content": "Write me a poem about the blue sky"}]

completion(model="j2-light", messages=messages)
```

### AI21 Models

| Model Name       | Function Call                              | Required OS Variables                |
|------------------|--------------------------------------------|--------------------------------------|
| j2-light         | `completion('j2-light', messages)`         | `os.environ['AI21_API_KEY']`         |
| j2-mid           | `completion('j2-mid', messages)`           | `os.environ['AI21_API_KEY']`         |
| j2-ultra         | `completion('j2-ultra', messages)`         | `os.environ['AI21_API_KEY']`         |