*   Added `:plain`, `:html` and `:body` option for `render` method. Please see
    Action Pack's release note for more detail.

    *Prem Sichanugrist*

*   Date select helpers accept a format string for the months selector via the
    new option `:month_format_string`.

    When rendered, the format string gets passed keys `:number` (integer), and
    `:name` (string), in order to be able to interpolate them as in

        '%{name} (%<number>02d)'

    for example.

    This option is motivated by #13618.

    *Xavier Noria*

*   Added `config.action_view.raise_on_missing_translations` to define whether an
    error should be raised for missing translations.

    Fixes #13196.

    *Kassio Borges*

*   Improved ERB dependency detection. New argument types and formattings for the `render`
    calls can be matched.

    Fixes #13074, #13116.

    *João Britto*

*   Use `display:none` instead of `display:inline` for hidden fields.

    Fixes #6403.

    *Gaelian Ditchburn*

*   The `video_tag` helper accepts a number as `:size`.

    The `:size` option of the `video_tag` helper now can be specified
    with a stringified number. The `width` and `height` attributes of
    the generated tag will be the same.

    *Kuldeep Aggarwal*

*   Escape format, negative_format and units options of number helpers

    Fixes: CVE-2014-0081

*   A Cycle object should accept an array and cycle through it as it would with a set of
    comma-separated objects.

        arr = [1,2,3]
        cycle(arr) # => '1'
        cycle(arr) # => '2'
        cycle(arr) # => '3'

    Previously, it would return the array as a string, because it took the array as a
    single object:

        arr = [1,2,3]
        cycle(arr) # => '[1,2,3]'
        cycle(arr) # => '[1,2,3]'
        cycle(arr) # => '[1,2,3]'

    *Kristian Freeman*

*   Label tags generated by collection helpers only inherit the `:index` and
    `:namespace` from the input, because only these attributes modifies the
    `for` attribute of the label. Also, the input attributes don't have
    precedence over the label attributes anymore.

    Before:

        collection = [[1, true, { class: 'foo' }]]
        f.collection_check_boxes :options, collection, :second, :first do |b|
          b.label(class: 'my_custom_class')
        end

        # => <label class="foo" for="user_active_true">1</label>

    After:

        collection = [[1, true, { class: 'foo' }]]
        f.collection_check_boxes :options, collection, :second, :first do |b|
          b.label(class: 'my_custom_class')
        end

        # => <label class="my_custom_class" for="user_active_true">1</label>

    *Andriel Nuernberg*

*   Fixed a long-standing bug in `json_escape` that causes quotation marks to be stripped.
    This method also escapes the \u2028 and \u2029 unicode newline characters which are
    treated as \n in JavaScript. This matches the behaviour of the AS::JSON encoder. (The
    original change in the encoder was introduced in #10534.)

    *Godfrey Chan*

*   `ActionView::MissingTemplate` includes underscore when raised for a partial.

    Fixes #13002.

    *Yves Senn*

*   Use `set_backtrace` instead of instance variable `@backtrace` in ActionView exceptions.

    *Shimpei Makimoto*

*   Fix `simple_format` escapes own output when passing `sanitize: true`.

    *Paul Seidemann*

*   Ensure `ActionView::Digestor.cache` is correctly cleaned up when
    combining recursive templates with `ActionView::Resolver.caching = false`.

    *wyaeld*

*   Fix `collection_check_boxes` generated hidden input to use the name attribute provided
    in the options hash.

    *Angel N. Sciortino*

*   Fix some edge cases for AV `select` helper with `:selected` option.

    *Bogdan Gusiev*

*   Ability to pass a block to the `select` helper.

    Example:

        <%= select(report, "campaign_ids") do %>
          <% available_campaigns.each do |c| -%>
            <%= content_tag(:option, c.name, value: c.id, data: { tags: c.tags.to_json }) %>
          <% end -%>
        <% end -%>

    *Bogdan Gusiev*

*   Handle `:namespace` form option in collection labels.

    *Vasiliy Ermolovich*

*   Fix `form_for` when both `namespace` and `as` options are present.

    `as` option no longer overwrites `namespace` option when generating
    html id attribute of the form element.

    *Adam Niedzielski*

*   Fix `excerpt` when `:separator` is `nil`.

    *Paul Nikitochkin*

*   Only cache template digests if `config.cache_template_loading` is true.

    *Josh Lauer*, *Justin Ridgewell*

*   Fixed a bug where the lookup details were not being taken into account
    when caching the digest of a template - changes to the details now
    cause a different cache key to be used.

    *Daniel Schierbeck*

*   Added an `extname` hash option for `javascript_include_tag` method.

    Before:

        javascript_include_tag('templates.jst')
        # => <script src="/javascripts/templates.jst.js"></script>

    After:

        javascript_include_tag('templates.jst', extname: false )
        # => <script src="/javascripts/templates.jst"></script>

    *Nathan Stitt*

*   Fix `current_page?` when the URL contains escaped characters and the
    original URL is using the hexadecimal lowercased.

    *Rafael Mendonça França*

*   Fix `text_area` to behave like `text_field` when `nil` is given as
    value.

    Before:

        f.text_field :field, value: nil #=> <input value="">
        f.text_area :field, value: nil  #=> <textarea>value of field</textarea>

    After:

        f.text_area :field, value: nil  #=> <textarea></textarea>

    *Joel Cogen*

*   Element of the `grouped_options_for_select` can
    optionally contain html attributes as the last element of the array.

        grouped_options_for_select(
          [["North America", [['United States','US'],"Canada"], data: { foo: 'bar' }]]
        )

    *Vasiliy Ermolovich*

*   Fix default rendered format problem when calling `render` without :content_type option.
    It should return :html. Fix #11393.

    *Gleb Mazovetskiy*, *Oleg*, *kennyj*

*   Fix `link_to` with block and url hashes.

    Before:

        link_to(action: 'bar', controller: 'foo') { content_tag(:span, 'Example site') }
        # => "<a action=\"bar\" controller=\"foo\"><span>Example site</span></a>"

    After:

        link_to(action: 'bar', controller: 'foo') { content_tag(:span, 'Example site') }
        # => "<a href=\"/foo/bar\"><span>Example site</span></a>"

    *Murahashi Sanemat Kenichi*

*   Fix "Stack Level Too Deep" error when redering recursive partials.

    Fixes #11340.

    *Rafael Mendonça França*

*   Added an `enforce_utf8` hash option for `form_tag` method.

    Control to output a hidden input tag with name `utf8` without monkey
    patching.

    Before:

        form_tag
        # => '<form>..<input name="utf8" type="hidden" value="&#x2713;" />..</form>'

    After:

        form_tag
        # => '<form>..<input name="utf8" type="hidden" value="&#x2713;" />..</form>'

        form_tag({}, { :enforce_utf8 => false })
        # => '<form>....</form>'

    *ma2gedev*

*   Remove the deprecated `include_seconds` argument from `distance_of_time_in_words`,
    pass in an `:include_seconds` hash option to use this feature.

    *Carlos Antonio da Silva*

*   Remove deprecated block passing to `FormBuilder#new`.

    *Vipul A M*

*   Pick `DateField` `DateTimeField` and `ColorField` values from stringified options allowing use of symbol keys with helpers.

    *Jon Rowe*

*   Remove the deprecated `prompt` argument from `grouped_options_for_select`,
    pass in a `:prompt` hash option to use this feature.

    *kennyj*

*   Always escape the result of `link_to_unless` method.

    Before:

        link_to_unless(true, '<b>Showing</b>', 'github.com')
        # => "<b>Showing</b>"

    After:

        link_to_unless(true, '<b>Showing</b>', 'github.com')
        # => "&lt;b&gt;Showing&lt;/b&gt;"

    *dtaniwaki*

*   Use a case insensitive URI Regexp for #asset_path.

    This fix a problem where the same asset path using different case are generating
    different URIs.

    Before:

        image_tag("HTTP://google.com")
        # => "<img alt=\"Google\" src=\"/assets/HTTP://google.com\" />"
        image_tag("http://google.com")
        # => "<img alt=\"Google\" src=\"http://google.com\" />"

    After:

        image_tag("HTTP://google.com")
        # => "<img alt=\"Google\" src=\"HTTP://google.com\" />"
        image_tag("http://google.com")
        # => "<img alt=\"Google\" src=\"http://google.com\" />"

    *David Celis*

*   Element of the `collection_check_boxes` and `collection_radio_buttons` can
    optionally contain html attributes as the last element of the array.

    *Vasiliy Ermolovich*

*   Update the HTML `BOOLEAN_ATTRIBUTES` in `ActionView::Helpers::TagHelper`
    to conform to the latest HTML 5.1 spec. Add attributes `allowfullscreen`,
    `default`, `inert`, `sortable`, `truespeed`, `typemustmatch`. Fix attribute
    `seamless` (previously misspelled `seemless`).

    *Alex Peattie*

*   Fix an issue where partials with a number in the filename weren't being digested for cache dependencies.

    *Bryan Ricker*

*   First release, ActionView extracted from ActionPack

    *Piotr Sarnacki*, *Łukasz Strzałkowski*

Please check [4-0-stable (ActionPack's CHANGELOG)](https://github.com/rails/rails/blob/4-0-stable/actionpack/CHANGELOG.md) for previous changes.
