from sklearn.linear_model import LogisticRegression
from sklearn.ensemble import RandomForestClassifier
from sklearn.ensemble import HistGradientBoostingClassifier
from sklearn.svm import SVC


def portfolio_mixed():
    mixed = [
        HistGradientBoostingClassifier(l2_regularization=1e-06,
                                       max_bins=255,
                                       max_iter=200,
                                       max_leaf_nodes=128,
                                       min_samples_leaf=50),
        RandomForestClassifier(criterion='entropy',
                               max_features=0.32778941525789984,
                               min_samples_split=5,
                               n_estimators=300),
        SVC(C=52.368035023140784, gamma=0.008051730038808798, kernel='rbf'),
        RandomForestClassifier(criterion='entropy',
                               max_features=0.07198156955074353,
                               min_samples_split=6,
                               n_estimators=500),
        LogisticRegression(C=0.1, max_iter=10000),
        SVC(C=170.5572031055097,
            coef0=0.7430320055311159,
            degree=2,
            gamma=0.049727598083142026,
            kernel='poly'),
        HistGradientBoostingClassifier(l2_regularization=0.001,
                                       max_bins=255,
                                       max_depth=18,
                                       max_iter=450,
                                       max_leaf_nodes=64,
                                       min_samples_leaf=9),
        HistGradientBoostingClassifier(l2_regularization=100.0,
                                       max_bins=255,
                                       max_depth=17,
                                       max_iter=200,
                                       max_leaf_nodes=128,
                                       min_samples_leaf=37),
        RandomForestClassifier(criterion='entropy',
                               max_features=0.27977761318292416,
                               n_estimators=500),
        SVC(C=2854.2115055717222,
            coef0=0.9097801350305286,
            degree=2,
            gamma=0.0594124208513135,
            kernel='rbf'),
        HistGradientBoostingClassifier(l2_regularization=0.1,
                                       max_bins=255,
                                       max_depth=11,
                                       max_iter=250,
                                       max_leaf_nodes=16,
                                       min_samples_leaf=13),
        SVC(C=2.653098517006086,
            coef0=-0.16118152154954246,
            degree=5,
            gamma=0.018933306231401107,
            kernel='rbf'),
        HistGradientBoostingClassifier(l2_regularization=1.0,
                                       max_bins=32,
                                       max_depth=18,
                                       max_iter=450,
                                       max_leaf_nodes=128,
                                       min_samples_leaf=5),
        SVC(C=49.496117538847585,
            coef0=-0.36888378135766664,
            degree=5,
            gamma=0.0013908089928613187,
            kernel='rbf'),
        HistGradientBoostingClassifier(l2_regularization=1e-10,
                                       learning_rate=0.01,
                                       max_bins=64,
                                       max_depth=6,
                                       max_iter=500,
                                       max_leaf_nodes=4,
                                       min_samples_leaf=19),
        RandomForestClassifier(criterion='entropy',
                               max_features=0.05298984247042704,
                               min_samples_leaf=2,
                               min_samples_split=7,
                               n_estimators=500),
        SVC(C=4297.397059178814,
            coef0=0.013499300518863278,
            degree=5,
            gamma=0.1820082271280914,
            kernel='rbf'),
        SVC(C=0.12779439580461893,
            coef0=-0.007860547843195675,
            degree=2,
            gamma=0.011489094638370643,
            kernel='sigmoid'),
        SVC(C=1.799125831143992,
            coef0=0.7926565732345652,
            gamma=0.01858955180141993,
            kernel='poly'),
        HistGradientBoostingClassifier(l2_regularization=1e-10,
                                       max_bins=255,
                                       max_depth=3,
                                       max_iter=400,
                                       max_leaf_nodes=128),
        HistGradientBoostingClassifier(l2_regularization=1.0,
                                       max_bins=128,
                                       max_depth=16,
                                       max_leaf_nodes=128,
                                       min_samples_leaf=10),
        HistGradientBoostingClassifier(l2_regularization=10.0,
                                       max_bins=64,
                                       max_depth=12,
                                       max_iter=200,
                                       max_leaf_nodes=64),
        SVC(C=100000.0, gamma=0.00241115807647, kernel='rbf'),
        HistGradientBoostingClassifier(l2_regularization=0.001,
                                       max_bins=255,
                                       max_depth=19,
                                       max_iter=300,
                                       max_leaf_nodes=128,
                                       min_samples_leaf=11),
        SVC(C=4.523994003904736,
            coef0=0.20331467465699182,
            degree=5,
            gamma=0.033987763661532146,
            kernel='rbf'),
        HistGradientBoostingClassifier(l2_regularization=1e-09,
                                       learning_rate=0.01,
                                       max_bins=64,
                                       max_iter=450,
                                       max_leaf_nodes=4,
                                       min_samples_leaf=3),
        RandomForestClassifier(max_features=0.04689506366408347,
                               n_estimators=300),
        SVC(C=0.4212172063086123,
            coef0=-0.30890982063706174,
            gamma=0.012608109887061762,
            kernel='poly'),
        HistGradientBoostingClassifier(l2_regularization=0.1,
                                       max_bins=255,
                                       max_depth=4,
                                       max_iter=350,
                                       max_leaf_nodes=128,
                                       min_samples_leaf=11),
        RandomForestClassifier(criterion='entropy',
                               max_features=0.3391406102951785,
                               min_samples_split=19,
                               n_estimators=100),
        HistGradientBoostingClassifier(l2_regularization=1e-10,
                                       max_bins=32,
                                       max_depth=9,
                                       max_iter=350,
                                       max_leaf_nodes=16,
                                       min_samples_leaf=18),
        SVC(C=3539.053405327911, gamma=0.2574787996118815, kernel='rbf')
    ]
    return (mixed)
