# Redux FAQ

## Table of Contents

- **General**
  - [When should I use Redux?](/docs/faq/General.md#general-when-to-use)
  - [Can Redux only be used with React?](/docs/faq/General.md#general-only-react)
  - [Do I need to have a particular build tool to use Redux?](/docs/faq/General.md#general-build-tools)
- **Reducers**
  - [How do I share state between two reducers? Do I have to use combineReducers?](/docs/faq/Reducers.md#reducers-share-state)
  - [Do I have to use the switch statement to handle actions?](/docs/faq/Reducers.md#reducers-use-switch)
- **Organizing State**
  - [Do I have to put all my state into Redux? Should I ever use React's setState()?](/docs/faq/OrganizingState.md#organizing-state-only-redux-state)
  - [Can I put functions, promises, or other non-serializable items in my store state?](/docs/faq/OrganizingState.md#organizing-state-non-serializable)
  - [How do I organize nested or duplicate data in my state?](/docs/faq/OrganizingState.md#organizing-state-nested-data)
- **Store Setup**
  - [Can or should I create multiple stores? Can I import my store directly, and use it in components myself?](/docs/faq/StoreSetup.md#store-setup-multiple-stores)
  - [Is it OK to have more than one middleware chain in my store enhancer? What is the difference between next and dispatch in a middleware function?](/docs/faq/StoreSetup.md#store-setup-middleware-chains)
  - [How do I subscribe to only a portion of the state? Can I get the dispatched action as part of the subscription?](/docs/faq/StoreSetup.md#store-setup-subscriptions)
- **Actions**
  - [Why should type be a string, or at least serializable? Why should my action types be constants?](/docs/faq/Actions.md#actions-string-constants)
  - [Is there always a one-to-one mapping between reducers and actions?](/docs/faq/Actions.md#actions-reducer-mappings)
  - [How can I represent “side effects” such as AJAX calls? Why do we need things like “action creators”, “thunks”, and “middleware” to do async behavior?](/docs/faq/Actions.md#actions-side-effects)
  - [Should I dispatch multiple actions in a row from one action creator?](/docs/faq/Actions.md#actions-multiple-actions)
- **Immutable Data**
  - [What are the benefits of Immutability?](/docs/faq/ImmutableData.md#benefits-of-immutability)
  - [Why is immutability required in Redux?](/docs/faq/ImmutableData.md#why-is-immutability-required)
  - [Do I have to use Immutable.JS?](/docs/faq/ImmutableData.md#do-i-have-to-use-immutable-js)
  - [What are the issues with using ES6 for immutable operations?](/docs/faq/ImmutableData.md#issues-with-es6-for-immutable-ops)
- **Using Immutable.JS with Redux**
  - [Why should I use an immutable-focused library such as Immutable.JS?](/docs/recipes/UsingImmutableJS.md#why-use-immutable-library)
  - [Why should I choose Immutable.JS as an immutable library?](/docs/recipes/UsingImmutableJS.md#why-choose-immutable-js)
  - [What are the issues with using Immutable.JS?](/docs/recipes/UsingImmutableJS.md#issues-with-immutable-js)
  - [Is Immutable.JS worth the effort?](/docs/recipes/UsingImmutableJS.md#is-immutable-js-worth-effort)
  - [What are some opinionated Best Practices for using Immutable.JS with Redux?](/docs/recipes/UsingImmutableJS.md#immutable-js-best-practices)

- **Code Structure**  
  - [What should my file structure look like? How should I group my action creators and reducers in my project? Where should my selectors go?](/docs/faq/CodeStructure.md#structure-file-structure)
  - [How should I split my logic between reducers and action creators? Where should my “business logic” go?](/docs/faq/CodeStructure.md#structure-business-logic)
- **Performance**
  - [How well does Redux “scale” in terms of performance and architecture?](/docs/faq/Performance.md#performance-scaling)
  - [Won't calling “all my reducers” for each action be slow?](/docs/faq/Performance.md#performance-all-reducers)
  - [Do I have to deep-clone my state in a reducer? Isn't copying my state going to be slow?](/docs/faq/Performance.md#performance-clone-state)
  - [How can I reduce the number of store update events?](/docs/faq/Performance.md#performance-update-events)
  - [Will having “one state tree” cause memory problems? Will dispatching many actions take up memory?](/docs/faq/Performance.md#performance-state-memory)
- **React Redux**
  - [Why isn't my component re-rendering, or my mapStateToProps running?](/docs/faq/ReactRedux.md#react-not-rerendering)
  - [Why is my component re-rendering too often?](/docs/faq/ReactRedux.md#react-rendering-too-often)
  - [How can I speed up my mapStateToProps?](/docs/faq/ReactRedux.md#react-mapstate-speed)
  - [Why don't I have this.props.dispatch available in my connected component?](/docs/faq/ReactRedux.md#react-props-dispatch)
  - [Should I only connect my top component, or can I connect multiple components in my tree?](/docs/faq/ReactRedux.md#react-multiple-components)
- **Miscellaneous**
  - [Are there any larger, “real” Redux projects?](/docs/faq/Miscellaneous.md#miscellaneous-real-projects)
  - [How can I implement authentication in Redux?](/docs/faq/Miscellaneous.md#miscellaneous-authentication)
