/*
Copyright 2019-2021 (c) Dappros Ltd, registered in England & Wales, registration number 11455432. All rights reserved.
You may not use this file except in compliance with the License.
You may obtain a copy of the License at https://github.com/dappros/ethora/blob/main/LICENSE.
*/

import * as types from '../constants/types';
import * as connectionURL from '../config/url';
import fetchFunction from '../config/api';
import {insertTransaction} from '../components/realmModels/transaction';
import {logOut} from './auth';
import {Alert} from 'react-native'

const hitAPI = new fetchFunction
 
export const fetchingWalletCommonRequest = () => ({
    type: types.FETCHING_WALLET_COMMON_REQUEST,
});

export const fetchingWalletCommonFailure = errorMsg => ({
    type: types.FETCHING_WALLET_COMMON_FAILURE,
    payload: errorMsg,
});

export const fetchTokenEtherBalance = data => ({
    type: types.FETCHING_TOKEN_ETHER_BALANCE_SUCCESS,
    payload: data,
});

export const fetchingOtherUserTokenBalance = data => ({
    type: types.FETCHING_OTHER_USER_TOKEN_BALANCE_SUCCESS,
    payload: data
})

export const transferTokensSuccess = (data) => ({
    type:types.TOKEN_TRANSFER_SUCCESS,
    payload: data
})

export const fetchingTransactionSuccess = data => ({
    type: types.FETCHING_TRANSACTION_SUCCESS,
    payload: data,
});

export const fetchingOtherUserTransactionSuccess = data => ({
    type: types.FETCHING_OTHER_USER_TRANSACTION_SUCCESS,
    payload: data
})

export const cancel = () => ({
    type: types.CANCEL,
});


const getTokenBalanceURL=(walletAddress,tokenName)=>{
    let modifiedURL = connectionURL.tokenEtherBalanceURL +walletAddress;
    return modifiedURL
}

export const fetchWalletBalance = (walletAddress, tokenName, token, isOwn) => {
    let url = getTokenBalanceURL(walletAddress, tokenName)
    return dispatch => {
        dispatch(fetchingWalletCommonRequest());
        try{
            hitAPI.fetchGet(url, token,()=>{
                dispatch(logOut());
            }, data =>{
                if(data.success === true){
                    console.log(data, 'asjkdkasdjlaks')
                    if(isOwn){
                        dispatch(fetchTokenEtherBalance(data));
                    }
                    else{
                        dispatch(fetchingOtherUserTokenBalance(data))
                    }
                }else{
                    console.log(data)
                    dispatch(fetchingWalletCommonFailure(data));
                }
            });
        } catch (error){
            console.log(error);
            dispatch(fetchingWalletCommonFailure('Something went wrong'));
        }
    }
}

export const transferTokens = (
    bodyData,
    token,
    fromWallet,
    senderName,
    receiverName,
    receiverMessageId,
    itemUrl
  ) => {
    let url = '';
    if (bodyData.tokenName && !itemUrl) {
      url = connectionURL.tokenTransferURL;
    } else if (itemUrl) {
      url = connectionURL.itemTransferURL;
  
    }else {
      url = connectionURL.etherTransferURL;
    }
    if(bodyData.nftId) {
      console.log(bodyData.tokenName, 'tokenjsdkfhdksjf')
      Alert.alert(
        'Item transfer',
        `You have successfully sent ${bodyData.tokenName}. After confirming the blockchain transaction, it will appear in the recipient's profile.`  ,
        [
          {text: 'Ok', onPress: () => console.log('ok')},
          
        ],
      );
    }
    return dispatch => {
      dispatch(fetchingWalletCommonRequest());
      try {
        hitAPI.fetchPost(url, bodyData, token, async() => {
          dispatch(logOut());
      }, async data => {
          
          if (data.success) {
            console.log('dasdsadasdasdffffafdgdfsd', bodyData)
  
            dispatch(
              transferTokensSuccess({
                success: true,
                senderName,
                receiverName,
                amount: bodyData.amount,
                receiverMessageId: receiverMessageId,
                tokenName: bodyData.tokenName
              }),
            );
            dispatch(fetchWalletBalance(fromWallet, null, token, true));
           
          } else {
            dispatch(fetchingWalletCommonFailure(data.msg));
          }
        });
      } catch (error) {
        dispatch(fetchingWalletCommonFailure(error));
      }
    };
  };

export const fetchTransaction = (walletAddress, token, isOwn) => {
    let url = connectionURL.transactionURL+"walletAddress="+walletAddress
    // let url = connectionURL.transactionURL
    return dispatch => {
        dispatch(fetchingWalletCommonRequest());
        try{
           walletAddress &&  hitAPI.fetchGet(url, token, ()=>{
                dispatch(logOut());
            }, (data) =>{
                if(data.success){

                    if(isOwn){
                        insertTransaction(data.transactions);
                        dispatch(fetchingTransactionSuccess(data));
                    }else{
                        dispatch(fetchingOtherUserTransactionSuccess(data));
                    }
                    
                }else{
                    dispatch(fetchingWalletCommonFailure(data));
                }
            })
        }catch(error){
            dispatch(fetchingWalletCommonFailure(error));
        }
    }
}
