# API Reference

```{eval-rst}
.. toctree::
  :maxdepth: 1
  :hidden:

  markdown
  inputs/index
  layouts/index
  plotting
  media/index
  diagrams
  status
  outputs
  control_flow
  html
  query_params
  cli_args
  state
  app
  cell
  miscellaneous
```

Use the marimo library in marimo notebooks (`import marimo as mo`) to

- connect interactive inputs like sliders, dropdowns, and tables to Python,
- express yourself with dynamically created markdown,
- layout information with tabs or grids,
- output media like images and audio,
- and more!

|                      |                                                           |
| :------------------- | :-------------------------------------------------------- |
| {doc}`markdown`      | Write markdown with `mo.md`                               |
| {doc}`inputs/index`  | Connect sliders, dropdowns, tables, and more to Python    |
| {doc}`layouts/index` | Customize outputs with accordions, tabs, stacks, and more |
| {doc}`plotting`      | Output interactive plots                                  |
| {doc}`media/index`   | Output media like images, audio, PDFs, and plain text     |
| {doc}`diagrams`      | Flow charts, graphs, statistic cards, and more            |
| {doc}`status`        | Display progress indicators                               |
| {doc}`outputs`       | Modify cell outputs, redirect console output              |
| {doc}`control_flow`  | Control how cells execute                                 |
| {doc}`html`          | Manipulate HTML objects                                   |
| {doc}`query_params`  | Access and set query parameters with `mo.query_params`    |
| {doc}`cli_args`      | Access command-line arguments with `mo.cli_args`          |
| {doc}`state`         | Synchronize multiple UI elements with `mo.state`          |
| {doc}`app`           | Embed notebooks in other notebooks                        |
| {doc}`cell`          | Run cells defined in another notebook                     |
| {doc}`miscellaneous` | Miscellaneous utilities                                   |
