# Guides

```{eval-rst}
.. toctree::
  :maxdepth: 2
  :hidden:

  overview
  reactivity
  interactivity
  sql
  apps
  scripts
  outputs
  dataframes
  plotting
  editor_features/index
  theming
  best_practices/index
  coming_from_jupyter
  integrating_with_marimo/index
  state
  wasm
  exporting
  configuration
  deploying/index
```

These guides cover marimo's core concepts.

| Guide                                | Description                                         |
| :----------------------------------- | :-------------------------------------------------- |
| {doc}`overview`                      | An overview of basic concepts                       |
| {doc}`reactivity`                    | How reactive execution works                        |
| {doc}`interactivity`                 | Using interactive UI elements                       |
| {doc}`sql`                           | Use SQL to query dataframes, databases, CSVs, etc.  |
| {doc}`apps`                          | Running notebooks as apps                           |
| {doc}`scripts`                       | Running notebooks as scripts                        |
| {doc}`outputs`                       | Markdown, plots, and other visual outputs           |
| {doc}`dataframes`                    | Working with dataframes                             |
| {doc}`plotting`                      | Interactive and reactive plots                      |
| {doc}`editor_features/index`         | View variables, cell dependencies, errors, and more |
| {doc}`theming`                       | Theming notebooks                                   |
| {doc}`best_practices/index`          | Notebook best practices                             |
| {doc}`coming_from_jupyter`           | marimo for Jupyter users                            |
| {doc}`integrating_with_marimo/index` | Rich displays of objects, custom UI plugins         |
| {doc}`state`                         | Mutable, reactive state                             |
| {doc}`wasm`                          | Create notebooks in our online playground!          |
| {doc}`exporting`                     | Exporting notebooks to HTML and flat scripts        |
| {doc}`configuration`                 | User and app configuration                          |
| {doc}`deploying/index`               | Deploying marimo notebooks and apps                 |

```{admonition} Learn by doing!
:class: tip

Prefer a hands-on learning experience? marimo comes packaged with interactive
tutorials that you can launch with `marimo tutorial` at the command line.
```
